/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.transform.AbstractContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformerRegistry;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.exec.RuntimeExec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeExecutableContentTransformer
extends AbstractContentTransformer {
    public static final String VAR_SOURCE = "source";
    public static final String VAR_TARGET = "target";
    private static Log logger = LogFactory.getLog(RuntimeExecutableContentTransformer.class);
    private boolean available;
    private RuntimeExec checkCommand;
    private RuntimeExec transformCommand;

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[ transform=").append(this.transformCommand).append("\n").append("]");
        return sb.toString();
    }

    public void setCheckCommand(RuntimeExec checkCommand) {
        this.checkCommand = checkCommand;
    }

    public void setTransformCommand(RuntimeExec transformCommand) {
        this.transformCommand = transformCommand;
    }

    public void setErrorCodes(String errCodesStr) {
        throw new AlfrescoRuntimeException("content.runtime_exec.property_moved");
    }

    @Override
    public void register() {
        if (this.transformCommand == null) {
            throw new AlfrescoRuntimeException("Mandatory property 'transformCommand' not set");
        }
        if (this.checkCommand != null) {
            RuntimeExec.ExecutionResult result = this.checkCommand.execute();
            this.available = result.getSuccess();
        } else {
            this.available = true;
        }
        super.register();
    }

    @Override
    public double getReliability(String sourceMimetype, String targetMimetype) {
        if (!this.available) {
            return 0.0;
        }
        ContentTransformerRegistry.TransformationKey transformationKey = new ContentTransformerRegistry.TransformationKey(sourceMimetype, targetMimetype);
        List<ContentTransformerRegistry.TransformationKey> explicitTransformations = this.getExplicitTransformations();
        if (explicitTransformations.size() == 0) {
            logger.warn((Object)("Property 'explicitTransformations' should be set to enable this transformer: \n   transformer: " + this));
        }
        if (explicitTransformations.contains(transformationKey)) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    protected final void transformInternal(ContentReader reader, ContentWriter writer, Map<String, Object> options) throws Exception {
        String sourceMimetype = this.getMimetype(reader);
        String targetMimetype = this.getMimetype(writer);
        String sourceExtension = this.getMimetypeService().getExtension(sourceMimetype);
        String targetExtension = this.getMimetypeService().getExtension(targetMimetype);
        if (sourceExtension == null || targetExtension == null) {
            throw new AlfrescoRuntimeException("Unknown extensions for mimetypes: \n   source mimetype: " + sourceMimetype + "\n" + "   source extension: " + sourceExtension + "\n" + "   target mimetype: " + targetMimetype + "\n" + "   target extension: " + targetExtension);
        }
        File sourceFile = TempFileProvider.createTempFile((String)(this.getClass().getSimpleName() + "_source_"), (String)("." + sourceExtension));
        File targetFile = TempFileProvider.createTempFile((String)(this.getClass().getSimpleName() + "_target_"), (String)("." + targetExtension));
        HashMap<String, String> properties = new HashMap<String, String>(5);
        for (Map.Entry<String, Object> entry : options.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            properties.put(key, value == null ? null : value.toString());
        }
        properties.put(VAR_SOURCE, sourceFile.getAbsolutePath());
        properties.put(VAR_TARGET, targetFile.getAbsolutePath());
        reader.getContent(sourceFile);
        RuntimeExec.ExecutionResult result = null;
        try {
            result = this.transformCommand.execute(properties);
        }
        catch (Throwable e) {
            throw new ContentIOException("Transformation failed during command execution: \n" + this.transformCommand, e);
        }
        if (!result.getSuccess()) {
            throw new ContentIOException("Transformation failed - status indicates an error: \n" + result);
        }
        if (!targetFile.exists()) {
            throw new ContentIOException("Transformation failed - target file doesn't exist: \n" + result);
        }
        writer.putContent(targetFile);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Transformation completed: \n   source: " + reader + "\n" + "   target: " + writer + "\n" + "   options: " + options + "\n" + "   result: \n" + result));
        }
    }
}

