/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.ContentTransformerRegistry;
import org.alfresco.repo.content.transform.RuntimeExecutableContentTransformer;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.util.BaseAlfrescoTestCase;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.exec.RuntimeExec;

public class RuntimeExecutableContentTransformerTest
extends BaseAlfrescoTestCase {
    private RuntimeExecutableContentTransformer transformer;

    protected void setUp() throws Exception {
        super.setUp();
        this.transformer = new RuntimeExecutableContentTransformer();
        RuntimeExec transformCommand = new RuntimeExec();
        HashMap<String, String> commandMap = new HashMap<String, String>(5);
        commandMap.put("Linux", "mv -f ${source} ${target}");
        commandMap.put(".*", "cmd /c copy /Y \"${source}\" \"${target}\"");
        transformCommand.setCommandMap(commandMap);
        transformCommand.setErrorCodes("1, 2");
        this.transformer.setTransformCommand(transformCommand);
        this.transformer.setMimetypeService(this.serviceRegistry.getMimetypeService());
        ArrayList<ContentTransformerRegistry.TransformationKey> explicitTranformations = new ArrayList<ContentTransformerRegistry.TransformationKey>(1);
        explicitTranformations.add(new ContentTransformerRegistry.TransformationKey("text/plain", "text/xml"));
        this.transformer.setExplicitTransformations(explicitTranformations);
        this.transformer.register();
    }

    public void testCopyCommand() throws Exception {
        String content = "<A><B></B></A>";
        File sourceFile = TempFileProvider.createTempFile((String)(this.getName() + "_"), (String)".txt");
        FileContentWriter tempWriter = new FileContentWriter(sourceFile);
        tempWriter.setMimetype("text/plain");
        tempWriter.putContent(content);
        ContentReader reader = tempWriter.getReader();
        File targetFile = TempFileProvider.createTempFile((String)(this.getName() + "_"), (String)".xml");
        FileContentWriter writer = new FileContentWriter(targetFile);
        writer.setMimetype("text/xml");
        this.transformer.transform(reader, writer);
        ContentReader checkReader = writer.getReader();
        String checkContent = checkReader.getContentString();
        RuntimeExecutableContentTransformerTest.assertEquals((String)"Content not copied", (String)content, (String)checkContent);
    }
}

