/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.alfresco.repo.content.transform.AbstractContentTransformer;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringExtractingContentTransformer
extends AbstractContentTransformer {
    public static final String PREFIX_TEXT = "text/";
    private static final Log logger = LogFactory.getLog(StringExtractingContentTransformer.class);

    @Override
    public double getReliability(String sourceMimetype, String targetMimetype) {
        if (!targetMimetype.equals("text/plain")) {
            return 0.0;
        }
        if (sourceMimetype.equals("text/plain")) {
            return 1.0;
        }
        if (sourceMimetype.startsWith(PREFIX_TEXT)) {
            return 0.1;
        }
        return 0.0;
    }

    @Override
    public void transformInternal(ContentReader reader, ContentWriter writer, Map<String, Object> options) throws Exception {
        this.transformText(reader, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transformText(ContentReader reader, ContentWriter writer) throws Exception {
        Reader charReader = null;
        Writer charWriter = null;
        try {
            charReader = reader.getEncoding() == null ? new InputStreamReader(reader.getContentInputStream()) : new InputStreamReader(reader.getContentInputStream(), reader.getEncoding());
            charWriter = writer.getEncoding() == null ? new OutputStreamWriter(writer.getContentOutputStream()) : new OutputStreamWriter(writer.getContentOutputStream(), writer.getEncoding());
            char[] buffer = new char[1024];
            int readCount = 0;
            while (readCount > -1) {
                charWriter.write(buffer, 0, readCount);
                readCount = charReader.read(buffer);
            }
        }
        finally {
            if (charReader != null) {
                try {
                    charReader.close();
                }
                catch (Throwable e) {
                    logger.error((Object)e);
                }
            }
            if (charWriter != null) {
                try {
                    charWriter.close();
                }
                catch (Throwable e) {
                    logger.error((Object)e);
                }
            }
        }
    }
}

