/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.alfresco.repo.content.transform.AbstractContentTransformer;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.textmining.text.extraction.WordExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextMiningContentTransformer
extends AbstractContentTransformer {
    private WordExtractor wordExtractor = new WordExtractor();

    @Override
    public double getReliability(String sourceMimetype, String targetMimetype) {
        if (!"application/msword".equals(sourceMimetype) || !"text/plain".equals(targetMimetype)) {
            return 0.0;
        }
        return 1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transformInternal(ContentReader reader, ContentWriter writer, Map<String, Object> options) throws Exception {
        InputStream is = null;
        String text = null;
        try {
            is = reader.getContentInputStream();
            text = this.wordExtractor.extractText(is);
        }
        catch (IOException e) {
            if (e.getMessage().contains("Unable to read entire header")) {
                text = "";
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        writer.putContent(text);
    }
}

