/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import java.io.InputStream;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.TextMiningContentTransformer;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextMiningContentTransformerTest
extends AbstractContentTransformerTest {
    private static final Log logger = LogFactory.getLog(TextMiningContentTransformerTest.class);
    private ContentTransformer transformer;

    public void onSetUpInTransaction() throws Exception {
        this.transformer = new TextMiningContentTransformer();
    }

    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return this.transformer;
    }

    public void testReliability() throws Exception {
        double reliability = 0.0;
        reliability = this.transformer.getReliability("text/plain", "application/msword");
        TextMiningContentTransformerTest.assertEquals((String)"Mimetype should not be supported", (Object)0.0, (Object)reliability);
        reliability = this.transformer.getReliability("application/msword", "text/plain");
        TextMiningContentTransformerTest.assertEquals((String)"Mimetype should be supported", (Object)1.0, (Object)reliability);
    }

    public void testBugFixAR1() throws Exception {
        File tempFile = TempFileProvider.createTempFile((String)(((Object)((Object)this)).getClass().getSimpleName() + "_" + this.getName() + "_"), (String)".doc");
        FileContentWriter writer = new FileContentWriter(tempFile);
        writer.setMimetype("application/msword");
        InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("farmers_markets_list_2003.doc");
        TextMiningContentTransformerTest.assertNotNull((Object)"Test resource not found: farmers_markets_list_2003.doc");
        writer.putContent(is);
        ContentReader reader = writer.getReader();
        tempFile = TempFileProvider.createTempFile((String)(((Object)((Object)this)).getClass().getSimpleName() + "_" + this.getName() + "_"), (String)".txt");
        writer = new FileContentWriter(tempFile);
        writer.setMimetype("text/plain");
        this.transformer.transform(reader, writer);
    }
}

