/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.Map;
import net.sf.joott.uno.DocumentConverter;
import net.sf.joott.uno.DocumentFormat;
import net.sf.joott.uno.UnoConnection;
import org.alfresco.repo.content.transform.AbstractContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformerRegistry;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.util.TempFileProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnoContentTransformer
extends AbstractContentTransformer {
    private static Map<ContentTransformerRegistry.TransformationKey, DocumentFormatWrapper> formatsByConversion = new HashMap<ContentTransformerRegistry.TransformationKey, DocumentFormatWrapper>(17);
    private String connectionUrl = "socket,host=localhost,port=8100,tcpNoDelay=1";
    private UnoConnection connection;
    private boolean isConnected = false;

    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public synchronized void init() {
        this.connection = new UnoConnection(this.connectionUrl);
        try {
            this.connection.connect();
            this.isConnected = true;
            super.register();
        }
        catch (ConnectException e) {
            this.isConnected = false;
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    private static DocumentFormatWrapper getDocumentFormatWrapper(String sourceMimetype, String targetMimetype) {
        ContentTransformerRegistry.TransformationKey key = new ContentTransformerRegistry.TransformationKey(sourceMimetype, targetMimetype);
        DocumentFormatWrapper wrapper = formatsByConversion.get(key);
        return wrapper;
    }

    @Override
    public double getReliability(String sourceMimetype, String targetMimetype) {
        if (!this.isConnected()) {
            return 0.0;
        }
        DocumentFormatWrapper docFormatWrapper = UnoContentTransformer.getDocumentFormatWrapper(sourceMimetype, targetMimetype);
        if (docFormatWrapper == null) {
            return 0.0;
        }
        return docFormatWrapper.getReliability();
    }

    @Override
    public void transformInternal(ContentReader reader, ContentWriter writer, Map<String, Object> options) throws Exception {
        String sourceMimetype = this.getMimetype(reader);
        String targetMimetype = this.getMimetype(writer);
        File tempFromFile = TempFileProvider.createTempFile((String)"UnoContentTransformer", (String)("." + this.getMimetypeService().getExtension(sourceMimetype)));
        File tempToFile = TempFileProvider.createTempFile((String)"UnoContentTransformer", (String)("." + this.getMimetypeService().getExtension(targetMimetype)));
        reader.getContent(tempFromFile);
        DocumentFormatWrapper docFormatWrapper = UnoContentTransformer.getDocumentFormatWrapper(sourceMimetype, targetMimetype);
        try {
            docFormatWrapper.execute(tempFromFile, tempToFile, this.connection);
        }
        catch (ConnectException e) {
            throw new ContentIOException("Connection to Uno server failed: \n   reader: " + reader + "\n" + "   writer: " + writer, e);
        }
        catch (IOException e) {
            throw new ContentIOException("Uno server conversion failed: \n   reader: " + reader + "\n" + "   writer: " + writer + "\n" + "   from file: " + tempFromFile + "\n" + "   to file: " + tempToFile, e);
        }
        writer.putContent(tempToFile);
    }

    static {
        formatsByConversion.put(new ContentTransformerRegistry.TransformationKey("application/vnd.oasis.opendocument.text", "text/plain"), new DocumentFormatWrapper(DocumentFormat.TEXT, 1.0));
        formatsByConversion.put(new ContentTransformerRegistry.TransformationKey("application/vnd.oasis.opendocument.text", "application/pdf"), new DocumentFormatWrapper(DocumentFormat.PDF_WRITER, 1.0));
        formatsByConversion.put(new ContentTransformerRegistry.TransformationKey("application/vnd.oasis.opendocument.spreadsheet", "application/pdf"), new DocumentFormatWrapper(DocumentFormat.PDF_CALC, 1.0));
        formatsByConversion.put(new ContentTransformerRegistry.TransformationKey("application/vnd.oasis.opendocument.presentation", "application/pdf"), new DocumentFormatWrapper(DocumentFormat.PDF_WRITER, 1.0));
        formatsByConversion.put(new ContentTransformerRegistry.TransformationKey("application/vnd.sun.xml.writer", "text/plain"), new DocumentFormatWrapper(DocumentFormat.TEXT, 1.0));
        formatsByConversion.put(new ContentTransformerRegistry.TransformationKey("application/vnd.sun.xml.writer", "application/pdf"), new DocumentFormatWrapper(DocumentFormat.PDF_WRITER, 1.0));
        formatsByConversion.put(new ContentTransformerRegistry.TransformationKey("application/vnd.sun.xml.calc", "application/pdf"), new DocumentFormatWrapper(DocumentFormat.PDF_WRITER, 1.0));
        formatsByConversion.put(new ContentTransformerRegistry.TransformationKey("application/vnd.sun.xml.draw", "application/pdf"), new DocumentFormatWrapper(DocumentFormat.PDF_IMPRESS, 1.0));
        formatsByConversion.put(new ContentTransformerRegistry.TransformationKey("application/vnd.sun.xml.impress", "application/pdf"), new DocumentFormatWrapper(DocumentFormat.PDF_IMPRESS, 1.0));
        formatsByConversion.put(new ContentTransformerRegistry.TransformationKey("application/vnd.stardivision.draw", "application/pdf"), new DocumentFormatWrapper(DocumentFormat.PDF_IMPRESS, 1.0));
        formatsByConversion.put(new ContentTransformerRegistry.TransformationKey("application/vnd.stardivision.calc", "application/pdf"), new DocumentFormatWrapper(DocumentFormat.PDF_CALC, 1.0));
        formatsByConversion.put(new ContentTransformerRegistry.TransformationKey("application/vnd.stardivision.chart", "application/pdf"), new DocumentFormatWrapper(DocumentFormat.PDF_WRITER, 1.0));
        formatsByConversion.put(new ContentTransformerRegistry.TransformationKey("application/vnd.stardivision.impress", "application/pdf"), new DocumentFormatWrapper(DocumentFormat.PDF_WRITER, 1.0));
        formatsByConversion.put(new ContentTransformerRegistry.TransformationKey("application/vnd.stardivision.impress-packed", "application/pdf"), new DocumentFormatWrapper(DocumentFormat.PDF_IMPRESS, 1.0));
        formatsByConversion.put(new ContentTransformerRegistry.TransformationKey("application/vnd.stardivision.writer", "application/pdf"), new DocumentFormatWrapper(DocumentFormat.PDF_WRITER, 1.0));
        formatsByConversion.put(new ContentTransformerRegistry.TransformationKey("application/vnd.stardivision.writer-global", "application/pdf"), new DocumentFormatWrapper(DocumentFormat.PDF_WRITER, 1.0));
        formatsByConversion.put(new ContentTransformerRegistry.TransformationKey("application/msword", "text/plain"), new DocumentFormatWrapper(DocumentFormat.TEXT, 1.0));
        formatsByConversion.put(new ContentTransformerRegistry.TransformationKey("application/msword", "application/pdf"), new DocumentFormatWrapper(DocumentFormat.PDF_WRITER, 1.0));
        formatsByConversion.put(new ContentTransformerRegistry.TransformationKey("application/vnd.excel", "application/pdf"), new DocumentFormatWrapper(DocumentFormat.PDF_CALC, 1.0));
        formatsByConversion.put(new ContentTransformerRegistry.TransformationKey("application/msword", "text/html"), new DocumentFormatWrapper(DocumentFormat.HTML_WRITER, 1.0));
        formatsByConversion.put(new ContentTransformerRegistry.TransformationKey("application/vnd.powerpoint", "application/x-shockwave-flash"), new DocumentFormatWrapper(DocumentFormat.FLASH_IMPRESS, 1.0));
        formatsByConversion.put(new ContentTransformerRegistry.TransformationKey("application/vnd.powerpoint", "application/pdf"), new DocumentFormatWrapper(DocumentFormat.PDF_IMPRESS, 1.0));
        formatsByConversion.put(new ContentTransformerRegistry.TransformationKey("text/plain", "text/html"), new DocumentFormatWrapper(DocumentFormat.HTML_WRITER, 1.0));
        formatsByConversion.put(new ContentTransformerRegistry.TransformationKey("text/plain", "application/pdf"), new DocumentFormatWrapper(DocumentFormat.PDF_WRITER, 1.0));
        formatsByConversion.put(new ContentTransformerRegistry.TransformationKey("text/plain", "application/msword"), new DocumentFormatWrapper(DocumentFormat.TEXT, 1.0));
        formatsByConversion.put(new ContentTransformerRegistry.TransformationKey("text/html", "application/pdf"), new DocumentFormatWrapper(DocumentFormat.PDF_WRITER_WEB, 1.0));
    }

    private static class DocumentFormatWrapper {
        private DocumentFormat documentFormat;
        private double reliability;

        public DocumentFormatWrapper(DocumentFormat documentFormat, double reliability) {
            this.documentFormat = documentFormat;
            this.reliability = reliability;
        }

        public double getReliability() {
            return this.reliability;
        }

        public void execute(File fromFile, File toFile, UnoConnection connection) throws ConnectException, IOException {
            DocumentConverter converter = new DocumentConverter(connection);
            converter.convert(fromFile, toFile, this.documentFormat);
        }
    }
}

