/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.UnoContentTransformer;

public class UnoContentTransformerTest
extends AbstractContentTransformerTest {
    private static String MIMETYPE_RUBBISH = "text/rubbish";
    private UnoContentTransformer transformer;

    public void onSetUpInTransaction() throws Exception {
        this.transformer = new UnoContentTransformer();
        this.transformer.setMimetypeService(this.mimetypeMap);
        this.transformer.init();
    }

    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return this.transformer;
    }

    public void testSetUp() throws Exception {
        super.testSetUp();
        UnoContentTransformerTest.assertNotNull((Object)this.mimetypeMap);
    }

    public void testReliability() throws Exception {
        if (!this.transformer.isConnected()) {
            return;
        }
        double reliability = 0.0;
        reliability = this.transformer.getReliability(MIMETYPE_RUBBISH, "text/plain");
        UnoContentTransformerTest.assertEquals((String)"Mimetype should not be supported", (Object)0.0, (Object)reliability);
        reliability = this.transformer.getReliability("text/plain", MIMETYPE_RUBBISH);
        UnoContentTransformerTest.assertEquals((String)"Mimetype should not be supported", (Object)0.0, (Object)reliability);
        reliability = this.transformer.getReliability("text/plain", "application/msword");
        UnoContentTransformerTest.assertEquals((String)"Mimetype should be supported", (Object)1.0, (Object)reliability);
        reliability = this.transformer.getReliability("application/msword", "text/plain");
        UnoContentTransformerTest.assertEquals((String)"Mimetype should be supported", (Object)1.0, (Object)reliability);
    }
}

