/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform.magick;

import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.AbstractContentTransformer;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractImageMagickContentTransformer
extends AbstractContentTransformer {
    public static final String MIMETYPE_IMAGE_PREFIX = "image/";
    private static final Log logger = LogFactory.getLog(AbstractImageMagickContentTransformer.class);
    private boolean available = false;

    public boolean isAvailable() {
        return this.available;
    }

    protected void setAvailable(boolean available) {
        this.available = available;
    }

    public void init() {
        if (this.getMimetypeService() == null) {
            throw new AlfrescoRuntimeException("MimetypeMap not present");
        }
        try {
            String resourcePath = "org/alfresco/repo/content/transform/magick/alfresco.gif";
            InputStream imageStream = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
            if (imageStream == null) {
                throw new AlfrescoRuntimeException("Sample image not found: " + resourcePath);
            }
            File inputFile = TempFileProvider.createTempFile((String)(this.getClass().getSimpleName() + "_init_source_"), (String)".gif");
            FileContentWriter writer = new FileContentWriter(inputFile);
            writer.putContent(imageStream);
            File outputFile = TempFileProvider.createTempFile((String)(this.getClass().getSimpleName() + "_init_target_"), (String)".png");
            Map<String, Object> options = Collections.emptyMap();
            this.transformInternal(inputFile, outputFile, options);
            if (!outputFile.exists()) {
                throw new Exception("Image conversion failed: \n   from: " + inputFile + "\n" + "   to: " + outputFile);
            }
            this.setAvailable(true);
            super.register();
        }
        catch (Throwable e) {
            logger.error((Object)(this.getClass().getSimpleName() + " not available: " + (e.getMessage() != null ? e.getMessage() : "")));
            logger.debug((Object)e);
        }
    }

    public static boolean isSupported(String mimetype) {
        if (!mimetype.startsWith(MIMETYPE_IMAGE_PREFIX)) {
            return false;
        }
        return !mimetype.equals("image/x-rgb");
    }

    @Override
    public double getReliability(String sourceMimetype, String targetMimetype) {
        if (!this.available) {
            return 0.0;
        }
        if (!AbstractImageMagickContentTransformer.isSupported(sourceMimetype) || !AbstractImageMagickContentTransformer.isSupported(targetMimetype)) {
            return 0.0;
        }
        return 1.0;
    }

    @Override
    protected final void transformInternal(ContentReader reader, ContentWriter writer, Map<String, Object> options) throws Exception {
        String sourceMimetype = this.getMimetype(reader);
        String targetMimetype = this.getMimetype(writer);
        String sourceExtension = this.getMimetypeService().getExtension(sourceMimetype);
        String targetExtension = this.getMimetypeService().getExtension(targetMimetype);
        if (sourceExtension == null || targetExtension == null) {
            throw new AlfrescoRuntimeException("Unknown extensions for mimetypes: \n   source mimetype: " + sourceMimetype + "\n" + "   source extension: " + sourceExtension + "\n" + "   target mimetype: " + targetMimetype + "\n" + "   target extension: " + targetExtension);
        }
        File sourceFile = TempFileProvider.createTempFile((String)(this.getClass().getSimpleName() + "_source_"), (String)("." + sourceExtension));
        File targetFile = TempFileProvider.createTempFile((String)(this.getClass().getSimpleName() + "_target_"), (String)("." + targetExtension));
        reader.getContent(sourceFile);
        this.transformInternal(sourceFile, targetFile, options);
        if (!targetFile.exists()) {
            throw new ContentIOException("JMagick transformation failed to write output file");
        }
        writer.putContent(targetFile);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Transformation completed: \n   source: " + reader + "\n" + "   target: " + writer + "\n" + "   options: " + options));
        }
    }

    protected abstract void transformInternal(File var1, File var2, Map<String, Object> var3) throws Exception;
}

