/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform.magick;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.transform.magick.AbstractImageMagickContentTransformer;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.util.exec.RuntimeExec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageMagickContentTransformer
extends AbstractImageMagickContentTransformer {
    public static final String KEY_OPTIONS = "options";
    public static final String VAR_OPTIONS = "options";
    public static final String VAR_SOURCE = "source";
    public static final String VAR_TARGET = "target";
    private static final Log logger = LogFactory.getLog(ImageMagickContentTransformer.class);
    private RuntimeExec executer;

    public void setExecuter(RuntimeExec executer) {
        this.executer = executer;
    }

    @Override
    public void init() {
        if (this.executer == null) {
            throw new AlfrescoRuntimeException("System runtime executer not set");
        }
        super.init();
    }

    @Override
    protected void transformInternal(File sourceFile, File targetFile, Map<String, Object> options) throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>(5);
        properties.put("options", (String)options.get("options"));
        properties.put(VAR_SOURCE, sourceFile.getAbsolutePath());
        properties.put(VAR_TARGET, targetFile.getAbsolutePath());
        RuntimeExec.ExecutionResult result = this.executer.execute(properties);
        if (result.getExitValue() != 0 && result.getStdErr() != null && result.getStdErr().length() > 0) {
            throw new ContentIOException("Failed to perform ImageMagick transformation: \n" + result);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ImageMagic executed successfully: \n" + this.executer));
        }
    }
}

