/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform.magick;

import java.util.Collections;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.magick.ImageMagickContentTransformer;
import org.alfresco.util.exec.RuntimeExec;

public class ImageMagickContentTransformerTest
extends AbstractContentTransformerTest {
    private ImageMagickContentTransformer transformer;

    public void onSetUpInTransaction() throws Exception {
        RuntimeExec executer = new RuntimeExec();
        executer.setCommand("imconvert.exe ${source} ${options} ${target}");
        executer.setDefaultProperties(Collections.singletonMap("options", ""));
        this.transformer = new ImageMagickContentTransformer();
        this.transformer.setMimetypeService(this.mimetypeMap);
        this.transformer.setExecuter(executer);
        this.transformer.init();
    }

    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return this.transformer;
    }

    public void testReliability() throws Exception {
        if (!this.transformer.isAvailable()) {
            return;
        }
        double reliability = 0.0;
        reliability = this.transformer.getReliability("image/gif", "text/plain");
        ImageMagickContentTransformerTest.assertEquals((String)"Mimetype should not be supported", (Object)0.0, (Object)reliability);
        reliability = this.transformer.getReliability("image/gif", "image/jpeg");
        ImageMagickContentTransformerTest.assertEquals((String)"Mimetype should be supported", (Object)1.0, (Object)reliability);
    }
}

