/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.copy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.policy.PolicyScope;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.InvalidTypeException;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.CopyServiceException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyServiceImpl
implements CopyService {
    private NodeService nodeService;
    private DictionaryService dictionaryService;
    private SearchService searchService;
    private PolicyComponent policyComponent;
    private RuleService ruleService;
    private ClassPolicyDelegate<CopyServicePolicies.OnCopyNodePolicy> onCopyNodeDelegate;
    private ClassPolicyDelegate<CopyServicePolicies.OnCopyCompletePolicy> onCopyCompleteDelegate;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void init() {
        this.onCopyNodeDelegate = this.policyComponent.registerClassPolicy(CopyServicePolicies.OnCopyNodePolicy.class);
        this.onCopyCompleteDelegate = this.policyComponent.registerClassPolicy(CopyServicePolicies.OnCopyCompletePolicy.class);
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onCopyNode"), ContentModel.ASPECT_COPIEDFROM, (Behaviour)new JavaBehaviour(this, "copyAspectOnCopy"));
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onCopyNode"), ContentModel.ASPECT_OWNABLE, (Behaviour)new JavaBehaviour(this, "onCopyOwnable"));
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onCopyNode"), ContentModel.ASPECT_AUTHOR, (Behaviour)new JavaBehaviour(this, "onCopyAuthor"));
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onCopyComplete"), ContentModel.ASPECT_COPIEDFROM, (Behaviour)new JavaBehaviour(this, "onCopyComplete"));
    }

    @Override
    public NodeRef copy(NodeRef sourceNodeRef, NodeRef destinationParent, QName destinationAssocTypeQName, QName destinationQName, boolean copyChildren) {
        ParameterCheck.mandatory((String)"Source Node", (Object)sourceNodeRef);
        ParameterCheck.mandatory((String)"Destination Parent", (Object)destinationParent);
        ParameterCheck.mandatory((String)"Destination Association Name", (Object)destinationQName);
        if (!sourceNodeRef.getStoreRef().equals(destinationParent.getStoreRef())) {
            throw new UnsupportedOperationException("Copying nodes across stores is not currently supported.");
        }
        HashMap<NodeRef, NodeRef> copiedChildren = new HashMap<NodeRef, NodeRef>();
        NodeRef copy = this.recursiveCopy(sourceNodeRef, destinationParent, destinationAssocTypeQName, destinationQName, copyChildren, copiedChildren);
        for (Map.Entry entry : copiedChildren.entrySet()) {
            this.invokeCopyComplete((NodeRef)entry.getKey(), (NodeRef)entry.getValue(), true, copiedChildren);
        }
        return copy;
    }

    private void invokeCopyComplete(NodeRef sourceNodeRef, NodeRef destinationNodeRef, boolean copyToNewNode, Map<NodeRef, NodeRef> copiedNodeRefs) {
        QName sourceClassRef = this.nodeService.getType(sourceNodeRef);
        this.invokeCopyComplete(sourceClassRef, sourceNodeRef, destinationNodeRef, copyToNewNode, copiedNodeRefs);
        Set<QName> sourceAspects = this.nodeService.getAspects(sourceNodeRef);
        for (QName sourceAspect : sourceAspects) {
            this.invokeCopyComplete(sourceAspect, sourceNodeRef, destinationNodeRef, copyToNewNode, copiedNodeRefs);
        }
    }

    private void invokeCopyComplete(QName typeQName, NodeRef sourceNodeRef, NodeRef destinationNodeRef, boolean copyToNewNode, Map<NodeRef, NodeRef> copiedNodeRefs) {
        Collection<CopyServicePolicies.OnCopyCompletePolicy> policies = this.onCopyCompleteDelegate.getList(typeQName);
        if (policies.isEmpty()) {
            this.defaultOnCopyComplete(typeQName, sourceNodeRef, destinationNodeRef, copiedNodeRefs);
        } else {
            for (CopyServicePolicies.OnCopyCompletePolicy policy : policies) {
                policy.onCopyComplete(typeQName, sourceNodeRef, destinationNodeRef, copyToNewNode, copiedNodeRefs);
            }
        }
    }

    private void defaultOnCopyComplete(QName typeQName, NodeRef sourceNodeRef, NodeRef destinationNodeRef, Map<NodeRef, NodeRef> copiedNodeRefs) {
        ClassDefinition classDefinition = this.dictionaryService.getClass(typeQName);
        if (classDefinition != null) {
            Map<QName, PropertyDefinition> propertyDefinitions = classDefinition.getProperties();
            for (Map.Entry<QName, PropertyDefinition> entry : propertyDefinitions.entrySet()) {
                NodeRef nodeRef;
                Serializable value;
                QName propertyTypeDefinition = entry.getValue().getDataType().getName();
                if (!DataTypeDefinition.NODE_REF.equals(propertyTypeDefinition) && !DataTypeDefinition.ANY.equals(propertyTypeDefinition) || (value = this.nodeService.getProperty(destinationNodeRef, entry.getKey())) == null || !(value instanceof NodeRef) || !copiedNodeRefs.containsKey(nodeRef = (NodeRef)value)) continue;
                NodeRef copiedNodeRef = copiedNodeRefs.get(nodeRef);
                this.nodeService.setProperty(destinationNodeRef, entry.getKey(), copiedNodeRef);
            }
            Map<QName, AssociationDefinition> assocDefs = classDefinition.getAssociations();
            List<ChildAssociationRef> childAssocRefs = this.nodeService.getChildAssocs(destinationNodeRef);
            for (ChildAssociationRef childAssocRef : childAssocRefs) {
                if (!assocDefs.containsKey(childAssocRef.getTypeQName()) || childAssocRef.isPrimary() || !copiedNodeRefs.containsKey(childAssocRef.getChildRef())) continue;
                this.nodeService.removeChild(destinationNodeRef, childAssocRef.getChildRef());
                this.nodeService.addChild(destinationNodeRef, copiedNodeRefs.get(childAssocRef.getChildRef()), childAssocRef.getTypeQName(), childAssocRef.getQName());
            }
            List<AssociationRef> nodeAssocRefs = this.nodeService.getTargetAssocs(destinationNodeRef, RegexQNamePattern.MATCH_ALL);
            for (AssociationRef nodeAssocRef : nodeAssocRefs) {
                if (!assocDefs.containsKey(nodeAssocRef.getTypeQName()) || !copiedNodeRefs.containsKey(nodeAssocRef.getTargetRef())) continue;
                this.nodeService.removeAssociation(destinationNodeRef, nodeAssocRef.getTargetRef(), nodeAssocRef.getTypeQName());
                this.nodeService.createAssociation(destinationNodeRef, copiedNodeRefs.get(nodeAssocRef.getTargetRef()), nodeAssocRef.getTypeQName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeRef recursiveCopy(NodeRef sourceNodeRef, NodeRef destinationParent, QName destinationAssocTypeQName, QName destinationQName, boolean copyChildren, Map<NodeRef, NodeRef> copiedChildren) {
        QName sourceTypeRef = this.nodeService.getType(sourceNodeRef);
        TypeDefinition typeDef = this.dictionaryService.getType(sourceTypeRef);
        if (typeDef == null) {
            throw new InvalidTypeException(sourceTypeRef);
        }
        PolicyScope copyDetails = this.getCopyDetails(sourceNodeRef, destinationParent.getStoreRef(), true);
        Map<QName, Serializable> typeProps = copyDetails.getProperties();
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        if (typeProps != null) {
            properties.putAll(typeProps);
        }
        for (AspectDefinition aspectDef : typeDef.getDefaultAspects()) {
            Map<QName, Serializable> aspectProps = copyDetails.getProperties(aspectDef.getName());
            if (aspectProps == null) continue;
            properties.putAll(aspectProps);
        }
        ChildAssociationRef destinationChildAssocRef = this.nodeService.createNode(destinationParent, destinationAssocTypeQName, destinationQName, sourceTypeRef, properties);
        NodeRef destinationNodeRef = destinationChildAssocRef.getChildRef();
        copiedChildren.put(sourceNodeRef, destinationNodeRef);
        this.ruleService.disableRules(destinationNodeRef);
        try {
            HashMap<QName, Serializable> copyProperties = new HashMap<QName, Serializable>();
            copyProperties.put(ContentModel.PROP_COPY_REFERENCE, sourceNodeRef);
            this.nodeService.addAspect(destinationNodeRef, ContentModel.ASPECT_COPIEDFROM, copyProperties);
            this.copyAspects(destinationNodeRef, copyDetails);
            this.copyAssociations(destinationNodeRef, copyDetails, copyChildren, copiedChildren);
        }
        finally {
            this.ruleService.enableRules(destinationNodeRef);
        }
        return destinationNodeRef;
    }

    private PolicyScope getCopyDetails(NodeRef sourceNodeRef, StoreRef destinationStoreRef, boolean copyToNewNode) {
        QName sourceClassRef = this.nodeService.getType(sourceNodeRef);
        PolicyScope copyDetails = new PolicyScope(sourceClassRef);
        this.invokeOnCopy(sourceClassRef, sourceNodeRef, destinationStoreRef, copyToNewNode, copyDetails);
        Set<QName> sourceAspects = this.nodeService.getAspects(sourceNodeRef);
        for (QName sourceAspect : sourceAspects) {
            this.invokeOnCopy(sourceAspect, sourceNodeRef, destinationStoreRef, copyToNewNode, copyDetails);
        }
        return copyDetails;
    }

    private void invokeOnCopy(QName sourceClassRef, NodeRef sourceNodeRef, StoreRef destinationStoreRef, boolean copyToNewNode, PolicyScope copyDetails) {
        Collection<CopyServicePolicies.OnCopyNodePolicy> policies = this.onCopyNodeDelegate.getList(sourceClassRef);
        if (policies.isEmpty()) {
            this.defaultOnCopy(sourceClassRef, sourceNodeRef, copyDetails);
        } else {
            for (CopyServicePolicies.OnCopyNodePolicy policy : policies) {
                policy.onCopyNode(sourceClassRef, sourceNodeRef, destinationStoreRef, copyToNewNode, copyDetails);
            }
        }
    }

    private void defaultOnCopy(QName classRef, NodeRef sourceNodeRef, PolicyScope copyDetails) {
        ClassDefinition classDefinition = this.dictionaryService.getClass(classRef);
        if (classDefinition != null) {
            Map<QName, PropertyDefinition> propertyDefinitions = classDefinition.getProperties();
            for (QName propertyName : propertyDefinitions.keySet()) {
                Serializable propValue = this.nodeService.getProperty(sourceNodeRef, propertyName);
                copyDetails.addProperty(classDefinition.getName(), propertyName, propValue);
            }
            Map<QName, AssociationDefinition> assocDefs = classDefinition.getAssociations();
            if (classDefinition.isContainer()) {
                List<ChildAssociationRef> childAssocRefs = this.nodeService.getChildAssocs(sourceNodeRef);
                for (ChildAssociationRef childAssocRef : childAssocRefs) {
                    if (!assocDefs.containsKey(childAssocRef.getTypeQName())) continue;
                    copyDetails.addChildAssociation(classDefinition.getName(), childAssocRef);
                }
            }
            List<AssociationRef> nodeAssocRefs = this.nodeService.getTargetAssocs(sourceNodeRef, RegexQNamePattern.MATCH_ALL);
            for (AssociationRef nodeAssocRef : nodeAssocRefs) {
                if (!assocDefs.containsKey(nodeAssocRef.getTypeQName())) continue;
                copyDetails.addAssociation(classDefinition.getName(), nodeAssocRef);
            }
        }
    }

    private void copyProperties(NodeRef destinationNodeRef, PolicyScope copyDetails) {
        Map<QName, Serializable> props = copyDetails.getProperties();
        if (props != null) {
            for (QName propName : props.keySet()) {
                this.nodeService.setProperty(destinationNodeRef, propName, props.get(propName));
            }
        }
    }

    private void copyAspects(NodeRef destinationNodeRef, PolicyScope copyDetails) {
        Set<QName> apects = copyDetails.getAspects();
        for (QName aspect : apects) {
            if (!this.nodeService.hasAspect(destinationNodeRef, aspect)) {
                this.nodeService.addAspect(destinationNodeRef, aspect, copyDetails.getProperties(aspect));
                continue;
            }
            Map<QName, Serializable> aspectProps = copyDetails.getProperties(aspect);
            if (aspectProps == null) continue;
            for (Map.Entry<QName, Serializable> entry : aspectProps.entrySet()) {
                this.nodeService.setProperty(destinationNodeRef, entry.getKey(), entry.getValue());
            }
        }
    }

    private void copyAssociations(NodeRef destinationNodeRef, PolicyScope copyDetails, boolean copyChildren, Map<NodeRef, NodeRef> copiedChildren) {
        QName classRef = this.nodeService.getType(destinationNodeRef);
        this.copyChildAssociations(classRef, destinationNodeRef, copyDetails, copyChildren, copiedChildren);
        this.copyTargetAssociations(classRef, destinationNodeRef, copyDetails);
        Set<QName> apects = copyDetails.getAspects();
        for (QName aspect : apects) {
            if (!this.nodeService.hasAspect(destinationNodeRef, aspect)) {
                throw new CopyServiceException("The aspect has not been added to the destination node.");
            }
            this.copyChildAssociations(aspect, destinationNodeRef, copyDetails, copyChildren, copiedChildren);
            this.copyTargetAssociations(aspect, destinationNodeRef, copyDetails);
        }
    }

    private void copyTargetAssociations(QName classRef, NodeRef destinationNodeRef, PolicyScope copyDetails) {
        List<AssociationRef> nodeAssocRefs = copyDetails.getAssociations(classRef);
        if (nodeAssocRefs != null) {
            for (AssociationRef assocRef : nodeAssocRefs) {
                NodeRef targetRef = assocRef.getTargetRef();
                boolean exists = false;
                for (AssociationRef assocRef2 : this.nodeService.getTargetAssocs(destinationNodeRef, assocRef.getTypeQName())) {
                    if (!targetRef.equals(assocRef2.getTargetRef())) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                this.nodeService.createAssociation(destinationNodeRef, targetRef, assocRef.getTypeQName());
            }
        }
    }

    private void copyChildAssociations(QName classRef, NodeRef destinationNodeRef, PolicyScope copyDetails, boolean copyChildren, Map<NodeRef, NodeRef> copiedChildren) {
        List<ChildAssociationRef> childAssocs = copyDetails.getChildAssociations(classRef);
        if (childAssocs != null) {
            for (ChildAssociationRef childAssoc : childAssocs) {
                NodeRef childRef;
                if (copyChildren) {
                    if (childAssoc.isPrimary()) {
                        if (copiedChildren.containsKey(childAssoc.getChildRef()) || copiedChildren.containsValue(childAssoc.getChildRef())) continue;
                        this.recursiveCopy(childAssoc.getChildRef(), destinationNodeRef, childAssoc.getTypeQName(), childAssoc.getQName(), copyChildren, copiedChildren);
                        continue;
                    }
                    childRef = childAssoc.getChildRef();
                    this.nodeService.addChild(destinationNodeRef, childRef, childAssoc.getTypeQName(), childAssoc.getQName());
                    continue;
                }
                childRef = childAssoc.getChildRef();
                QName childType = this.nodeService.getType(childRef);
                if (this.dictionaryService.isSubClass(childType, ContentModel.TYPE_CONFIGURATIONS) || copyDetails.isChildAssociationRefAlwaysTraversed(classRef, childAssoc)) {
                    if (copiedChildren.containsKey(childRef)) continue;
                    this.recursiveCopy(childRef, destinationNodeRef, childAssoc.getTypeQName(), childAssoc.getQName(), true, copiedChildren);
                    continue;
                }
                this.nodeService.addChild(destinationNodeRef, childRef, childAssoc.getTypeQName(), childAssoc.getQName());
            }
        }
    }

    @Override
    public NodeRef copy(NodeRef sourceNodeRef, NodeRef destinationParent, QName destinationAssocTypeQName, QName destinationQName) {
        return this.copy(sourceNodeRef, destinationParent, destinationAssocTypeQName, destinationQName, false);
    }

    @Override
    public void copy(NodeRef sourceNodeRef, NodeRef destinationNodeRef) {
        if (!this.nodeService.getType(sourceNodeRef).equals(this.nodeService.getType(destinationNodeRef))) {
            throw new CopyServiceException("The source and destination node must be the same type.");
        }
        PolicyScope copyDetails = this.getCopyDetails(sourceNodeRef, destinationNodeRef.getStoreRef(), false);
        this.copyProperties(destinationNodeRef, copyDetails);
        this.copyAspects(destinationNodeRef, copyDetails);
        this.copyAssociations(destinationNodeRef, copyDetails, false, new HashMap<NodeRef, NodeRef>());
        HashMap<NodeRef, NodeRef> copiedNodes = new HashMap<NodeRef, NodeRef>(1);
        copiedNodes.put(sourceNodeRef, destinationNodeRef);
        this.invokeCopyComplete(sourceNodeRef, destinationNodeRef, false, copiedNodes);
    }

    public void copyAspectOnCopy(QName classRef, NodeRef sourceNodeRef, StoreRef destinationStoreRef, boolean copyToNewNode, PolicyScope copyDetails) {
    }

    public void onCopyOwnable(QName classRef, NodeRef sourceNodeRef, StoreRef destinationStoreRef, boolean copyToNewNode, PolicyScope copyDetails) {
    }

    public void onCopyAuthor(QName classRef, NodeRef sourceNodeRef, StoreRef destinationStoreRef, boolean copyToNewNode, PolicyScope copyDetails) {
    }

    public void onCopyComplete(QName classRef, NodeRef sourceNodeRef, NodeRef destinationRef, boolean copyToNew, Map<NodeRef, NodeRef> copyMap) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NodeRef> getCopies(NodeRef nodeRef) {
        ArrayList<NodeRef> copies = new ArrayList<NodeRef>();
        ResultSet resultSet = null;
        try {
            resultSet = this.searchService.query(nodeRef.getStoreRef(), "lucene", "+@\\{http\\://www.alfresco.org/model/content/1.0\\}" + ContentModel.PROP_COPY_REFERENCE.getLocalName() + ":\"" + nodeRef.toString() + "\"");
            for (NodeRef copy : resultSet.getNodeRefs()) {
                copies.add(copy);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        return copies;
    }
}

