/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.copy;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Aspect;
import org.alfresco.repo.dictionary.M2Association;
import org.alfresco.repo.dictionary.M2ChildAssociation;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Property;
import org.alfresco.repo.dictionary.M2Type;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.BaseSpringTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyServiceImplTest
extends BaseSpringTest {
    private NodeService nodeService;
    private CopyService copyService;
    private DictionaryDAO dictionaryDAO;
    private ContentService contentService;
    private RuleService ruleService;
    private ActionService actionService;
    private AuthenticationComponent authenticationComponent;
    private StoreRef storeRef;
    private NodeRef sourceNodeRef;
    private NodeRef rootNodeRef;
    private NodeRef targetNodeRef;
    private NodeRef nonPrimaryChildNodeRef;
    private NodeRef childNodeRef;
    private NodeRef destinationNodeRef;
    private static final String TEST_TYPE_NAMESPACE = "testTypeNamespaceURI";
    private static final QName TEST_TYPE_QNAME = QName.createQName("testTypeNamespaceURI", "testType");
    private static final QName PROP1_QNAME_MANDATORY = QName.createQName("testTypeNamespaceURI", "prop1Mandatory");
    private static final QName PROP2_QNAME_OPTIONAL = QName.createQName("testTypeNamespaceURI", "prop2Optional");
    private static final QName TEST_ASPECT_QNAME = QName.createQName("testTypeNamespaceURI", "testAspect");
    private static final QName PROP3_QNAME_MANDATORY = QName.createQName("testTypeNamespaceURI", "prop3Mandatory");
    private static final QName PROP4_QNAME_OPTIONAL = QName.createQName("testTypeNamespaceURI", "prop4Optional");
    private static final QName PROP_QNAME_MY_NODE_REF = QName.createQName("testTypeNamespaceURI", "myNodeRef");
    private static final QName PROP_QNAME_MY_ANY = QName.createQName("testTypeNamespaceURI", "myAny");
    private static final QName TEST_MANDATORY_ASPECT_QNAME = QName.createQName("testTypeNamespaceURI", "testMandatoryAspect");
    private static final QName PROP5_QNAME_MANDATORY = QName.createQName("testTypeNamespaceURI", "prop5Mandatory");
    private static final String TEST_VALUE_1 = "testValue1";
    private static final String TEST_VALUE_2 = "testValue2";
    private static final String TEST_VALUE_3 = "testValue3";
    private static final QName TEST_CHILD_ASSOC_TYPE_QNAME = QName.createQName("testTypeNamespaceURI", "contains");
    private static final QName TEST_CHILD_ASSOC_QNAME = QName.createQName("testTypeNamespaceURI", "testChildAssocName");
    private static final QName TEST_ASSOC_TYPE_QNAME = QName.createQName("testTypeNamespaceURI", "testAssocName");
    private static final QName TEST_CHILD_ASSOC_QNAME2 = QName.createQName("testTypeNamespaceURI", "testChildAssocName2");
    private static final ContentData CONTENT_DATA_TEXT = new ContentData(null, "text/plain", 0L, "UTF-8");
    private static final String SOME_CONTENT = "This is some content ...";

    public void setDictionaryDAO(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    protected void onSetUpInTransaction() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("dbNodeService");
        this.copyService = (CopyService)this.applicationContext.getBean("copyService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.ruleService = (RuleService)this.applicationContext.getBean("ruleService");
        this.actionService = (ActionService)this.applicationContext.getBean("actionService");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.createTestModel();
        this.storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.storeRef);
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}test"), TEST_TYPE_QNAME, this.createTypePropertyBag());
        this.sourceNodeRef = childAssocRef.getChildRef();
        HashMap<QName, Serializable> aspectProperties = new HashMap<QName, Serializable>();
        aspectProperties.put(PROP3_QNAME_MANDATORY, (Serializable)((Object)TEST_VALUE_1));
        aspectProperties.put(PROP4_QNAME_OPTIONAL, (Serializable)((Object)TEST_VALUE_2));
        this.nodeService.addAspect(this.sourceNodeRef, TEST_ASPECT_QNAME, aspectProperties);
        this.nodeService.addAspect(this.sourceNodeRef, ContentModel.ASPECT_TITLED, null);
        ChildAssociationRef temp3 = this.nodeService.createNode(this.sourceNodeRef, TEST_CHILD_ASSOC_TYPE_QNAME, TEST_CHILD_ASSOC_QNAME, TEST_TYPE_QNAME, this.createTypePropertyBag());
        this.childNodeRef = temp3.getChildRef();
        ChildAssociationRef temp2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}testNonPrimaryChild"), TEST_TYPE_QNAME, this.createTypePropertyBag());
        this.nonPrimaryChildNodeRef = temp2.getChildRef();
        this.nodeService.addChild(this.sourceNodeRef, this.nonPrimaryChildNodeRef, TEST_CHILD_ASSOC_TYPE_QNAME, TEST_CHILD_ASSOC_QNAME2);
        ChildAssociationRef temp = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}testAssoc"), TEST_TYPE_QNAME, this.createTypePropertyBag());
        this.targetNodeRef = temp.getChildRef();
        this.nodeService.createAssociation(this.sourceNodeRef, this.targetNodeRef, TEST_ASSOC_TYPE_QNAME);
        HashMap<QName, Serializable> destinationProps = new HashMap<QName, Serializable>();
        destinationProps.put(PROP1_QNAME_MANDATORY, (Serializable)((Object)TEST_VALUE_1));
        destinationProps.put(PROP5_QNAME_MANDATORY, (Serializable)((Object)TEST_VALUE_3));
        destinationProps.put(ContentModel.PROP_CONTENT, CONTENT_DATA_TEXT);
        ChildAssociationRef temp5 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}testDestinationNode"), TEST_TYPE_QNAME, destinationProps);
        this.destinationNodeRef = temp5.getChildRef();
    }

    protected void onTearDownInTransaction() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
        super.onTearDownInTransaction();
    }

    private Map<QName, Serializable> createTypePropertyBag() {
        HashMap<QName, Serializable> result = new HashMap<QName, Serializable>();
        result.put(PROP1_QNAME_MANDATORY, (Serializable)((Object)TEST_VALUE_1));
        result.put(PROP2_QNAME_OPTIONAL, (Serializable)((Object)TEST_VALUE_2));
        result.put(PROP5_QNAME_MANDATORY, (Serializable)((Object)TEST_VALUE_3));
        result.put(ContentModel.PROP_CONTENT, CONTENT_DATA_TEXT);
        return result;
    }

    private void createTestModel() {
        M2Model model = M2Model.createModel("test:nodeoperations");
        model.createNamespace(TEST_TYPE_NAMESPACE, "test");
        model.createImport("http://www.alfresco.org/model/dictionary/1.0", "d");
        model.createImport("http://www.alfresco.org/model/system/1.0", "sys");
        model.createImport("http://www.alfresco.org/model/content/1.0", "cm");
        M2Type testType = model.createType("test:" + TEST_TYPE_QNAME.getLocalName());
        testType.setParentName("cm:" + ContentModel.TYPE_CONTENT.getLocalName());
        M2Property prop1 = testType.createProperty("test:" + PROP1_QNAME_MANDATORY.getLocalName());
        prop1.setMandatory(true);
        prop1.setType("d:" + DataTypeDefinition.TEXT.getLocalName());
        prop1.setMultiValued(false);
        M2Property prop2 = testType.createProperty("test:" + PROP2_QNAME_OPTIONAL.getLocalName());
        prop2.setMandatory(false);
        prop2.setType("d:" + DataTypeDefinition.TEXT.getLocalName());
        prop2.setMandatory(false);
        M2Property propNodeRef = testType.createProperty("test:" + PROP_QNAME_MY_NODE_REF.getLocalName());
        propNodeRef.setMandatory(false);
        propNodeRef.setType("d:" + DataTypeDefinition.NODE_REF.getLocalName());
        propNodeRef.setMandatory(false);
        M2Property propAnyNodeRef = testType.createProperty("test:" + PROP_QNAME_MY_ANY.getLocalName());
        propAnyNodeRef.setMandatory(false);
        propAnyNodeRef.setType("d:" + DataTypeDefinition.ANY.getLocalName());
        propAnyNodeRef.setMandatory(false);
        M2ChildAssociation childAssoc = testType.createChildAssociation("test:" + TEST_CHILD_ASSOC_TYPE_QNAME.getLocalName());
        childAssoc.setTargetClassName("sys:base");
        childAssoc.setTargetMandatory(false);
        M2Association assoc = testType.createAssociation("test:" + TEST_ASSOC_TYPE_QNAME.getLocalName());
        assoc.setTargetClassName("sys:base");
        assoc.setTargetMandatory(false);
        M2Aspect testAspect = model.createAspect("test:" + TEST_ASPECT_QNAME.getLocalName());
        M2Property prop3 = testAspect.createProperty("test:" + PROP3_QNAME_MANDATORY.getLocalName());
        prop3.setMandatory(true);
        prop3.setType("d:" + DataTypeDefinition.TEXT.getLocalName());
        prop3.setMultiValued(false);
        M2Property prop4 = testAspect.createProperty("test:" + PROP4_QNAME_OPTIONAL.getLocalName());
        prop4.setMandatory(false);
        prop4.setType("d:" + DataTypeDefinition.TEXT.getLocalName());
        prop4.setMultiValued(false);
        M2Aspect testMandatoryAspect = model.createAspect("test:" + TEST_MANDATORY_ASPECT_QNAME.getLocalName());
        M2Property prop5 = testMandatoryAspect.createProperty("test:" + PROP5_QNAME_MANDATORY.getLocalName());
        prop5.setType("d:" + DataTypeDefinition.TEXT.getLocalName());
        prop5.setMandatory(true);
        testType.addMandatoryAspect("test:" + TEST_MANDATORY_ASPECT_QNAME.getLocalName());
        this.dictionaryDAO.putModel(model);
    }

    public void testCopyToNewNode() {
        List<NodeRef> copies = this.copyService.getCopies(this.sourceNodeRef);
        CopyServiceImplTest.assertNotNull(copies);
        CopyServiceImplTest.assertTrue((boolean)copies.isEmpty());
        NodeRef copy = this.copyService.copy(this.sourceNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}copyAssoc"));
        this.checkCopiedNode(this.sourceNodeRef, copy, true, true, false);
        List<NodeRef> copies2 = this.copyService.getCopies(this.sourceNodeRef);
        CopyServiceImplTest.assertNotNull(copies2);
        CopyServiceImplTest.assertEquals((int)1, (int)copies2.size());
        NodeRef copy2 = this.copyService.copy(this.sourceNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}copyAssoc2"), true);
        this.checkCopiedNode(this.sourceNodeRef, copy2, true, true, true);
        List<NodeRef> copies3 = this.copyService.getCopies(this.sourceNodeRef);
        CopyServiceImplTest.assertNotNull(copies3);
        CopyServiceImplTest.assertEquals((int)2, (int)copies3.size());
        NodeRef copyOfCopy = this.copyService.copy(copy, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}copyOfCopy"));
        this.checkCopiedNode(copy, copyOfCopy, true, true, false);
        ContentWriter contentWriter = this.contentService.getWriter(this.sourceNodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.putContent(SOME_CONTENT);
        NodeRef copyWithContent = this.copyService.copy(this.sourceNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}copyWithContent"));
        this.checkCopiedNode(this.sourceNodeRef, copyWithContent, true, true, false);
        ContentReader contentReader = this.contentService.getReader(copyWithContent, ContentModel.PROP_CONTENT);
        CopyServiceImplTest.assertNotNull((Object)contentReader);
        CopyServiceImplTest.assertEquals((String)SOME_CONTENT, (String)contentReader.getContentString());
    }

    public void testCopyNodeWithRules() {
        Rule rule = this.ruleService.createRule("inbound");
        HashMap<String, Serializable> props = new HashMap<String, Serializable>(1);
        props.put("aspect-name", ContentModel.ASPECT_VERSIONABLE);
        Action action = this.actionService.createAction("add-features", props);
        rule.addAction(action);
        ActionCondition actionCondition = this.actionService.createActionCondition("no-condition");
        rule.addActionCondition(actionCondition);
        this.ruleService.saveRule(this.sourceNodeRef, rule);
        NodeRef copy = this.copyService.copy(this.sourceNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}withRulesCopy"), true);
        this.checkCopiedNode(this.sourceNodeRef, copy, true, true, true);
        CopyServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(copy, RuleModel.ASPECT_RULES));
        CopyServiceImplTest.assertTrue((boolean)this.ruleService.hasRules(copy));
        CopyServiceImplTest.assertTrue((boolean)this.ruleService.rulesEnabled(copy));
        List<Rule> copiedRules = this.ruleService.getRules(copy);
        CopyServiceImplTest.assertEquals((int)1, (int)copiedRules.size());
        Rule copiedRule = copiedRules.get(0);
        CopyServiceImplTest.assertFalse((rule.getId() == copiedRule.getId() ? 1 : 0) != 0);
        CopyServiceImplTest.assertEquals((String)rule.getAction(0).getActionDefinitionName(), (String)copiedRule.getAction(0).getActionDefinitionName());
        NodeRef copy2 = this.copyService.copy(this.sourceNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}withRuleCopyNoChildren"), false);
        this.checkCopiedNode(this.sourceNodeRef, copy2, true, true, false);
        CopyServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(copy2, RuleModel.ASPECT_RULES));
        CopyServiceImplTest.assertTrue((boolean)this.ruleService.hasRules(copy2));
        CopyServiceImplTest.assertTrue((boolean)this.ruleService.rulesEnabled(copy2));
        List<Rule> copiedRules2 = this.ruleService.getRules(copy2);
        CopyServiceImplTest.assertEquals((int)1, (int)copiedRules.size());
        Rule copiedRule2 = copiedRules2.get(0);
        CopyServiceImplTest.assertFalse((rule.getId() == copiedRule2.getId() ? 1 : 0) != 0);
        CopyServiceImplTest.assertEquals((String)rule.getAction(0).getActionDefinitionName(), (String)copiedRule2.getAction(0).getActionDefinitionName());
    }

    public void testCopyToExistingNode() {
        this.copyService.copy(this.sourceNodeRef, this.destinationNodeRef);
        this.checkCopiedNode(this.sourceNodeRef, this.destinationNodeRef, false, true, false);
    }

    public void testRecursiveCopy() {
        NodeRef nodeOne = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        NodeRef nodeTwo = this.nodeService.createNode(nodeOne, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        NodeRef nodeThree = this.nodeService.createNode(nodeTwo, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER).getChildRef();
        this.copyService.copy(nodeOne, nodeThree, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, true);
    }

    public void testRelativeLinks() {
        QName nodeOneAssocName = QName.createQName("{test}nodeOne");
        QName nodeTwoAssocName = QName.createQName("{test}nodeTwo");
        QName nodeThreeAssocName = QName.createQName("{test}nodeThree");
        QName nodeFourAssocName = QName.createQName("{test}nodeFour");
        NodeRef nodeOne = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, nodeOneAssocName, TEST_TYPE_QNAME).getChildRef();
        NodeRef nodeTwo = this.nodeService.createNode(nodeOne, TEST_CHILD_ASSOC_TYPE_QNAME, nodeTwoAssocName, TEST_TYPE_QNAME).getChildRef();
        NodeRef nodeThree = this.nodeService.createNode(nodeTwo, TEST_CHILD_ASSOC_TYPE_QNAME, nodeThreeAssocName, TEST_TYPE_QNAME).getChildRef();
        NodeRef nodeFour = this.nodeService.createNode(nodeOne, TEST_CHILD_ASSOC_TYPE_QNAME, nodeFourAssocName, TEST_TYPE_QNAME).getChildRef();
        this.nodeService.addChild(nodeFour, nodeThree, TEST_CHILD_ASSOC_TYPE_QNAME, TEST_CHILD_ASSOC_QNAME);
        this.nodeService.createAssociation(nodeTwo, nodeThree, TEST_ASSOC_TYPE_QNAME);
        this.nodeService.setProperty(nodeOne, PROP_QNAME_MY_NODE_REF, nodeThree);
        this.nodeService.setProperty(nodeOne, PROP_QNAME_MY_ANY, nodeThree);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("destination-folder", nodeTwo);
        params.put("assoc-type", TEST_CHILD_ASSOC_TYPE_QNAME);
        params.put("assoc-name", QName.createQName("{test}ruleCopy"));
        Rule rule = this.ruleService.createRule("inbound");
        ActionCondition condition = this.actionService.createActionCondition("no-condition");
        rule.addActionCondition(condition);
        Action action = this.actionService.createAction("copy", params);
        rule.addAction(action);
        this.ruleService.saveRule(nodeOne, rule);
        NodeRef nodeOneCopy = this.copyService.copy(nodeOne, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}copiedNodeOne"), true);
        NodeRef nodeTwoCopy = null;
        NodeRef nodeThreeCopy = null;
        NodeRef nodeFourCopy = null;
        List<ChildAssociationRef> nodeOneCopyChildren = this.nodeService.getChildAssocs(nodeOneCopy);
        CopyServiceImplTest.assertNotNull(nodeOneCopyChildren);
        CopyServiceImplTest.assertEquals((int)3, (int)nodeOneCopyChildren.size());
        for (ChildAssociationRef nodeOneCopyChild : nodeOneCopyChildren) {
            if (nodeOneCopyChild.getQName().equals(nodeTwoAssocName)) {
                nodeTwoCopy = nodeOneCopyChild.getChildRef();
                List<ChildAssociationRef> nodeTwoCopyChildren = this.nodeService.getChildAssocs(nodeTwoCopy);
                CopyServiceImplTest.assertNotNull(nodeTwoCopyChildren);
                CopyServiceImplTest.assertEquals((int)1, (int)nodeTwoCopyChildren.size());
                for (ChildAssociationRef nodeTwoCopyChild : nodeTwoCopyChildren) {
                    if (!nodeTwoCopyChild.getQName().equals(nodeThreeAssocName)) continue;
                    nodeThreeCopy = nodeTwoCopyChild.getChildRef();
                }
                continue;
            }
            if (!nodeOneCopyChild.getQName().equals(nodeFourAssocName)) continue;
            nodeFourCopy = nodeOneCopyChild.getChildRef();
        }
        CopyServiceImplTest.assertNotNull(nodeTwoCopy);
        CopyServiceImplTest.assertNotNull(nodeThreeCopy);
        CopyServiceImplTest.assertNotNull(nodeFourCopy);
        List<ChildAssociationRef> children = this.nodeService.getChildAssocs(nodeFourCopy, RegexQNamePattern.MATCH_ALL, TEST_CHILD_ASSOC_QNAME);
        CopyServiceImplTest.assertNotNull(children);
        CopyServiceImplTest.assertEquals((int)1, (int)children.size());
        ChildAssociationRef child = children.get(0);
        CopyServiceImplTest.assertEquals((Object)child.getChildRef(), nodeThreeCopy);
        NodeRef nodeRef = (NodeRef)this.nodeService.getProperty(nodeOneCopy, PROP_QNAME_MY_NODE_REF);
        CopyServiceImplTest.assertNotNull((Object)nodeRef);
        CopyServiceImplTest.assertEquals(nodeThreeCopy, (Object)nodeRef);
        NodeRef anyNodeRef = (NodeRef)this.nodeService.getProperty(nodeOneCopy, PROP_QNAME_MY_ANY);
        CopyServiceImplTest.assertNotNull((Object)anyNodeRef);
        CopyServiceImplTest.assertEquals((Object)nodeThreeCopy, (Object)anyNodeRef);
        List<AssociationRef> assocs = this.nodeService.getTargetAssocs(nodeTwoCopy, TEST_ASSOC_TYPE_QNAME);
        CopyServiceImplTest.assertNotNull(assocs);
        CopyServiceImplTest.assertEquals((int)1, (int)assocs.size());
        AssociationRef assoc = assocs.get(0);
        CopyServiceImplTest.assertEquals((Object)assoc.getTargetRef(), (Object)nodeThreeCopy);
        List<Rule> rules = this.ruleService.getRules(nodeOneCopy);
        CopyServiceImplTest.assertNotNull(rules);
        CopyServiceImplTest.assertEquals((int)1, (int)rules.size());
        Rule copiedRule = rules.get(0);
        CopyServiceImplTest.assertNotNull((Object)copiedRule);
        List<Action> ruleActions = copiedRule.getActions();
        CopyServiceImplTest.assertNotNull(ruleActions);
        CopyServiceImplTest.assertEquals((int)1, (int)ruleActions.size());
        Action ruleAction = ruleActions.get(0);
        NodeRef value = (NodeRef)ruleAction.getParameterValue("destination-folder");
        CopyServiceImplTest.assertNotNull((Object)value);
        CopyServiceImplTest.assertEquals((Object)nodeTwoCopy, (Object)value);
    }

    private void checkCopiedNode(NodeRef sourceNodeRef, NodeRef destinationNodeRef, boolean newCopy, boolean sameStore, boolean copyChildren) {
        if (newCopy) {
            if (sameStore) {
                boolean hasCopyAspect = this.nodeService.hasAspect(destinationNodeRef, ContentModel.ASPECT_COPIEDFROM);
                CopyServiceImplTest.assertTrue((boolean)hasCopyAspect);
                NodeRef copyNodeRef = (NodeRef)this.nodeService.getProperty(destinationNodeRef, ContentModel.PROP_COPY_REFERENCE);
                CopyServiceImplTest.assertNotNull((Object)copyNodeRef);
                CopyServiceImplTest.assertEquals((Object)sourceNodeRef, (Object)copyNodeRef);
            } else {
                CopyServiceImplTest.assertEquals((String)sourceNodeRef.getId(), (String)destinationNodeRef.getId());
            }
        }
        boolean hasTestAspect = this.nodeService.hasAspect(destinationNodeRef, TEST_ASPECT_QNAME);
        CopyServiceImplTest.assertTrue((boolean)hasTestAspect);
        Map<QName, Serializable> destinationProperties = this.nodeService.getProperties(destinationNodeRef);
        CopyServiceImplTest.assertNotNull(destinationProperties);
        String value1 = (String)((Object)destinationProperties.get(PROP1_QNAME_MANDATORY));
        CopyServiceImplTest.assertNotNull((Object)value1);
        CopyServiceImplTest.assertEquals((String)TEST_VALUE_1, (String)value1);
        String value2 = (String)((Object)destinationProperties.get(PROP2_QNAME_OPTIONAL));
        CopyServiceImplTest.assertNotNull((Object)value2);
        CopyServiceImplTest.assertEquals((String)TEST_VALUE_2, (String)value2);
        String value3 = (String)((Object)destinationProperties.get(PROP3_QNAME_MANDATORY));
        CopyServiceImplTest.assertNotNull((Object)value3);
        CopyServiceImplTest.assertEquals((String)TEST_VALUE_1, (String)value3);
        String value4 = (String)((Object)destinationProperties.get(PROP4_QNAME_OPTIONAL));
        CopyServiceImplTest.assertNotNull((Object)value4);
        CopyServiceImplTest.assertEquals((String)TEST_VALUE_2, (String)value4);
        List<AssociationRef> destinationTargets = this.nodeService.getTargetAssocs(destinationNodeRef, TEST_ASSOC_TYPE_QNAME);
        CopyServiceImplTest.assertNotNull(destinationTargets);
        CopyServiceImplTest.assertEquals((int)1, (int)destinationTargets.size());
        AssociationRef nodeAssocRef = destinationTargets.get(0);
        CopyServiceImplTest.assertNotNull((Object)nodeAssocRef);
        CopyServiceImplTest.assertEquals((Object)this.targetNodeRef, (Object)nodeAssocRef.getTargetRef());
        List<ChildAssociationRef> childAssocRefs = this.nodeService.getChildAssocs(destinationNodeRef);
        CopyServiceImplTest.assertNotNull(childAssocRefs);
        int expectedSize = 2;
        if (this.nodeService.hasAspect(destinationNodeRef, RuleModel.ASPECT_RULES)) {
            ++expectedSize;
        }
        CopyServiceImplTest.assertEquals((int)expectedSize, (int)childAssocRefs.size());
        for (ChildAssociationRef ref : childAssocRefs) {
            if (ref.getQName().equals(TEST_CHILD_ASSOC_QNAME2)) {
                CopyServiceImplTest.assertFalse((boolean)ref.isPrimary());
                CopyServiceImplTest.assertEquals((Object)this.nonPrimaryChildNodeRef, (Object)ref.getChildRef());
                continue;
            }
            if (!copyChildren) {
                if (ref.getTypeQName().equals(RuleModel.ASSOC_RULE_FOLDER)) {
                    CopyServiceImplTest.assertTrue((boolean)ref.isPrimary());
                    CopyServiceImplTest.assertTrue((!this.childNodeRef.equals(ref.getChildRef()) ? 1 : 0) != 0);
                    continue;
                }
                CopyServiceImplTest.assertFalse((boolean)ref.isPrimary());
                CopyServiceImplTest.assertEquals((Object)this.childNodeRef, (Object)ref.getChildRef());
                continue;
            }
            CopyServiceImplTest.assertTrue((boolean)ref.isPrimary());
            CopyServiceImplTest.assertTrue((!this.childNodeRef.equals(ref.getChildRef()) ? 1 : 0) != 0);
        }
    }
}

