/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.descriptor;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.transaction.TransactionUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.license.LicenseDescriptor;
import org.alfresco.service.license.LicenseException;
import org.alfresco.service.license.LicenseService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.io.Resource;

public class DescriptorServiceImpl
implements DescriptorService,
ApplicationListener,
InitializingBean,
ApplicationContextAware {
    private static Log logger = LogFactory.getLog(DescriptorServiceImpl.class);
    private ApplicationContext applicationContext;
    private Properties serverProperties;
    private ImporterBootstrap systemBootstrap;
    private NamespaceService namespaceService;
    private NodeService nodeService;
    private SearchService searchService;
    private TransactionService transactionService;
    private LicenseService licenseService = null;
    private Descriptor serverDescriptor;
    private Descriptor installedRepoDescriptor;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setDescriptor(Resource descriptorResource) throws IOException {
        this.serverProperties = new Properties();
        this.serverProperties.load(descriptorResource.getInputStream());
    }

    public void setSystemBootstrap(ImporterBootstrap systemBootstrap) {
        this.systemBootstrap = systemBootstrap;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public Descriptor getServerDescriptor() {
        return this.serverDescriptor;
    }

    public Descriptor getInstalledRepositoryDescriptor() {
        return this.installedRepoDescriptor;
    }

    public LicenseDescriptor getLicenseDescriptor() {
        return this.licenseService == null ? null : this.licenseService.getLicense();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            TransactionUtil.TransactionWork<Descriptor> createDescriptorWork = new TransactionUtil.TransactionWork<Descriptor>(){

                @Override
                public Descriptor doWork() {
                    DescriptorServiceImpl.this.initialiseLicenseService();
                    DescriptorServiceImpl.this.licenseService.verifyLicense();
                    DescriptorServiceImpl.this.updateCurrentRepositoryDescriptor(DescriptorServiceImpl.this.serverDescriptor);
                    return DescriptorServiceImpl.this.createInstalledRepositoryDescriptor();
                }
            };
            this.installedRepoDescriptor = TransactionUtil.executeInUserTransaction(this.transactionService, createDescriptorWork);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.serverDescriptor = this.createServerDescriptor();
    }

    private Descriptor createServerDescriptor() {
        return new ServerDescriptor();
    }

    private Descriptor createInstalledRepositoryDescriptor() {
        Properties systemProperties;
        String path;
        StoreRef storeRef = this.systemBootstrap.getStoreRef();
        NodeRef descriptorNodeRef = this.getDescriptorNodeRef(storeRef, path = (systemProperties = this.systemBootstrap.getConfiguration()).getProperty("system.descriptor.childname"), false);
        if (descriptorNodeRef != null) {
            Map<QName, Serializable> properties = this.nodeService.getProperties(descriptorNodeRef);
            return new RepositoryDescriptor(properties);
        }
        return new UnknownDescriptor();
    }

    private void updateCurrentRepositoryDescriptor(Descriptor serverDescriptor) {
        Properties systemProperties;
        String path;
        StoreRef storeRef = this.systemBootstrap.getStoreRef();
        NodeRef currentDescriptorNodeRef = this.getDescriptorNodeRef(storeRef, path = (systemProperties = this.systemBootstrap.getConfiguration()).getProperty("system.descriptor.current.childname"), true);
        if (currentDescriptorNodeRef == null) {
            return;
        }
        this.nodeService.setProperty(currentDescriptorNodeRef, ContentModel.PROP_SYS_VERSION_MAJOR, (Serializable)((Object)serverDescriptor.getVersionMajor()));
        this.nodeService.setProperty(currentDescriptorNodeRef, ContentModel.PROP_SYS_VERSION_MINOR, (Serializable)((Object)serverDescriptor.getVersionMinor()));
        this.nodeService.setProperty(currentDescriptorNodeRef, ContentModel.PROP_SYS_VERSION_REVISION, (Serializable)((Object)serverDescriptor.getVersionRevision()));
        this.nodeService.setProperty(currentDescriptorNodeRef, ContentModel.PROP_SYS_VERSION_LABEL, (Serializable)((Object)serverDescriptor.getVersionLabel()));
        this.nodeService.setProperty(currentDescriptorNodeRef, ContentModel.PROP_SYS_VERSION_SCHEMA, Integer.valueOf(serverDescriptor.getSchema()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Updated current repository descriptor properties: \n   node: " + currentDescriptorNodeRef + "\n" + "   descriptor: " + serverDescriptor));
        }
    }

    private NodeRef getDescriptorNodeRef(StoreRef storeRef, String path, boolean create) {
        NodeRef rootNodeRef;
        NodeRef descriptorNodeRef = null;
        String searchPath = "/" + path;
        if (this.nodeService.exists(storeRef)) {
            rootNodeRef = this.nodeService.getRootNode(storeRef);
            List<NodeRef> nodeRefs = this.searchService.selectNodes(rootNodeRef, searchPath, null, this.namespaceService, false);
            if (nodeRefs.size() == 1) {
                descriptorNodeRef = nodeRefs.get(0);
            } else if (nodeRefs.size() != 0 && nodeRefs.size() > 1) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Multiple descriptors: \n   store: " + storeRef + "\n" + "   path: " + searchPath));
                }
                descriptorNodeRef = nodeRefs.get(0);
            }
        }
        if (descriptorNodeRef == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Descriptor not found: \n   store: " + storeRef + "\n" + "   path: " + searchPath));
            }
            if (create) {
                storeRef = this.nodeService.createStore(storeRef.getProtocol(), storeRef.getIdentifier());
                rootNodeRef = this.nodeService.getRootNode(storeRef);
                descriptorNodeRef = this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(path, this.namespaceService), QName.createQName("sys:descriptor", this.namespaceService)).getChildRef();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Created missing descriptor node: " + descriptorNodeRef));
                }
            }
        }
        return descriptorNodeRef;
    }

    private void initialiseLicenseService() {
        try {
            Class<?> licenseComponentClass = Class.forName("org.alfresco.license.LicenseComponent");
            Constructor<?> constructor = licenseComponentClass.getConstructor(ApplicationContext.class);
            this.licenseService = (LicenseService)constructor.newInstance(this.applicationContext);
        }
        catch (ClassNotFoundException e) {
            this.licenseService = new NOOPLicenseService();
        }
        catch (SecurityException e) {
            throw new AlfrescoRuntimeException("Failed to initialise license service", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new AlfrescoRuntimeException("Failed to initialise license service", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new AlfrescoRuntimeException("Failed to initialise license service", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new AlfrescoRuntimeException("Failed to initialise license service", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new AlfrescoRuntimeException("Failed to initialise license service", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new AlfrescoRuntimeException("Failed to initialise license service", (Throwable)e);
        }
    }

    private class ServerDescriptor
    implements Descriptor {
        private ServerDescriptor() {
        }

        public String getVersionMajor() {
            return DescriptorServiceImpl.this.serverProperties.getProperty("version.major");
        }

        public String getVersionMinor() {
            return DescriptorServiceImpl.this.serverProperties.getProperty("version.minor");
        }

        public String getVersionRevision() {
            return DescriptorServiceImpl.this.serverProperties.getProperty("version.revision");
        }

        public String getVersionLabel() {
            return DescriptorServiceImpl.this.serverProperties.getProperty("version.label");
        }

        public String getVersion() {
            String version = this.getVersionMajor() + "." + this.getVersionMinor() + "." + this.getVersionRevision();
            String label = this.getVersionLabel();
            if (label != null && label.length() > 0) {
                version = version + " (" + label + ")";
            }
            return version;
        }

        public String getEdition() {
            return DescriptorServiceImpl.this.serverProperties.getProperty("version.edition");
        }

        public int getSchema() {
            String schemaStr = DescriptorServiceImpl.this.serverProperties.getProperty("version.schema");
            if (schemaStr == null) {
                return 0;
            }
            try {
                int schema = Integer.parseInt(schemaStr);
                if (schema < 0) {
                    throw new NumberFormatException();
                }
                return schema;
            }
            catch (NumberFormatException e) {
                throw new AlfrescoRuntimeException("'version.schema' must be a positive integer");
            }
        }

        public String[] getDescriptorKeys() {
            String[] keys = new String[DescriptorServiceImpl.this.serverProperties.size()];
            DescriptorServiceImpl.this.serverProperties.keySet().toArray(keys);
            return keys;
        }

        public String getDescriptor(String key) {
            return DescriptorServiceImpl.this.serverProperties.getProperty(key, "");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RepositoryDescriptor
    implements Descriptor {
        private Map<QName, Serializable> properties;

        private RepositoryDescriptor(Map<QName, Serializable> properties) {
            this.properties = properties;
        }

        @Override
        public String getVersionMajor() {
            return this.getDescriptor("sys:versionMajor");
        }

        @Override
        public String getVersionMinor() {
            return this.getDescriptor("sys:versionMinor");
        }

        @Override
        public String getVersionRevision() {
            return this.getDescriptor("sys:versionRevision");
        }

        @Override
        public String getVersionLabel() {
            return this.getDescriptor("sys:versionLabel");
        }

        @Override
        public String getVersion() {
            String version = this.getVersionMajor() + "." + this.getVersionMinor() + "." + this.getVersionRevision();
            String label = this.getVersionLabel();
            if (label != null && label.length() > 0) {
                version = version + " (" + label + ")";
            }
            return version;
        }

        @Override
        public String getEdition() {
            return null;
        }

        @Override
        public int getSchema() {
            String schemaStr = this.getDescriptor("sys:versionSchema");
            if (schemaStr == null) {
                return 0;
            }
            try {
                int schema = Integer.parseInt(schemaStr);
                if (schema < 0) {
                    throw new NumberFormatException();
                }
                return schema;
            }
            catch (NumberFormatException e) {
                throw new AlfrescoRuntimeException("'version.schema' must be a positive integer");
            }
        }

        @Override
        public String[] getDescriptorKeys() {
            String[] keys = new String[this.properties.size()];
            this.properties.keySet().toArray(keys);
            return keys;
        }

        @Override
        public String getDescriptor(String key) {
            String strValue = null;
            QName qname = QName.createQName(key, DescriptorServiceImpl.this.namespaceService);
            Serializable value = this.properties.get(qname);
            if (value != null) {
                strValue = value.toString();
            }
            return strValue;
        }
    }

    private class UnknownDescriptor
    implements Descriptor {
        private UnknownDescriptor() {
        }

        public String getVersionMajor() {
            return "Unknown";
        }

        public String getVersionMinor() {
            return "Unknown";
        }

        public String getVersionRevision() {
            return "Unknown";
        }

        public String getVersionLabel() {
            return "Unknown";
        }

        public String getVersion() {
            return "Unknown (pre 1.0.0 RC2)";
        }

        public String getEdition() {
            return "Unknown";
        }

        public int getSchema() {
            return 0;
        }

        public String[] getDescriptorKeys() {
            return new String[0];
        }

        public String getDescriptor(String key) {
            return null;
        }
    }

    private class NOOPLicenseService
    implements LicenseService {
        private NOOPLicenseService() {
        }

        public void verifyLicense() throws LicenseException {
        }

        public LicenseDescriptor getLicense() throws LicenseException {
            return null;
        }
    }
}

