/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.descriptor;

import java.security.Principal;
import java.util.Date;
import java.util.Properties;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.license.LicenseDescriptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class DescriptorStartupLog
implements ApplicationListener {
    private static final Log logger = LogFactory.getLog(DescriptorService.class);
    private DescriptorService descriptorService;

    public void setDescriptorService(DescriptorService descriptorService) {
        this.descriptorService = descriptorService;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            LicenseDescriptor license;
            Properties properties = System.getProperties();
            String version = properties.get("java.runtime.version") == null ? "unknown" : (String)properties.get("java.runtime.version");
            long maxHeap = Runtime.getRuntime().maxMemory();
            float maxHeapMB = maxHeap / 1024L;
            maxHeapMB /= 1024.0f;
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("Alfresco JVM - v%s; maximum heap size %.3fMB", version, Float.valueOf(maxHeapMB)));
            }
            if (logger.isWarnEnabled()) {
                if (version.startsWith("1.2") || version.startsWith("1.3") || version.startsWith("1.4")) {
                    logger.warn((Object)String.format("Alfresco JVM - WARNING - v1.5 is required; currently using v%s", version));
                }
                if (maxHeapMB < 500.0f) {
                    logger.warn((Object)String.format("Alfresco JVM - WARNING - maximum heap size %.3fMB is less than recommended 512MB", Float.valueOf(maxHeapMB)));
                }
            }
            if ((license = this.descriptorService.getLicenseDescriptor()) != null && logger.isInfoEnabled()) {
                Date validUntil;
                String subject = license.getSubject();
                String msg = "Alfresco license: " + subject;
                String holder = this.getHolderOrganisation(license.getHolder());
                if (holder != null) {
                    msg = msg + " granted to " + holder;
                }
                if ((validUntil = license.getValidUntil()) != null) {
                    Integer days = license.getDays();
                    Integer remainingDays = license.getRemainingDays();
                    msg = msg + " limited to " + days + " days expiring " + validUntil + " (" + remainingDays + " days remaining)";
                } else {
                    msg = msg + " (does not expire)";
                }
                logger.info((Object)msg);
            }
            if (logger.isInfoEnabled()) {
                Descriptor serverDescriptor = this.descriptorService.getServerDescriptor();
                Descriptor installedRepoDescriptor = this.descriptorService.getInstalledRepositoryDescriptor();
                String serverEdition = serverDescriptor.getEdition();
                String serverVersion = serverDescriptor.getVersion();
                int serverSchemaVersion = serverDescriptor.getSchema();
                String installedRepoVersion = installedRepoDescriptor.getVersion();
                int installedSchemaVersion = installedRepoDescriptor.getSchema();
                logger.info((Object)String.format("Alfresco started (%s): Current version %s schema %d - Installed version %s schema %d", serverEdition, serverVersion, serverSchemaVersion, installedRepoVersion, installedSchemaVersion));
            }
        }
    }

    private String getHolderOrganisation(Principal holderPrincipal) {
        String holder = null;
        if (holderPrincipal != null && (holder = holderPrincipal.getName()) != null) {
            String[] properties;
            for (String property : properties = holder.split(",")) {
                String[] parts = property.split("=");
                if (!parts[0].equals("O")) continue;
                holder = parts[1];
            }
        }
        return holder;
    }
}

