/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.i18n.I18NUtil;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryBootstrap {
    private List<String> models = new ArrayList<String>();
    private List<String> resourceBundles = new ArrayList<String>();
    private DictionaryDAO dictionaryDAO = null;
    private static Log logger = LogFactory.getLog(DictionaryDAO.class);

    public void setDictionaryDAO(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    public void setModels(List<String> modelResources) {
        this.models = modelResources;
    }

    public void setLabels(List<String> labels) {
        this.resourceBundles = labels;
    }

    public void bootstrap() {
        for (String bootstrapModel : this.models) {
            InputStream modelStream = this.getClass().getClassLoader().getResourceAsStream(bootstrapModel);
            if (modelStream == null) {
                throw new DictionaryException("Could not find bootstrap model " + bootstrapModel);
            }
            try {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Loading model from " + bootstrapModel));
                }
                M2Model model = M2Model.createModel(modelStream);
                this.dictionaryDAO.putModel(model);
            }
            catch (DictionaryException e) {
                throw new DictionaryException("Could not import bootstrap model " + bootstrapModel, (Throwable)((Object)e));
            }
        }
        for (String resourceBundle : this.resourceBundles) {
            I18NUtil.registerResourceBundle((String)resourceBundle);
        }
    }
}

