/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.InvalidTypeException;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryComponent
implements DictionaryService {
    private DictionaryDAO dictionaryDAO;

    public void setDictionaryDAO(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    @Override
    public Collection<QName> getAllModels() {
        return this.dictionaryDAO.getModels();
    }

    @Override
    public ModelDefinition getModel(QName model) {
        return this.dictionaryDAO.getModel(model);
    }

    @Override
    public Collection<QName> getAllDataTypes() {
        ArrayList<QName> propertyTypes = new ArrayList<QName>();
        for (QName model : this.getAllModels()) {
            propertyTypes.addAll(this.getAspects(model));
        }
        return propertyTypes;
    }

    @Override
    public Collection<QName> getDataTypes(QName model) {
        Collection<DataTypeDefinition> propertyTypes = this.dictionaryDAO.getDataTypes(model);
        ArrayList<QName> qnames = new ArrayList<QName>(propertyTypes.size());
        for (DataTypeDefinition def : propertyTypes) {
            qnames.add(def.getName());
        }
        return qnames;
    }

    @Override
    public Collection<QName> getAllTypes() {
        ArrayList<QName> types = new ArrayList<QName>();
        for (QName model : this.getAllModels()) {
            types.addAll(this.getTypes(model));
        }
        return types;
    }

    @Override
    public Collection<QName> getTypes(QName model) {
        Collection<TypeDefinition> types = this.dictionaryDAO.getTypes(model);
        ArrayList<QName> qnames = new ArrayList<QName>(types.size());
        for (TypeDefinition def : types) {
            qnames.add(def.getName());
        }
        return qnames;
    }

    @Override
    public Collection<QName> getAllAspects() {
        ArrayList<QName> aspects = new ArrayList<QName>();
        for (QName model : this.getAllModels()) {
            aspects.addAll(this.getAspects(model));
        }
        return aspects;
    }

    @Override
    public Collection<QName> getAspects(QName model) {
        Collection<AspectDefinition> aspects = this.dictionaryDAO.getAspects(model);
        ArrayList<QName> qnames = new ArrayList<QName>(aspects.size());
        for (AspectDefinition def : aspects) {
            qnames.add(def.getName());
        }
        return qnames;
    }

    @Override
    public boolean isSubClass(QName className, QName ofClassName) {
        ParameterCheck.mandatory((String)"className", (Object)className);
        ParameterCheck.mandatory((String)"ofClassName", (Object)ofClassName);
        ClassDefinition classDef = this.getClass(className);
        if (classDef == null) {
            throw new InvalidTypeException(className);
        }
        ClassDefinition ofClassDef = this.getClass(ofClassName);
        if (ofClassDef == null) {
            throw new InvalidTypeException(ofClassName);
        }
        boolean subClassOf = false;
        if (classDef.isAspect() == ofClassDef.isAspect()) {
            while (classDef != null) {
                if (classDef.equals(ofClassDef)) {
                    subClassOf = true;
                    break;
                }
                QName parentClassName = classDef.getParentName();
                classDef = parentClassName == null ? null : this.getClass(parentClassName);
            }
        }
        return subClassOf;
    }

    @Override
    public DataTypeDefinition getDataType(QName name) {
        return this.dictionaryDAO.getDataType(name);
    }

    @Override
    public DataTypeDefinition getDataType(Class javaClass) {
        return this.dictionaryDAO.getDataType(javaClass);
    }

    @Override
    public TypeDefinition getType(QName name) {
        return this.dictionaryDAO.getType(name);
    }

    @Override
    public AspectDefinition getAspect(QName name) {
        return this.dictionaryDAO.getAspect(name);
    }

    @Override
    public ClassDefinition getClass(QName name) {
        return this.dictionaryDAO.getClass(name);
    }

    @Override
    public TypeDefinition getAnonymousType(QName type, Collection<QName> aspects) {
        return this.dictionaryDAO.getAnonymousType(type, aspects);
    }

    @Override
    public PropertyDefinition getProperty(QName className, QName propertyName) {
        PropertyDefinition propDef = null;
        ClassDefinition classDef = this.dictionaryDAO.getClass(className);
        if (classDef != null) {
            Map<QName, PropertyDefinition> propDefs = classDef.getProperties();
            propDef = propDefs.get(propertyName);
        }
        return propDef;
    }

    @Override
    public PropertyDefinition getProperty(QName propertyName) {
        return this.dictionaryDAO.getProperty(propertyName);
    }

    @Override
    public AssociationDefinition getAssociation(QName associationName) {
        return this.dictionaryDAO.getAssociation(associationName);
    }
}

