/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.dictionary.CompiledModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2AnonymousTypeDefinition;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Namespace;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryDAOImpl
implements DictionaryDAO {
    private NamespaceDAO namespaceDAO;
    private Map<String, QName> namespaceToModel = new HashMap<String, QName>();
    private Map<QName, CompiledModel> compiledModels = new HashMap<QName, CompiledModel>();
    private static Log logger = LogFactory.getLog(DictionaryDAO.class);

    public DictionaryDAOImpl(NamespaceDAO namespaceDAO) {
        this.namespaceDAO = namespaceDAO;
    }

    @Override
    public void putModel(M2Model model) {
        CompiledModel compiledModel = model.compile(this, this.namespaceDAO);
        QName modelName = compiledModel.getModelDefinition().getName();
        CompiledModel previousVersion = this.compiledModels.get(modelName);
        if (previousVersion != null) {
            for (M2Namespace namespace : previousVersion.getM2Model().getNamespaces()) {
                this.namespaceDAO.removePrefix(namespace.getPrefix());
                this.namespaceDAO.removeURI(namespace.getUri());
                this.namespaceToModel.remove(namespace.getUri());
            }
        }
        for (M2Namespace namespace : model.getNamespaces()) {
            this.namespaceDAO.addURI(namespace.getUri());
            this.namespaceDAO.addPrefix(namespace.getPrefix(), namespace.getUri());
            this.namespaceToModel.put(namespace.getUri(), modelName);
        }
        this.compiledModels.put(modelName, compiledModel);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Registered model " + modelName.toPrefixString(this.namespaceDAO)));
            for (M2Namespace namespace : model.getNamespaces()) {
                logger.info((Object)("Registered namespace '" + namespace.getUri() + "' (prefix '" + namespace.getPrefix() + "')"));
            }
        }
    }

    @Override
    public void removeModel(QName modelName) {
        CompiledModel compiledModel = this.compiledModels.get(modelName);
        if (compiledModel != null) {
            M2Model model = compiledModel.getM2Model();
            for (M2Namespace namespace : model.getNamespaces()) {
                this.namespaceDAO.removePrefix(namespace.getPrefix());
                this.namespaceDAO.removeURI(namespace.getUri());
                this.namespaceToModel.remove(namespace.getUri());
            }
            this.compiledModels.remove(modelName);
        }
    }

    private CompiledModel getCompiledModelForNamespace(String uri) {
        QName modelName = this.namespaceToModel.get(uri);
        return modelName == null ? null : this.getCompiledModel(modelName);
    }

    private CompiledModel getCompiledModel(QName modelName) {
        CompiledModel model = this.compiledModels.get(modelName);
        if (model == null) {
            throw new DictionaryException("d_dictionary.model.err.no_model", modelName);
        }
        return model;
    }

    @Override
    public DataTypeDefinition getDataType(QName typeName) {
        CompiledModel model = this.getCompiledModelForNamespace(typeName.getNamespaceURI());
        return model == null ? null : model.getDataType(typeName);
    }

    @Override
    public DataTypeDefinition getDataType(Class javaClass) {
        for (CompiledModel model : this.compiledModels.values()) {
            DataTypeDefinition dataTypeDef = model.getDataType(javaClass);
            if (dataTypeDef == null) continue;
            return dataTypeDef;
        }
        return null;
    }

    @Override
    public Collection<DataTypeDefinition> getDataTypes(QName modelName) {
        CompiledModel model = this.getCompiledModel(modelName);
        return model.getDataTypes();
    }

    @Override
    public TypeDefinition getType(QName typeName) {
        CompiledModel model = this.getCompiledModelForNamespace(typeName.getNamespaceURI());
        return model == null ? null : model.getType(typeName);
    }

    @Override
    public AspectDefinition getAspect(QName aspectName) {
        CompiledModel model = this.getCompiledModelForNamespace(aspectName.getNamespaceURI());
        return model == null ? null : model.getAspect(aspectName);
    }

    @Override
    public ClassDefinition getClass(QName className) {
        CompiledModel model = this.getCompiledModelForNamespace(className.getNamespaceURI());
        return model == null ? null : model.getClass(className);
    }

    @Override
    public PropertyDefinition getProperty(QName propertyName) {
        CompiledModel model = this.getCompiledModelForNamespace(propertyName.getNamespaceURI());
        return model == null ? null : model.getProperty(propertyName);
    }

    @Override
    public ConstraintDefinition getConstraint(QName constraintQName) {
        CompiledModel model = this.getCompiledModelForNamespace(constraintQName.getNamespaceURI());
        return model == null ? null : model.getConstraint(constraintQName);
    }

    @Override
    public AssociationDefinition getAssociation(QName assocName) {
        CompiledModel model = this.getCompiledModelForNamespace(assocName.getNamespaceURI());
        return model == null ? null : model.getAssociation(assocName);
    }

    @Override
    public Collection<QName> getModels() {
        return this.compiledModels.keySet();
    }

    @Override
    public ModelDefinition getModel(QName name) {
        CompiledModel model = this.getCompiledModel(name);
        if (model != null) {
            return model.getModelDefinition();
        }
        return null;
    }

    @Override
    public Collection<TypeDefinition> getTypes(QName modelName) {
        CompiledModel model = this.getCompiledModel(modelName);
        return model.getTypes();
    }

    @Override
    public Collection<AspectDefinition> getAspects(QName modelName) {
        CompiledModel model = this.getCompiledModel(modelName);
        return model.getAspects();
    }

    @Override
    public TypeDefinition getAnonymousType(QName type, Collection<QName> aspects) {
        TypeDefinition typeDef = this.getType(type);
        if (typeDef == null) {
            throw new DictionaryException("d_dictionary.model.err.type_not_found", type);
        }
        ArrayList<AspectDefinition> aspectDefs = new ArrayList<AspectDefinition>();
        if (aspects != null) {
            for (QName aspect : aspects) {
                AspectDefinition aspectDef = this.getAspect(aspect);
                if (typeDef == null) {
                    throw new DictionaryException("d_dictionary.model.err.aspect_not_found", aspect);
                }
                aspectDefs.add(aspectDef);
            }
        }
        return new M2AnonymousTypeDefinition(typeDef, aspectDefs);
    }
}

