/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.i18n.I18NUtil;
import org.alfresco.repo.dictionary.DictionaryBootstrap;
import org.alfresco.repo.dictionary.DictionaryComponent;
import org.alfresco.repo.dictionary.DictionaryDAOImpl;
import org.alfresco.repo.dictionary.NamespaceDAOImpl;
import org.alfresco.repo.dictionary.constraint.RegexConstraint;
import org.alfresco.repo.dictionary.constraint.StringLengthConstraint;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.Constraint;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.InvalidTypeException;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.namespace.QName;

public class DictionaryDAOTest
extends TestCase {
    public static final String TEST_RESOURCE_MESSAGES = "alfresco/messages/dictionary-messages";
    private static final String TEST_URL = "http://www.alfresco.org/test/dictionarydaotest/1.0";
    private static final String TEST_MODEL = "org/alfresco/repo/dictionary/dictionarydaotest_model.xml";
    private static final String TEST_BUNDLE = "org/alfresco/repo/dictionary/dictionarydaotest_model";
    private DictionaryService service;

    public void setUp() {
        I18NUtil.registerResourceBundle((String)TEST_RESOURCE_MESSAGES);
        NamespaceDAOImpl namespaceDAO = new NamespaceDAOImpl();
        DictionaryDAOImpl dictionaryDAO = new DictionaryDAOImpl(namespaceDAO);
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("alfresco/model/dictionaryModel.xml");
        bootstrapModels.add(TEST_MODEL);
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(TEST_BUNDLE);
        bootstrap.setModels(bootstrapModels);
        bootstrap.setLabels(labels);
        bootstrap.setDictionaryDAO(dictionaryDAO);
        bootstrap.bootstrap();
        DictionaryComponent component = new DictionaryComponent();
        component.setDictionaryDAO(dictionaryDAO);
        this.service = component;
    }

    public void testBootstrap() {
        NamespaceDAOImpl namespaceDAO = new NamespaceDAOImpl();
        DictionaryDAOImpl dictionaryDAO = new DictionaryDAOImpl(namespaceDAO);
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("alfresco/model/dictionaryModel.xml");
        bootstrapModels.add("alfresco/model/systemModel.xml");
        bootstrapModels.add("alfresco/model/contentModel.xml");
        bootstrapModels.add("alfresco/model/applicationModel.xml");
        bootstrapModels.add("org/alfresco/repo/security/authentication/userModel.xml");
        bootstrapModels.add("org/alfresco/repo/action/actionModel.xml");
        bootstrapModels.add("org/alfresco/repo/rule/ruleModel.xml");
        bootstrapModels.add("org/alfresco/repo/version/version_model.xml");
        bootstrap.setModels(bootstrapModels);
        bootstrap.setDictionaryDAO(dictionaryDAO);
        bootstrap.bootstrap();
    }

    public void testLabels() {
        QName model = QName.createQName(TEST_URL, "dictionarydaotest");
        ModelDefinition modelDef = this.service.getModel(model);
        DictionaryDAOTest.assertEquals((String)"Model Description", (String)modelDef.getDescription());
        QName type = QName.createQName(TEST_URL, "base");
        TypeDefinition typeDef = this.service.getType(type);
        DictionaryDAOTest.assertEquals((String)"Base Title", (String)typeDef.getTitle());
        DictionaryDAOTest.assertEquals((String)"Base Description", (String)typeDef.getDescription());
        QName prop = QName.createQName(TEST_URL, "prop1");
        PropertyDefinition propDef = this.service.getProperty(prop);
        DictionaryDAOTest.assertEquals((String)"Prop1 Title", (String)propDef.getTitle());
        DictionaryDAOTest.assertEquals((String)"Prop1 Description", (String)propDef.getDescription());
        QName assoc = QName.createQName(TEST_URL, "assoc1");
        AssociationDefinition assocDef = this.service.getAssociation(assoc);
        DictionaryDAOTest.assertEquals((String)"Assoc1 Title", (String)assocDef.getTitle());
        DictionaryDAOTest.assertEquals((String)"Assoc1 Description", (String)assocDef.getDescription());
        QName datatype = QName.createQName(TEST_URL, "datatype");
        DataTypeDefinition datatypeDef = this.service.getDataType(datatype);
        DictionaryDAOTest.assertEquals((String)"Datatype Analyser", (String)datatypeDef.getAnalyserClassName());
    }

    public void testConstraints() {
        QName propNoConstraintsQName = QName.createQName(TEST_URL, "fileprop");
        PropertyDefinition propNoConstraintsDef = this.service.getProperty(propNoConstraintsQName);
        DictionaryDAOTest.assertNotNull((String)"Property without constraints returned null list", propNoConstraintsDef.getConstraints());
        QName prop1QName = QName.createQName(TEST_URL, "prop1");
        PropertyDefinition propDef = this.service.getProperty(prop1QName);
        List<ConstraintDefinition> constraints = propDef.getConstraints();
        DictionaryDAOTest.assertNotNull((String)"Null constraints list", constraints);
        DictionaryDAOTest.assertEquals((String)"Incorrect number of constraints", (int)2, (int)constraints.size());
        ConstraintDefinition constraintDef = constraints.get(0);
        DictionaryDAOTest.assertTrue((String)"Constraint anonymous name incorrect", (boolean)constraintDef.getName().getLocalName().startsWith("prop1_anon"));
        Constraint constraint = constraintDef.getConstraint();
        DictionaryDAOTest.assertNotNull((String)"Reference constraint has no implementation", (Object)constraint);
        DictionaryDAOTest.assertTrue((String)"Expected type REGEX constraint", (boolean)(constraint instanceof RegexConstraint));
    }

    public void testConstraintsOverrideInheritance() {
        QName baseQName = QName.createQName(TEST_URL, "base");
        QName fileQName = QName.createQName(TEST_URL, "file");
        QName folderQName = QName.createQName(TEST_URL, "folder");
        QName prop1QName = QName.createQName(TEST_URL, "prop1");
        PropertyDefinition prop1Def = this.service.getProperty(baseQName, prop1QName);
        DictionaryDAOTest.assertNotNull((Object)prop1Def);
        List<ConstraintDefinition> prop1Constraints = prop1Def.getConstraints();
        DictionaryDAOTest.assertEquals((String)"Incorrect number of constraints", (int)2, (int)prop1Constraints.size());
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(prop1Constraints.get(0).getConstraint() instanceof RegexConstraint));
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(prop1Constraints.get(1).getConstraint() instanceof StringLengthConstraint));
        prop1Def = this.service.getProperty(folderQName, prop1QName);
        DictionaryDAOTest.assertNotNull((Object)prop1Def);
        prop1Constraints = prop1Def.getConstraints();
        DictionaryDAOTest.assertEquals((String)"Incorrect number of constraints", (int)2, (int)prop1Constraints.size());
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(prop1Constraints.get(0).getConstraint() instanceof RegexConstraint));
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(prop1Constraints.get(1).getConstraint() instanceof StringLengthConstraint));
        prop1Def = this.service.getProperty(fileQName, prop1QName);
        DictionaryDAOTest.assertNotNull((Object)prop1Def);
        prop1Constraints = prop1Def.getConstraints();
        DictionaryDAOTest.assertEquals((String)"Incorrect number of constraints", (int)2, (int)prop1Constraints.size());
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(prop1Constraints.get(0).getConstraint() instanceof StringLengthConstraint));
        DictionaryDAOTest.assertTrue((String)"Constraint instance incorrect", (boolean)(prop1Constraints.get(1).getConstraint() instanceof RegexConstraint));
    }

    public void testArchive() {
        QName testFileQName = QName.createQName(TEST_URL, "file");
        ClassDefinition fileClassDef = this.service.getClass(testFileQName);
        DictionaryDAOTest.assertTrue((String)"File type should have the archive flag", (boolean)fileClassDef.isArchive());
        QName testFolderQName = QName.createQName(TEST_URL, "folder");
        ClassDefinition folderClassDef = this.service.getClass(testFolderQName);
        DictionaryDAOTest.assertFalse((String)"Folder type should not have the archive flag", (boolean)folderClassDef.isArchive());
    }

    public void testMandatoryEnforced() {
        QName testEnforcedQName = QName.createQName(TEST_URL, "enforced");
        ClassDefinition testEnforcedClassDef = this.service.getClass(testEnforcedQName);
        Map<QName, PropertyDefinition> testEnforcedPropertyDefs = testEnforcedClassDef.getProperties();
        PropertyDefinition propertyDef = null;
        QName testMandatoryEnforcedQName = QName.createQName(TEST_URL, "mandatory-enforced");
        propertyDef = testEnforcedPropertyDefs.get(testMandatoryEnforcedQName);
        DictionaryDAOTest.assertNotNull((String)("Property not found: " + testMandatoryEnforcedQName), (Object)propertyDef);
        DictionaryDAOTest.assertTrue((String)("Expected property to be mandatory: " + testMandatoryEnforcedQName), (boolean)propertyDef.isMandatory());
        DictionaryDAOTest.assertTrue((String)("Expected property to be mandatory-enforced: " + testMandatoryEnforcedQName), (boolean)propertyDef.isMandatoryEnforced());
        QName testMandatoryNotEnforcedQName = QName.createQName(TEST_URL, "mandatory-not-enforced");
        propertyDef = testEnforcedPropertyDefs.get(testMandatoryNotEnforcedQName);
        DictionaryDAOTest.assertNotNull((String)("Property not found: " + testMandatoryNotEnforcedQName), (Object)propertyDef);
        DictionaryDAOTest.assertTrue((String)("Expected property to be mandatory: " + testMandatoryNotEnforcedQName), (boolean)propertyDef.isMandatory());
        DictionaryDAOTest.assertFalse((String)("Expected property to be mandatory-not-enforced: " + testMandatoryNotEnforcedQName), (boolean)propertyDef.isMandatoryEnforced());
        QName testMandatoryDefaultEnforcedQName = QName.createQName(TEST_URL, "mandatory-default-enforced");
        propertyDef = testEnforcedPropertyDefs.get(testMandatoryDefaultEnforcedQName);
        DictionaryDAOTest.assertNotNull((String)("Property not found: " + testMandatoryDefaultEnforcedQName), (Object)propertyDef);
        DictionaryDAOTest.assertTrue((String)("Expected property to be mandatory: " + testMandatoryDefaultEnforcedQName), (boolean)propertyDef.isMandatory());
        DictionaryDAOTest.assertFalse((String)("Expected property to be mandatory-not-enforced: " + testMandatoryDefaultEnforcedQName), (boolean)propertyDef.isMandatoryEnforced());
    }

    public void testSubClassOf() {
        QName invalid = QName.createQName(TEST_URL, "invalid");
        QName base = QName.createQName(TEST_URL, "base");
        QName file = QName.createQName(TEST_URL, "file");
        QName folder = QName.createQName(TEST_URL, "folder");
        QName referenceable = QName.createQName(TEST_URL, "referenceable");
        try {
            this.service.isSubClass(invalid, referenceable);
            DictionaryDAOTest.fail((String)"Failed to catch invalid class parameter");
        }
        catch (InvalidTypeException e) {
            // empty catch block
        }
        try {
            this.service.isSubClass(referenceable, invalid);
            DictionaryDAOTest.fail((String)"Failed to catch invalid class parameter");
        }
        catch (InvalidTypeException e) {
            // empty catch block
        }
        boolean test1 = this.service.isSubClass(file, referenceable);
        DictionaryDAOTest.assertFalse((boolean)test1);
        boolean test2 = this.service.isSubClass(file, folder);
        DictionaryDAOTest.assertFalse((boolean)test2);
        boolean test3 = this.service.isSubClass(file, file);
        DictionaryDAOTest.assertTrue((boolean)test3);
        boolean test4 = this.service.isSubClass(folder, base);
        DictionaryDAOTest.assertTrue((boolean)test4);
        boolean test5 = this.service.isSubClass(base, folder);
        DictionaryDAOTest.assertFalse((boolean)test5);
    }
}

