/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListener;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryModelType
implements ContentServicePolicies.OnContentUpdatePolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy,
NodeServicePolicies.BeforeDeleteNodePolicy {
    private static final String KEY_PENDING_MODELS = "dictionaryModelType.pendingModels";
    private DictionaryDAO dictionaryDAO;
    private NamespaceDAO namespaceDAO;
    private NodeService nodeService;
    private ContentService contentService;
    private PolicyComponent policyComponent;
    private DictionaryModelTypeTransactionListener transactionListener;

    public void setDictionaryDAO(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    public void setNamespaceDAO(NamespaceDAO namespaceDAO) {
        this.namespaceDAO = namespaceDAO;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(ContentServicePolicies.ON_CONTENT_UPDATE, ContentModel.TYPE_DICTIONARY_MODEL, (Behaviour)new JavaBehaviour(this, "onContentUpdate"));
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onUpdateProperties"), ContentModel.TYPE_DICTIONARY_MODEL, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "beforeDeleteNode"), ContentModel.TYPE_DICTIONARY_MODEL, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
        this.transactionListener = new DictionaryModelTypeTransactionListener(this.nodeService, this.contentService);
    }

    @Override
    public void onContentUpdate(NodeRef nodeRef, boolean newContent) {
        this.queueModel(nodeRef);
    }

    private void queueModel(NodeRef nodeRef) {
        HashSet<NodeRef> pendingModelUpdates = (HashSet<NodeRef>)AlfrescoTransactionSupport.getResource(KEY_PENDING_MODELS);
        if (pendingModelUpdates == null) {
            pendingModelUpdates = new HashSet<NodeRef>();
            AlfrescoTransactionSupport.bindResource(KEY_PENDING_MODELS, pendingModelUpdates);
        }
        pendingModelUpdates.add(nodeRef);
        AlfrescoTransactionSupport.bindListener(this.transactionListener);
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        Boolean beforeValue = (Boolean)before.get(ContentModel.PROP_MODEL_ACTIVE);
        Boolean afterValue = (Boolean)after.get(ContentModel.PROP_MODEL_ACTIVE);
        if (beforeValue == null && afterValue != null) {
            this.queueModel(nodeRef);
        } else if (afterValue == null && beforeValue != null) {
            this.queueModel(nodeRef);
        } else if (beforeValue != null && afterValue != null && !beforeValue.equals(afterValue)) {
            this.queueModel(nodeRef);
        }
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        QName modelName;
        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY) && (modelName = (QName)this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODEL_NAME)) != null) {
            this.dictionaryDAO.removeModel(modelName);
        }
    }

    public class DictionaryModelTypeTransactionListener
    implements TransactionListener {
        private String id = GUID.generate();
        private NodeService nodeService;
        private ContentService contentService;

        public DictionaryModelTypeTransactionListener(NodeService nodeService, ContentService contentService) {
            this.nodeService = nodeService;
            this.contentService = contentService;
        }

        public void flush() {
        }

        public void beforeCommit(boolean readOnly) {
            Set pendingModels = (Set)AlfrescoTransactionSupport.getResource(DictionaryModelType.KEY_PENDING_MODELS);
            if (pendingModels != null) {
                for (NodeRef nodeRef : pendingModels) {
                    boolean isActive = false;
                    Boolean value = (Boolean)this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODEL_ACTIVE);
                    if (value != null) {
                        isActive = value;
                    }
                    if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY)) continue;
                    if (isActive) {
                        ContentReader contentReader = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
                        if (contentReader == null) continue;
                        M2Model m2Model = M2Model.createModel(contentReader.getContentInputStream());
                        ModelDefinition modelDefintion = m2Model.compile(DictionaryModelType.this.dictionaryDAO, DictionaryModelType.this.namespaceDAO).getModelDefinition();
                        Map<QName, Serializable> props = this.nodeService.getProperties(nodeRef);
                        props.put(ContentModel.PROP_MODEL_NAME, modelDefintion.getName());
                        props.put(ContentModel.PROP_MODEL_DESCRIPTION, (Serializable)((Object)modelDefintion.getDescription()));
                        props.put(ContentModel.PROP_MODEL_AUTHOR, (Serializable)((Object)modelDefintion.getAuthor()));
                        props.put(ContentModel.PROP_MODEL_PUBLISHED_DATE, modelDefintion.getPublishedDate());
                        props.put(ContentModel.PROP_MODEL_VERSION, (Serializable)((Object)modelDefintion.getVersion()));
                        this.nodeService.setProperties(nodeRef, props);
                        DictionaryModelType.this.dictionaryDAO.putModel(m2Model);
                        continue;
                    }
                    QName modelName = (QName)this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODEL_NAME);
                    if (modelName == null) continue;
                    DictionaryModelType.this.dictionaryDAO.removeModel(modelName);
                }
            }
        }

        public void beforeCompletion() {
        }

        public void afterCommit() {
        }

        public void afterRollback() {
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof DictionaryModelTypeTransactionListener) {
                DictionaryModelTypeTransactionListener that = (DictionaryModelTypeTransactionListener)obj;
                return this.id.equals(that.id);
            }
            return false;
        }
    }
}

