/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import junit.framework.Assert;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.transaction.TransactionUtil;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.PropertyMap;

public class DictionaryModelTypeTest
extends BaseAlfrescoSpringTest {
    private static final QName TEST_MODEL_ONE = QName.createQName("{http://www.alfresco.org/test/testmodel1/1.0}testModelOne");
    public static final String MODEL_ONE_XML = "<model name='test1:testModelOne' xmlns='http://www.alfresco.org/model/dictionary/1.0'>   <description>Test model one</description>   <author>Alfresco</author>   <published>2005-05-30</published>   <version>1.0</version>   <imports>      <import uri='http://www.alfresco.org/model/dictionary/1.0' prefix='d'/>   </imports>   <namespaces>      <namespace uri='http://www.alfresco.org/test/testmodel1/1.0' prefix='test1'/>   </namespaces>   <types>      <type name='test1:base'>        <title>Base</title>        <description>The Base Type</description>        <properties>           <property name='test1:prop1'>              <type>d:text</type>           </property>        </properties>      </type>   </types></model>";
    public static final String MODEL_ONE_MODIFIED_XML = "<model name='test1:testModelOne' xmlns='http://www.alfresco.org/model/dictionary/1.0'>   <description>Test model one (updated)</description>   <author>Alfresco</author>   <published>2005-05-30</published>   <version>1.1</version>   <imports>      <import uri='http://www.alfresco.org/model/dictionary/1.0' prefix='d'/>   </imports>   <namespaces>      <namespace uri='http://www.alfresco.org/test/testmodel1/1.0' prefix='test1'/>   </namespaces>   <types>      <type name='test1:base'>        <title>Base</title>        <description>The Base Type</description>        <properties>           <property name='test1:prop1'>              <type>d:text</type>           </property>           <property name='test1:prop2'>              <type>d:text</type>           </property>        </properties>      </type>   </types></model>";
    private DictionaryService dictionaryService;
    private NamespaceService namespaceService;
    private CheckOutCheckInService cociService;
    private DictionaryDAO dictionaryDAO;

    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.dictionaryService = (DictionaryService)this.applicationContext.getBean("dictionaryService");
        this.namespaceService = (NamespaceService)this.applicationContext.getBean("namespaceService");
        this.cociService = (CheckOutCheckInService)this.applicationContext.getBean("checkOutCheckInService");
        this.dictionaryDAO = (DictionaryDAO)this.applicationContext.getBean("dictionaryDAO");
    }

    public void testCreateAndUpdateDictionaryModelNodeContent() {
        try {
            this.dictionaryService.getModel(TEST_MODEL_ONE);
            DictionaryModelTypeTest.fail((String)"This model has not yet been loaded into the dictionary service");
        }
        catch (DictionaryException exception) {
            // empty catch block
        }
        String uri = this.namespaceService.getNamespaceURI("test1");
        DictionaryModelTypeTest.assertNull((Object)uri);
        PropertyMap properties = new PropertyMap(1);
        properties.put(ContentModel.PROP_MODEL_ACTIVE, true);
        final NodeRef modelNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("http://www.alfresco.org", "dictionaryModels"), ContentModel.TYPE_DICTIONARY_MODEL, properties).getChildRef();
        DictionaryModelTypeTest.assertNotNull((Object)modelNode);
        ContentWriter contentWriter = this.contentService.getWriter(modelNode, ContentModel.PROP_CONTENT, true);
        contentWriter.setEncoding("UTF-8");
        contentWriter.setMimetype("text/xml");
        contentWriter.putContent(MODEL_ONE_XML);
        this.setComplete();
        this.endTransaction();
        final NodeRef workingCopy = TransactionUtil.executeInUserTransaction(this.transactionService, new TransactionUtil.TransactionWork<NodeRef>(){

            @Override
            public NodeRef doWork() throws Exception {
                Assert.assertEquals((Object)QName.createQName("{http://www.alfresco.org/test/testmodel1/1.0}testModelOne"), (Object)DictionaryModelTypeTest.this.nodeService.getProperty(modelNode, ContentModel.PROP_MODEL_NAME));
                Assert.assertEquals((Object)"Test model one", (Object)DictionaryModelTypeTest.this.nodeService.getProperty(modelNode, ContentModel.PROP_MODEL_DESCRIPTION));
                Assert.assertEquals((Object)"Alfresco", (Object)DictionaryModelTypeTest.this.nodeService.getProperty(modelNode, ContentModel.PROP_MODEL_AUTHOR));
                Assert.assertEquals((Object)"1.0", (Object)DictionaryModelTypeTest.this.nodeService.getProperty(modelNode, ContentModel.PROP_MODEL_VERSION));
                ModelDefinition modelDefinition2 = DictionaryModelTypeTest.this.dictionaryService.getModel(TEST_MODEL_ONE);
                Assert.assertNotNull((Object)modelDefinition2);
                Assert.assertEquals((String)"Test model one", (String)modelDefinition2.getDescription());
                String uri2 = DictionaryModelTypeTest.this.namespaceService.getNamespaceURI("test1");
                Assert.assertEquals((String)uri2, (String)"http://www.alfresco.org/test/testmodel1/1.0");
                NodeRef workingCopy = DictionaryModelTypeTest.this.cociService.checkout(modelNode);
                ContentWriter contentWriter2 = DictionaryModelTypeTest.this.contentService.getWriter(workingCopy, ContentModel.PROP_CONTENT, true);
                contentWriter2.putContent(DictionaryModelTypeTest.MODEL_ONE_MODIFIED_XML);
                return workingCopy;
            }
        });
        TransactionUtil.executeInUserTransaction(this.transactionService, new TransactionUtil.TransactionWork<Object>(){

            @Override
            public Object doWork() throws Exception {
                Assert.assertEquals((Object)"1.0", (Object)DictionaryModelTypeTest.this.nodeService.getProperty(workingCopy, ContentModel.PROP_MODEL_VERSION));
                DictionaryModelTypeTest.this.cociService.checkin(workingCopy, null);
                return null;
            }
        });
        TransactionUtil.executeInUserTransaction(this.transactionService, new TransactionUtil.TransactionWork<Object>(){

            @Override
            public Object doWork() throws Exception {
                Assert.assertEquals((Object)"1.1", (Object)DictionaryModelTypeTest.this.nodeService.getProperty(modelNode, ContentModel.PROP_MODEL_VERSION));
                return null;
            }
        });
    }

    public void testIsActiveFlagAndDelete() {
        this.dictionaryDAO.removeModel(TEST_MODEL_ONE);
        try {
            this.dictionaryService.getModel(TEST_MODEL_ONE);
            DictionaryModelTypeTest.fail((String)"This model has not yet been loaded into the dictionary service");
        }
        catch (DictionaryException exception) {
            // empty catch block
        }
        PropertyMap properties = new PropertyMap(1);
        final NodeRef modelNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("http://www.alfresco.org", "dictionaryModels"), ContentModel.TYPE_DICTIONARY_MODEL, properties).getChildRef();
        DictionaryModelTypeTest.assertNotNull((Object)modelNode);
        ContentWriter contentWriter = this.contentService.getWriter(modelNode, ContentModel.PROP_CONTENT, true);
        contentWriter.setEncoding("UTF-8");
        contentWriter.setMimetype("text/xml");
        contentWriter.putContent(MODEL_ONE_XML);
        this.setComplete();
        this.endTransaction();
        TransactionUtil.executeInUserTransaction(this.transactionService, new TransactionUtil.TransactionWork<Object>(){

            @Override
            public Object doWork() throws Exception {
                try {
                    DictionaryModelTypeTest.this.dictionaryService.getModel(TEST_MODEL_ONE);
                    Assert.fail((String)"This model has not yet been loaded into the dictionary service");
                }
                catch (DictionaryException dictionaryException) {
                    // empty catch block
                }
                DictionaryModelTypeTest.this.nodeService.setProperty(modelNode, ContentModel.PROP_MODEL_ACTIVE, Boolean.valueOf(true));
                return null;
            }
        });
        TransactionUtil.executeInUserTransaction(this.transactionService, new TransactionUtil.TransactionWork<Object>(){

            @Override
            public Object doWork() throws Exception {
                Assert.assertNotNull((Object)DictionaryModelTypeTest.this.dictionaryService.getModel(TEST_MODEL_ONE));
                DictionaryModelTypeTest.this.nodeService.setProperty(modelNode, ContentModel.PROP_MODEL_ACTIVE, Boolean.valueOf(false));
                return null;
            }
        });
        TransactionUtil.executeInUserTransaction(this.transactionService, new TransactionUtil.TransactionWork<Object>(){

            @Override
            public Object doWork() throws Exception {
                try {
                    DictionaryModelTypeTest.this.dictionaryService.getModel(TEST_MODEL_ONE);
                    Assert.fail((String)"This model has not yet been loaded into the dictionary service");
                }
                catch (DictionaryException dictionaryException) {
                    // empty catch block
                }
                DictionaryModelTypeTest.this.nodeService.setProperty(modelNode, ContentModel.PROP_MODEL_ACTIVE, Boolean.valueOf(true));
                return null;
            }
        });
        TransactionUtil.executeInUserTransaction(this.transactionService, new TransactionUtil.TransactionWork<Object>(){

            @Override
            public Object doWork() throws Exception {
                Assert.assertNotNull((Object)DictionaryModelTypeTest.this.dictionaryService.getModel(TEST_MODEL_ONE));
                DictionaryModelTypeTest.this.nodeService.deleteNode(modelNode);
                try {
                    DictionaryModelTypeTest.this.dictionaryService.getModel(TEST_MODEL_ONE);
                    Assert.fail((String)"This model has not yet been loaded into the dictionary service");
                }
                catch (DictionaryException dictionaryException) {
                    // empty catch block
                }
                return null;
            }
        });
    }
}

