/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Namespace;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.TransactionUtil;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.transaction.TransactionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryRepositoryBootstrap {
    private List<RepositoryLocation> repositoryLocations = new ArrayList<RepositoryLocation>();
    private DictionaryDAO dictionaryDAO = null;
    private SearchService searchService;
    private ContentService contentService;
    private TransactionService transactionService;
    private AuthenticationComponent authenticationComponent;

    public void setDictionaryDAO(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setAuthenticationComponent(AuthenticationComponent authenticationComponent) {
        this.authenticationComponent = authenticationComponent;
    }

    public void setRepositoryLocations(List<RepositoryLocation> repositoryLocations) {
        this.repositoryLocations = repositoryLocations;
    }

    public void bootstrap() {
        TransactionUtil.executeInUserTransaction(this.transactionService, new TransactionUtil.TransactionWork(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doWork() throws Exception {
                DictionaryRepositoryBootstrap.this.authenticationComponent.setCurrentUser(DictionaryRepositoryBootstrap.this.authenticationComponent.getSystemUserName());
                try {
                    DictionaryRepositoryBootstrap.this.bootstrapImpl();
                }
                finally {
                    DictionaryRepositoryBootstrap.this.authenticationComponent.clearCurrentSecurityContext();
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrapImpl() {
        HashMap<String, M2Model> modelMap = new HashMap<String, M2Model>();
        for (RepositoryLocation repositoryLocation : this.repositoryLocations) {
            ResultSet resultSet = null;
            try {
                resultSet = this.searchService.query(repositoryLocation.getStoreRef(), "lucene", repositoryLocation.getQueryStatement());
                for (NodeRef dictionaryModel : resultSet.getNodeRefs()) {
                    M2Model model = this.createM2Model(dictionaryModel);
                    if (model == null) continue;
                    for (M2Namespace namespace : model.getNamespaces()) {
                        modelMap.put(namespace.getUri(), model);
                    }
                }
            }
            finally {
                if (resultSet == null) continue;
                resultSet.close();
            }
        }
        ArrayList<String> loadedModels = new ArrayList<String>();
        for (Map.Entry entry : modelMap.entrySet()) {
            this.loadModel(modelMap, loadedModels, (M2Model)entry.getValue());
        }
    }

    private void loadModel(Map<String, M2Model> modelMap, List<String> loadedModels, M2Model model) {
        String modelName = model.getName();
        if (!loadedModels.contains(modelName)) {
            for (M2Namespace importNamespace : model.getImports()) {
                M2Model importedModel = modelMap.get(importNamespace.getUri());
                if (importedModel == null) continue;
                this.loadModel(modelMap, loadedModels, importedModel);
            }
            this.dictionaryDAO.putModel(model);
            loadedModels.add(modelName);
        }
    }

    public M2Model createM2Model(NodeRef nodeRef) {
        M2Model model = null;
        ContentReader contentReader = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
        if (contentReader != null) {
            model = M2Model.createModel(contentReader.getContentInputStream());
        }
        return model;
    }

    public class RepositoryLocation {
        private String storeProtocol;
        private String storeId;
        private String path;

        public void setStoreProtocol(String storeProtocol) {
            this.storeProtocol = storeProtocol;
        }

        public void setStoreId(String storeId) {
            this.storeId = storeId;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public StoreRef getStoreRef() {
            return new StoreRef(this.storeProtocol, this.storeId);
        }

        public String getQueryStatement() {
            String result = "+TYPE:\"" + ContentModel.TYPE_DICTIONARY_MODEL.toString() + "\"";
            if (this.path != null) {
                result = result + " +PATH:\"" + this.path + "\"";
            }
            return result;
        }
    }
}

