/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ChildAssociationDefinition;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class M2AnonymousTypeDefinition
implements TypeDefinition {
    private TypeDefinition type;
    private Map<QName, PropertyDefinition> properties = new HashMap<QName, PropertyDefinition>();
    private Map<QName, AssociationDefinition> associations = new HashMap<QName, AssociationDefinition>();
    private Map<QName, ChildAssociationDefinition> childassociations = new HashMap<QName, ChildAssociationDefinition>();

    M2AnonymousTypeDefinition(TypeDefinition type, Collection<AspectDefinition> aspects) {
        this.type = type;
        this.properties.putAll(type.getProperties());
        this.associations.putAll(type.getAssociations());
        this.childassociations.putAll(type.getChildAssociations());
        for (AspectDefinition aspect : aspects) {
            this.properties.putAll(aspect.getProperties());
            this.associations.putAll(aspect.getAssociations());
            this.childassociations.putAll(aspect.getChildAssociations());
        }
    }

    @Override
    public ModelDefinition getModel() {
        return this.type.getModel();
    }

    @Override
    public List<AspectDefinition> getDefaultAspects() {
        return this.type.getDefaultAspects();
    }

    @Override
    public QName getName() {
        return QName.createQName("http://www.alfresco.org/model/dictionary/1.0", "anonymous#" + this.type.getName().getLocalName());
    }

    @Override
    public String getTitle() {
        return this.type.getTitle();
    }

    @Override
    public String getDescription() {
        return this.type.getDescription();
    }

    @Override
    public QName getParentName() {
        return this.type.getParentName();
    }

    @Override
    public boolean isAspect() {
        return this.type.isAspect();
    }

    @Override
    public boolean isArchive() {
        return this.type.isArchive();
    }

    @Override
    public Map<QName, PropertyDefinition> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public Map<QName, Serializable> getDefaultValues() {
        HashMap<QName, String> result = new HashMap<QName, String>(5);
        for (Map.Entry<QName, PropertyDefinition> entry : this.properties.entrySet()) {
            PropertyDefinition propertyDefinition = entry.getValue();
            String defaultValue = propertyDefinition.getDefaultValue();
            if (defaultValue == null) continue;
            result.put(entry.getKey(), defaultValue);
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public Map<QName, AssociationDefinition> getAssociations() {
        return Collections.unmodifiableMap(this.associations);
    }

    @Override
    public boolean isContainer() {
        return !this.childassociations.isEmpty();
    }

    @Override
    public Map<QName, ChildAssociationDefinition> getChildAssociations() {
        return Collections.unmodifiableMap(this.childassociations);
    }
}

