/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import org.alfresco.repo.dictionary.M2ChildAssociation;
import org.alfresco.repo.dictionary.M2ClassAssociation;
import org.alfresco.repo.dictionary.M2Label;
import org.alfresco.repo.dictionary.ModelQuery;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;

class M2AssociationDefinition
implements AssociationDefinition {
    private ClassDefinition classDef;
    private M2ClassAssociation assoc;
    private QName name;
    private QName targetClassName;
    private ClassDefinition targetClass;
    private QName sourceRoleName;
    private QName targetRoleName;

    M2AssociationDefinition(ClassDefinition classDef, M2ClassAssociation assoc, NamespacePrefixResolver resolver) {
        this.classDef = classDef;
        this.assoc = assoc;
        this.name = QName.createQName(assoc.getName(), resolver);
        this.targetClassName = QName.createQName(assoc.getTargetClassName(), resolver);
        this.sourceRoleName = QName.createQName(assoc.getSourceRoleName(), resolver);
        this.targetRoleName = QName.createQName(assoc.getTargetRoleName(), resolver);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(56);
        sb.append("Association").append("[ class=").append(this.classDef).append(", name=").append(this.name).append(", target class=").append(this.targetClassName).append(", source role=").append(this.sourceRoleName).append(", target role=").append(this.targetRoleName).append("]");
        return sb.toString();
    }

    M2ClassAssociation getM2Association() {
        return this.assoc;
    }

    void resolveDependencies(ModelQuery query) {
        if (this.targetClassName == null) {
            throw new DictionaryException("Target class of association " + this.name.toPrefixString() + " must be specified");
        }
        this.targetClass = query.getClass(this.targetClassName);
        if (this.targetClass == null) {
            throw new DictionaryException("Target class " + this.targetClassName.toPrefixString() + " of association " + this.name.toPrefixString() + " is not found");
        }
    }

    public ModelDefinition getModel() {
        return this.classDef.getModel();
    }

    public QName getName() {
        return this.name;
    }

    public boolean isChild() {
        return this.assoc instanceof M2ChildAssociation;
    }

    public String getTitle() {
        String value = M2Label.getLabel(this.classDef.getModel(), "association", this.name, "title");
        if (value == null) {
            value = this.assoc.getTitle();
        }
        return value;
    }

    public String getDescription() {
        String value = M2Label.getLabel(this.classDef.getModel(), "association", this.name, "description");
        if (value == null) {
            value = this.assoc.getDescription();
        }
        return value;
    }

    public boolean isProtected() {
        return this.assoc.isProtected();
    }

    public ClassDefinition getSourceClass() {
        return this.classDef;
    }

    public QName getSourceRoleName() {
        return this.sourceRoleName;
    }

    public boolean isSourceMandatory() {
        return this.assoc.isSourceMandatory();
    }

    public boolean isSourceMany() {
        return this.assoc.isSourceMany();
    }

    public ClassDefinition getTargetClass() {
        return this.targetClass;
    }

    public QName getTargetRoleName() {
        return this.targetRoleName;
    }

    public boolean isTargetMandatory() {
        return this.assoc.isTargetMandatory();
    }

    public boolean isTargetMany() {
        return this.assoc.isTargetMany();
    }
}

