/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.List;
import org.alfresco.repo.dictionary.M2Constraint;
import org.alfresco.repo.dictionary.M2NamedValue;
import org.alfresco.repo.dictionary.M2PropertyDefinition;
import org.alfresco.repo.dictionary.ModelQuery;
import org.alfresco.repo.dictionary.constraint.ListOfValuesConstraint;
import org.alfresco.repo.dictionary.constraint.NumericRangeConstraint;
import org.alfresco.repo.dictionary.constraint.RegexConstraint;
import org.alfresco.repo.dictionary.constraint.StringLengthConstraint;
import org.alfresco.service.cmr.dictionary.Constraint;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.PropertyAccessException;

class M2ConstraintDefinition
implements ConstraintDefinition {
    public static final String ERR_CYCLIC_REF = "d_dictionary.constraint.err.cyclic_ref";
    public static final String ERR_TYPE_AND_REF = "d_dictionary.constraint.err.type_and_ref";
    public static final String ERR_TYPE_OR_REF = "d_dictionary.constraint.err.type_or_ref";
    public static final String ERR_REF_NOT_FOUND = "d_dictionary.constraint.err.ref_not_found";
    public static final String ERR_ANON_NEEDS_PROPERTY = "d_dictionary.constraint.err.anon_needs_property";
    public static final String ERR_INVALID_TYPE = "d_dictionary.constraint.err.invalid_type";
    public static final String ERR_SIMPLE_AND_LIST = "d_dictionary.constraint.err.property_simple_and_list";
    public static final String ERR_CONSTRUCT_FAILURE = "d_dictionary.constraint.err.construct_failure";
    public static final String ERR_PROPERTY_MISMATCH = "d_dictionary.constraint.err.property_mismatch";
    private static int anonPropCount = 0;
    private ModelDefinition model;
    private NamespacePrefixResolver prefixResolver;
    private M2Constraint m2Constraint;
    private QName name;
    private Constraint constraint;
    private boolean resolving;

    M2ConstraintDefinition(M2PropertyDefinition m2PropertyDef, M2Constraint m2Constraint, NamespacePrefixResolver prefixResolver) {
        this(m2PropertyDef.getModel(), m2PropertyDef, m2Constraint, prefixResolver);
    }

    M2ConstraintDefinition(ModelDefinition modelDefinition, M2PropertyDefinition m2PropertyDef, M2Constraint m2Constraint, NamespacePrefixResolver prefixResolver) {
        this.model = modelDefinition;
        this.m2Constraint = m2Constraint;
        this.prefixResolver = prefixResolver;
        String constraintName = m2Constraint.getName();
        if (constraintName == null) {
            if (m2PropertyDef == null) {
                throw new DictionaryException(ERR_ANON_NEEDS_PROPERTY);
            }
            String localName = m2PropertyDef.getName().getLocalName() + "_anon_" + ++anonPropCount;
            this.name = QName.createQName(m2PropertyDef.getName().getNamespaceURI(), localName);
            m2Constraint.setName(localName);
        } else {
            this.name = QName.createQName(m2Constraint.getName(), prefixResolver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void resolveDependencies(ModelQuery query) {
        if (this.resolving) {
            throw new DictionaryException(ERR_CYCLIC_REF, this.name.toPrefixString());
        }
        try {
            this.resolving = true;
            this.resolveInternal(query);
        }
        finally {
            this.resolving = false;
        }
    }

    private synchronized void resolveInternal(ModelQuery query) {
        if (this.constraint != null) {
            return;
        }
        String shortName = this.name.toPrefixString();
        String ref = this.m2Constraint.getRef();
        String type = this.m2Constraint.getType();
        if (ref != null && type != null) {
            throw new DictionaryException(ERR_TYPE_AND_REF, shortName);
        }
        if (ref == null && type == null) {
            throw new DictionaryException(ERR_TYPE_OR_REF, shortName);
        }
        if (ref != null) {
            QName qnameRef = QName.createQName(ref, this.prefixResolver);
            M2ConstraintDefinition constraintDef = (M2ConstraintDefinition)query.getConstraint(qnameRef);
            if (constraintDef == null) {
                throw new DictionaryException(ERR_REF_NOT_FOUND, ref, shortName);
            }
            constraintDef.resolveDependencies(query);
            this.constraint = constraintDef.getConstraint();
        } else {
            try {
                ConstraintType constraintType = ConstraintType.valueOf(type);
                this.constraint = constraintType.newInstance();
            }
            catch (IllegalArgumentException e) {
                try {
                    Class<?> clazz = Class.forName(type);
                    this.constraint = (Constraint)clazz.newInstance();
                }
                catch (ClassNotFoundException ee) {
                    throw new DictionaryException(ERR_INVALID_TYPE, type, shortName);
                }
                catch (ClassCastException ee) {
                    throw new DictionaryException(ERR_INVALID_TYPE, type, shortName);
                }
                catch (Exception ee) {
                    throw new DictionaryException(ERR_CONSTRUCT_FAILURE, type, shortName);
                }
            }
            BeanWrapperImpl beanWrapper = new BeanWrapperImpl((Object)this.constraint);
            List<M2NamedValue> constraintNamedValues = this.m2Constraint.getParameters();
            for (M2NamedValue namedValue : constraintNamedValues) {
                Object value = null;
                if (namedValue.getSimpleValue() != null && namedValue.getListValue() != null) {
                    throw new DictionaryException(ERR_SIMPLE_AND_LIST, shortName, namedValue.getName());
                }
                if (namedValue.getSimpleValue() != null) {
                    value = namedValue.getSimpleValue();
                } else if (namedValue.getListValue() != null) {
                    value = namedValue.getListValue();
                }
                try {
                    beanWrapper.setPropertyValue(namedValue.getName(), value);
                }
                catch (PropertyAccessException e) {
                    throw new DictionaryException(ERR_PROPERTY_MISMATCH, e, namedValue.getName(), shortName);
                }
                catch (InvalidPropertyException e) {
                    throw new DictionaryException(ERR_PROPERTY_MISMATCH, e, namedValue.getName(), shortName);
                }
            }
            this.constraint.initialize();
        }
    }

    public String toString() {
        return this.getName().toString();
    }

    public ModelDefinition getModel() {
        return this.model;
    }

    public QName getName() {
        return this.name;
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConstraintType {
        REGEX{

            protected Constraint newInstance() {
                return new RegexConstraint();
            }
        }
        ,
        MINMAX{

            protected Constraint newInstance() {
                return new NumericRangeConstraint();
            }
        }
        ,
        LENGTH{

            protected Constraint newInstance() {
                return new StringLengthConstraint();
            }
        }
        ,
        LIST{

            protected Constraint newInstance() {
                return new ListOfValuesConstraint();
            }
        };


        protected abstract Constraint newInstance();
    }
}

