/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.dictionary.M2Constraint;
import org.alfresco.repo.dictionary.M2ConstraintDefinition;
import org.alfresco.repo.dictionary.M2Label;
import org.alfresco.repo.dictionary.M2Property;
import org.alfresco.repo.dictionary.M2PropertyOverride;
import org.alfresco.repo.dictionary.ModelQuery;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class M2PropertyDefinition
implements PropertyDefinition {
    private ClassDefinition classDef;
    private M2Property m2Property;
    private QName name;
    private QName propertyTypeName;
    private DataTypeDefinition dataType;
    private List<ConstraintDefinition> constraintDefs = Collections.emptyList();

    M2PropertyDefinition(ClassDefinition classDef, M2Property m2Property, NamespacePrefixResolver prefixResolver) {
        this.classDef = classDef;
        this.m2Property = m2Property;
        this.name = QName.createQName(m2Property.getName(), prefixResolver);
        this.propertyTypeName = QName.createQName(m2Property.getType(), prefixResolver);
    }

    M2PropertyDefinition(ClassDefinition classDef, PropertyDefinition propertyDef, M2PropertyOverride override, NamespacePrefixResolver prefixResolver, Map<QName, ConstraintDefinition> modelConstraints) {
        this.classDef = classDef;
        this.m2Property = this.createOverriddenProperty(propertyDef, override, prefixResolver, modelConstraints);
        this.name = propertyDef.getName();
        this.dataType = propertyDef.getDataType();
        this.propertyTypeName = this.dataType.getName();
    }

    void resolveDependencies(ModelQuery query, NamespacePrefixResolver prefixResolver, Map<QName, ConstraintDefinition> modelConstraints) {
        if (this.propertyTypeName == null) {
            throw new DictionaryException("d_dictionary.property.err.property_type_not_specified", this.name.toPrefixString());
        }
        this.dataType = query.getDataType(this.propertyTypeName);
        if (this.dataType == null) {
            throw new DictionaryException("d_dictionary.property.err.property_type_not_found", this.propertyTypeName.toPrefixString(), this.name.toPrefixString());
        }
        if (this.propertyTypeName.equals(DataTypeDefinition.CONTENT) && this.isMultiValued()) {
            throw new DictionaryException("d_dictionary.property.err.single_valued_content");
        }
        this.constraintDefs = M2PropertyDefinition.buildConstraints(this.m2Property.getConstraints(), this, prefixResolver, modelConstraints);
    }

    private static List<ConstraintDefinition> buildConstraints(List<M2Constraint> m2constraints, M2PropertyDefinition m2PropertyDef, NamespacePrefixResolver prefixResolver, Map<QName, ConstraintDefinition> modelConstraints) {
        ArrayList<ConstraintDefinition> constraints = new ArrayList<ConstraintDefinition>(5);
        HashMap<QName, M2ConstraintDefinition> constraintsByQName = new HashMap<QName, M2ConstraintDefinition>(7);
        for (M2Constraint constraint : m2constraints) {
            M2ConstraintDefinition def = new M2ConstraintDefinition(m2PropertyDef, constraint, prefixResolver);
            QName qname = def.getName();
            if (constraintsByQName.containsKey(qname)) {
                throw new DictionaryException("d_dictionary.property.err.duplicate_constraint_on_property", def.getName().toPrefixString(), m2PropertyDef.name.toPrefixString());
            }
            if (modelConstraints.containsKey(qname)) {
                throw new DictionaryException("d_dictionary.model.err.duplicate_constraint_on_model", def.getName().toPrefixString());
            }
            constraintsByQName.put(qname, def);
            constraints.add(def);
            modelConstraints.put(qname, def);
        }
        return constraints;
    }

    private M2Property createOverriddenProperty(PropertyDefinition propertyDef, M2PropertyOverride override, NamespacePrefixResolver prefixResolver, Map<QName, ConstraintDefinition> modelConstraints) {
        M2Property property = new M2Property();
        String defaultValue = override.getDefaultValue();
        property.setDefaultValue(defaultValue == null ? propertyDef.getDefaultValue() : defaultValue);
        Boolean isOverrideMandatory = override.isMandatory();
        boolean isOverrideMandatoryEnforced = override.isMandatoryEnforced();
        if (isOverrideMandatory != null && propertyDef.isMandatory()) {
            if (!isOverrideMandatory.booleanValue()) {
                throw new DictionaryException("d_dictionary.property.err.cannot_relax_mandatory", propertyDef.getName().toPrefixString());
            }
            if (!isOverrideMandatoryEnforced && propertyDef.isMandatoryEnforced()) {
                throw new DictionaryException("d_dictionary.property.err.cannot_relax_mandatory_enforcement", propertyDef.getName().toPrefixString());
            }
        }
        property.setMandatory(isOverrideMandatory == null ? propertyDef.isMandatory() : isOverrideMandatory.booleanValue());
        property.setMandatoryEnforced(isOverrideMandatoryEnforced);
        List<M2Constraint> overrideConstraints = override.getConstraints();
        this.constraintDefs = overrideConstraints != null ? M2PropertyDefinition.buildConstraints(overrideConstraints, (M2PropertyDefinition)propertyDef, prefixResolver, modelConstraints) : propertyDef.getConstraints();
        property.setDescription(propertyDef.getDescription());
        property.setIndexed(propertyDef.isIndexed());
        property.setIndexedAtomically(propertyDef.isIndexedAtomically());
        property.setMultiValued(propertyDef.isMultiValued());
        property.setProtected(propertyDef.isProtected());
        property.setStoredInIndex(propertyDef.isStoredInIndex());
        property.setTitle(propertyDef.getTitle());
        property.setTokenisedInIndex(propertyDef.isTokenisedInIndex());
        return property;
    }

    public String toString() {
        return this.getName().toString();
    }

    @Override
    public ModelDefinition getModel() {
        return this.classDef.getModel();
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        String value = M2Label.getLabel(this.classDef.getModel(), "property", this.name, "title");
        if (value == null) {
            value = this.m2Property.getTitle();
        }
        return value;
    }

    @Override
    public String getDescription() {
        String value = M2Label.getLabel(this.classDef.getModel(), "property", this.name, "description");
        if (value == null) {
            value = this.m2Property.getDescription();
        }
        return value;
    }

    @Override
    public String getDefaultValue() {
        return this.m2Property.getDefaultValue();
    }

    @Override
    public DataTypeDefinition getDataType() {
        return this.dataType;
    }

    @Override
    public ClassDefinition getContainerClass() {
        return this.classDef;
    }

    @Override
    public boolean isMultiValued() {
        return this.m2Property.isMultiValued();
    }

    @Override
    public boolean isMandatory() {
        return this.m2Property.isMandatory();
    }

    @Override
    public boolean isMandatoryEnforced() {
        return this.m2Property.isMandatoryEnforced();
    }

    @Override
    public boolean isProtected() {
        return this.m2Property.isProtected();
    }

    @Override
    public boolean isIndexed() {
        return this.m2Property.isIndexed();
    }

    @Override
    public boolean isStoredInIndex() {
        return this.m2Property.isStoredInIndex();
    }

    @Override
    public boolean isIndexedAtomically() {
        return this.m2Property.isIndexedAtomically();
    }

    @Override
    public boolean isTokenisedInIndex() {
        return this.m2Property.isTokenisedInIndex();
    }

    @Override
    public List<ConstraintDefinition> getConstraints() {
        return this.constraintDefs;
    }
}

