/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.service.namespace.NamespaceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceDAOImpl
implements NamespaceDAO {
    private List<String> uris = new ArrayList<String>();
    private HashMap<String, String> prefixes = new HashMap();

    @Override
    public Collection<String> getURIs() {
        return Collections.unmodifiableCollection(this.uris);
    }

    @Override
    public Collection<String> getPrefixes() {
        return Collections.unmodifiableCollection(this.prefixes.keySet());
    }

    @Override
    public void addURI(String uri) {
        if (this.uris.contains(uri)) {
            throw new NamespaceException("URI " + uri + " has already been defined");
        }
        this.uris.add(uri);
    }

    @Override
    public void addPrefix(String prefix, String uri) {
        if (!this.uris.contains(uri)) {
            throw new NamespaceException("Namespace URI " + uri + " does not exist");
        }
        this.prefixes.put(prefix, uri);
    }

    @Override
    public void removeURI(String uri) {
        this.uris.remove(uri);
    }

    @Override
    public void removePrefix(String prefix) {
        this.prefixes.remove(prefix);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.prefixes.get(prefix);
    }

    @Override
    public Collection<String> getPrefixes(String URI2) {
        ArrayList<String> uriPrefixes = new ArrayList<String>();
        for (String key : this.prefixes.keySet()) {
            String uri = this.prefixes.get(key);
            if (uri == null || !uri.equals(URI2)) continue;
            uriPrefixes.add(key);
        }
        return uriPrefixes;
    }
}

