/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.ArrayList;
import org.alfresco.repo.dictionary.DictionaryBootstrap;
import org.alfresco.repo.dictionary.DictionaryDAOImpl;
import org.alfresco.repo.dictionary.NamespaceDAOImpl;

public class TestModel {
    public static void main(String[] args) {
        if (args != null && args.length > 0 && args[0].equals("-h")) {
            System.out.println("TestModel [model filename]*");
            System.exit(0);
        }
        System.out.println("Testing dictionary model definitions...");
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("alfresco/model/dictionaryModel.xml");
        bootstrapModels.add("alfresco/model/systemModel.xml");
        bootstrapModels.add("alfresco/model/contentModel.xml");
        bootstrapModels.add("alfresco/model/applicationModel.xml");
        for (String arg : args) {
            bootstrapModels.add(arg);
        }
        for (String model : bootstrapModels) {
            System.out.println(" " + model);
        }
        NamespaceDAOImpl namespaceDAO = new NamespaceDAOImpl();
        DictionaryDAOImpl dictionaryDAO = new DictionaryDAOImpl(namespaceDAO);
        try {
            DictionaryBootstrap bootstrap = new DictionaryBootstrap();
            bootstrap.setModels(bootstrapModels);
            bootstrap.setDictionaryDAO(dictionaryDAO);
            bootstrap.bootstrap();
            System.out.println("Models are valid.");
        }
        catch (Exception e) {
            System.out.println("Found an invalid model...");
            for (Throwable t = e; t != null; t = t.getCause()) {
                System.out.println(t.getMessage());
            }
        }
    }
}

