/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary.constraint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.i18n.I18NUtil;
import org.alfresco.repo.dictionary.constraint.AbstractConstraint;
import org.alfresco.repo.dictionary.constraint.ListOfValuesConstraint;
import org.alfresco.repo.dictionary.constraint.NumericRangeConstraint;
import org.alfresco.repo.dictionary.constraint.RegexConstraint;
import org.alfresco.repo.dictionary.constraint.StringLengthConstraint;
import org.alfresco.service.cmr.dictionary.Constraint;
import org.alfresco.service.cmr.dictionary.ConstraintException;
import org.alfresco.service.cmr.dictionary.DictionaryException;

public class ConstraintsTest
extends TestCase {
    protected void setUp() throws Exception {
        I18NUtil.registerResourceBundle((String)"alfresco/messages/dictionary-messages");
    }

    public void testCollections() throws Exception {
        DummyConstraint constraint = new DummyConstraint();
        constraint.initialize();
        ArrayList<Object> dummyObjects = new ArrayList<Object>(3);
        dummyObjects.add("ABC");
        dummyObjects.add("DEF");
        dummyObjects.add((Object)this);
        try {
            constraint.evaluate(dummyObjects);
            ConstraintsTest.fail((String)"Failed to detected constraint violation in collection");
        }
        catch (ConstraintException e) {
            this.checkI18NofExceptionMessage((Throwable)((Object)e));
        }
        ConstraintsTest.assertEquals((String)"String values not checked", (int)2, (int)constraint.tested.size());
    }

    public void testNull() throws Exception {
        DummyConstraint constraint = new DummyConstraint();
        constraint.initialize();
        constraint.evaluate(null);
    }

    private void checkI18NofExceptionMessage(Throwable e) {
        String msg = e.getMessage();
        ConstraintsTest.assertFalse((String)"I18N of constraint message failed", (boolean)msg.startsWith("d_dictionary.constraint"));
    }

    private void evaluate(Constraint constraint, Object value, boolean expectFailure) throws Exception {
        try {
            constraint.evaluate(value);
            if (expectFailure) {
                ConstraintsTest.fail((String)("Failure did not occur: \n   constraint: " + constraint + "\n" + "   value: " + value));
            }
        }
        catch (ConstraintException e) {
            if (expectFailure) {
                this.checkI18NofExceptionMessage((Throwable)((Object)e));
            }
            throw e;
        }
    }

    public void testStringLengthConstraint() throws Exception {
        StringLengthConstraint constraint = new StringLengthConstraint();
        try {
            constraint.setMinLength(-1);
        }
        catch (DictionaryException e) {
            this.checkI18NofExceptionMessage((Throwable)((Object)e));
        }
        try {
            constraint.setMaxLength(-1);
        }
        catch (DictionaryException e) {
            this.checkI18NofExceptionMessage((Throwable)((Object)e));
        }
        constraint.setMinLength(3);
        constraint.setMaxLength(6);
        this.evaluate(constraint, "abc", false);
        this.evaluate(constraint, "abcdef", false);
        this.evaluate(constraint, Arrays.asList("abc", "abcdef"), false);
        this.evaluate(constraint, "ab", true);
        this.evaluate(constraint, "abcdefg", true);
        this.evaluate(constraint, Arrays.asList("abc", "abcdefg"), true);
    }

    public void testListOfValuesConstraint() throws Exception {
        ListOfValuesConstraint constraint = new ListOfValuesConstraint();
        try {
            constraint.setAllowedValues(Collections.emptyList());
        }
        catch (DictionaryException e) {
            this.checkI18NofExceptionMessage((Throwable)((Object)e));
        }
        List<String> allowedValues = Arrays.asList("abc", "def", "ghi");
        constraint.setAllowedValues(allowedValues);
        this.evaluate(constraint, "def", false);
        this.evaluate(constraint, "DEF", true);
        this.evaluate(constraint, Arrays.asList("abc", "def"), false);
        this.evaluate(constraint, Arrays.asList("abc", "DEF"), true);
        constraint.setCaseSensitive(false);
        this.evaluate(constraint, "DEF", false);
        this.evaluate(constraint, Arrays.asList("abc", "DEF"), false);
    }

    public void testNumericRangeConstraint() throws Exception {
        NumericRangeConstraint constraint = new NumericRangeConstraint();
        constraint.initialize();
        constraint.evaluate(Double.MIN_VALUE);
        constraint.evaluate(Double.MAX_VALUE);
        this.evaluate(constraint, Double.NaN, true);
        constraint.setMinValue(-5.0);
        constraint.setMaxValue(5.0);
        constraint.initialize();
        this.evaluate(constraint, "-1.0", false);
        this.evaluate(constraint, "+1.0", false);
        this.evaluate(constraint, Arrays.asList(-1, 0, 1), false);
        this.evaluate(constraint, "abc", true);
        this.evaluate(constraint, 564530.0, true);
        this.evaluate(constraint, Arrays.asList(-1, 6), true);
    }

    public void testRegexConstraint() throws Exception {
        RegexConstraint constraint = new RegexConstraint();
        constraint.setExpression("[A-Z]*");
        constraint.setRequiresMatch(true);
        constraint.initialize();
        this.evaluate(constraint, "ABC", false);
        this.evaluate(constraint, "DEF", false);
        this.evaluate(constraint, "abc", true);
        this.evaluate(constraint, (Object)DummyEnum.ABC, false);
        this.evaluate(constraint, (Object)DummyEnum.DEF, false);
        this.evaluate(constraint, (Object)DummyEnum.abc, true);
        constraint.setRequiresMatch(false);
        constraint.initialize();
        this.evaluate(constraint, (Object)DummyEnum.abc, false);
    }

    public void testRegexConstraintFilename() throws Exception {
        String expression = new String(".*[\\\"\\*\\\\\\>\\<\\?\\/\\:\\|\\\u00c2\u00ac\\\u00c2\u00a3\\%\\&\\+\\;]+.*".getBytes("UTF-8"));
        String invalidChars = new String("\"*\\><?/:|%&+;\u00c2\u00ac\u00c2\u00a3".getBytes("UTF-8"));
        RegexConstraint constraint = new RegexConstraint();
        constraint.setExpression(expression);
        constraint.setRequiresMatch(false);
        constraint.initialize();
        for (int i = 0; i < invalidChars.length(); ++i) {
            String invalidStr = invalidChars.substring(i, i + 1);
            this.evaluate(constraint, invalidStr, true);
        }
        this.evaluate(constraint, "Bogus<>.txt", true);
        this.evaluate(constraint, "Company Home", false);
    }

    private class DummyConstraint
    extends AbstractConstraint {
        private List<Object> tested;

        private DummyConstraint() {
        }

        public void initialize() {
            this.tested = new ArrayList<Object>(4);
        }

        protected void evaluateSingleValue(Object value) {
            if (value == null) {
                throw new NullPointerException("Null value in dummy test");
            }
            if (!(value instanceof String)) {
                throw new ConstraintException("Non-String value", new Object[0]);
            }
            this.tested.add(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DummyEnum {
        ABC,
        DEF,
        abc;

    }
}

