/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary.constraint;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.alfresco.repo.dictionary.constraint.AbstractConstraint;
import org.alfresco.service.cmr.dictionary.ConstraintException;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOfValuesConstraint
extends AbstractConstraint {
    private static final String ERR_NO_VALUES = "d_dictionary.constraint.list_of_values.no_values";
    private static final String ERR_NON_STRING = "d_dictionary.constraint.string_length.non_string";
    private static final String ERR_INVALID_VALUE = "d_dictionary.constraint.list_of_values.invalid_value";
    private List<String> allowedValues;
    private List<String> allowedValuesUpper;
    private boolean caseSensitive = true;

    public String toString() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("ListOfValuesConstraint").append("[ allowedValues=").append(this.allowedValues).append(", caseSensitive=").append(this.caseSensitive).append("]");
        return sb.toString();
    }

    public List<String> getAllowedValues() {
        return this.allowedValues;
    }

    public void setAllowedValues(List allowedValues) {
        if (allowedValues == null) {
            throw new DictionaryException(ERR_NO_VALUES);
        }
        int valueCount = allowedValues.size();
        if (valueCount == 0) {
            throw new DictionaryException(ERR_NO_VALUES);
        }
        this.allowedValues = Collections.unmodifiableList(allowedValues);
        this.allowedValuesUpper = new ArrayList<String>(valueCount);
        for (String allowedValue : this.allowedValues) {
            this.allowedValuesUpper.add(allowedValue.toUpperCase());
        }
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    public void initialize() {
        this.checkPropertyNotNull("allowedValues", this.allowedValues);
    }

    @Override
    protected void evaluateSingleValue(Object value) {
        String valueStr = null;
        try {
            valueStr = DefaultTypeConverter.INSTANCE.convert(String.class, value);
        }
        catch (TypeConversionException e) {
            throw new ConstraintException(ERR_NON_STRING, value);
        }
        if (this.caseSensitive ? !this.allowedValues.contains(valueStr) : !this.allowedValuesUpper.contains(valueStr.toUpperCase())) {
            throw new ConstraintException(ERR_INVALID_VALUE, value);
        }
    }
}

