/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary.constraint;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.repo.dictionary.constraint.AbstractConstraint;
import org.alfresco.service.cmr.dictionary.ConstraintException;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;

public class RegexConstraint
extends AbstractConstraint {
    public static final String CONSTRAINT_REGEX_NO_MATCH = "d_dictionary.constraint.regex.no_match";
    public static final String CONSTRAINT_REGEX_MATCH = "d_dictionary.constraint.regex.match";
    private String expression;
    private Pattern patternMatcher;
    private boolean requiresMatch = true;

    public String toString() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("RegexConstraint").append("[ expression=").append(this.expression).append(", requiresMatch=").append(this.requiresMatch).append("]");
        return sb.toString();
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public boolean getRequiresMatch() {
        return this.requiresMatch;
    }

    public void setRequiresMatch(boolean requiresMatch) {
        this.requiresMatch = requiresMatch;
    }

    public void initialize() {
        this.checkPropertyNotNull("expression", this.expression);
        this.patternMatcher = Pattern.compile(this.expression);
    }

    protected void evaluateSingleValue(Object value) {
        String valueStr = DefaultTypeConverter.INSTANCE.convert(String.class, value);
        Matcher matcher = this.patternMatcher.matcher(valueStr);
        boolean matches = matcher.matches();
        if (matches != this.requiresMatch) {
            if (this.requiresMatch) {
                throw new ConstraintException(CONSTRAINT_REGEX_NO_MATCH, value, this.expression);
            }
            throw new ConstraintException(CONSTRAINT_REGEX_MATCH, value, this.expression);
        }
    }
}

