/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain;

import java.io.Serializable;
import org.alfresco.repo.domain.StoreKey;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.util.EqualsHelper;

public class NodeKey
implements Serializable {
    private static final long serialVersionUID = 3258695403221300023L;
    private String guid;
    private String protocol;
    private String identifier;

    public NodeKey() {
    }

    public NodeKey(NodeRef nodeRef) {
        this(nodeRef.getStoreRef(), nodeRef.getId());
    }

    public NodeKey(StoreRef storeRef, String guid) {
        this.setGuid(guid);
        this.setProtocol(storeRef.getProtocol());
        this.setIdentifier(storeRef.getIdentifier());
    }

    public NodeKey(StoreKey storeKey, String guid) {
        this.setGuid(guid);
        this.setProtocol(storeKey.getProtocol());
        this.setIdentifier(storeKey.getIdentifier());
    }

    public NodeKey(String protocol, String identifier, String guid) {
        this.setGuid(guid);
        this.setProtocol(protocol);
        this.setIdentifier(identifier);
    }

    public String toString() {
        return "NodeKey[ id=" + this.guid + ", protocol=" + this.protocol + ", identifier=" + this.identifier + "]";
    }

    public int hashCode() {
        return this.guid.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NodeKey)) {
            return false;
        }
        NodeKey that = (NodeKey)obj;
        return EqualsHelper.nullSafeEquals((Object)this.guid, (Object)that.guid) && EqualsHelper.nullSafeEquals((Object)this.protocol, (Object)that.protocol) && EqualsHelper.nullSafeEquals((Object)this.identifier, (Object)that.identifier);
    }

    public String getGuid() {
        return this.guid;
    }

    private void setGuid(String id) {
        this.guid = id;
    }

    public String getProtocol() {
        return this.protocol;
    }

    private void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    private void setIdentifier(String identifier) {
        this.identifier = identifier;
    }
}

