/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyValue
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -497902497351493075L;
    private static final String STRING_EMPTY = "";
    private static Log logger = LogFactory.getLog(PropertyValue.class);
    private static Log loggerOracle = LogFactory.getLog((String)(PropertyValue.class.getName() + ".oracle"));
    private static Map<QName, ValueType> valueTypesByPropertyType = new HashMap<QName, ValueType>(17);
    private ValueType actualType;
    private boolean isMultiValued;
    private ValueType persistedType;
    private Boolean booleanValue;
    private Long longValue;
    private Float floatValue;
    private Double doubleValue;
    private String stringValue;
    private Serializable serializableValue;

    private static ValueType getActualType(Serializable value) {
        if (value == null) {
            return ValueType.NULL;
        }
        if (value instanceof Boolean) {
            return ValueType.BOOLEAN;
        }
        if (value instanceof Integer || value instanceof Long) {
            return ValueType.LONG;
        }
        if (value instanceof Float) {
            return ValueType.FLOAT;
        }
        if (value instanceof Double) {
            return ValueType.DOUBLE;
        }
        if (value instanceof String) {
            return ValueType.STRING;
        }
        if (value instanceof Date) {
            return ValueType.DATE;
        }
        if (value instanceof ContentData) {
            return ValueType.CONTENT;
        }
        if (value instanceof NodeRef) {
            return ValueType.NODEREF;
        }
        if (value instanceof ChildAssociationRef) {
            return ValueType.CHILD_ASSOC_REF;
        }
        if (value instanceof AssociationRef) {
            return ValueType.ASSOC_REF;
        }
        if (value instanceof QName) {
            return ValueType.QNAME;
        }
        if (value instanceof Path) {
            return ValueType.PATH;
        }
        return ValueType.SERIALIZABLE;
    }

    public PropertyValue() {
    }

    public PropertyValue(QName typeQName, Serializable value) {
        this.actualType = PropertyValue.getActualType(value);
        if (value == null) {
            this.setPersistedValue(ValueType.NULL, null);
            this.setMultiValued(false);
        } else if (value instanceof Collection) {
            Collection collection = (Collection)((Object)value);
            ValueType collectionValueType = this.makeValueType(typeQName);
            ArrayList<Serializable> convertedCollection = collectionValueType.convert(collection);
            this.setPersistedValue(ValueType.SERIALIZABLE, convertedCollection);
            this.setMultiValued(true);
        } else {
            ValueType persistedValueType = this.actualType.getPersistedType(value);
            value = persistedValueType.convert(value);
            this.setPersistedValue(persistedValueType, value);
            this.setMultiValued(false);
        }
    }

    private ValueType makeValueType(QName typeQName) {
        ValueType valueType = valueTypesByPropertyType.get(typeQName);
        if (valueType == null) {
            throw new AlfrescoRuntimeException("Property type not recognised: \n   type: " + typeQName + "\n" + "   property: " + this);
        }
        return valueType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof PropertyValue) {
            PropertyValue that = (PropertyValue)obj;
            return this.actualType.equals((Object)that.actualType) && EqualsHelper.nullSafeEquals((Object)this.booleanValue, (Object)that.booleanValue) && EqualsHelper.nullSafeEquals((Object)this.longValue, (Object)that.longValue) && EqualsHelper.nullSafeEquals((Object)this.floatValue, (Object)that.floatValue) && EqualsHelper.nullSafeEquals((Object)this.doubleValue, (Object)that.doubleValue) && EqualsHelper.nullSafeEquals((Object)this.stringValue, (Object)that.stringValue) && EqualsHelper.nullSafeEquals((Object)this.serializableValue, (Object)that.serializableValue);
        }
        return false;
    }

    public int hashCode() {
        Serializable persistedValue;
        int h = 0;
        if (this.actualType != null) {
            h = this.actualType.hashCode();
        }
        if ((persistedValue = this.getPersistedValue()) != null) {
            h += 17 * persistedValue.hashCode();
        }
        return h;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("PropertyValue").append("[actual-type=").append((Object)this.actualType).append(", multi-valued=").append(this.isMultiValued).append(", value-type=").append((Object)this.persistedType).append(", value=").append(this.getPersistedValue()).append("]");
        return sb.toString();
    }

    public String getActualType() {
        return this.actualType.toString();
    }

    public void setActualType(String actualType) {
        this.actualType = ValueType.valueOf(actualType);
    }

    public boolean isMultiValued() {
        return this.isMultiValued;
    }

    public void setMultiValued(boolean isMultiValued) {
        this.isMultiValued = isMultiValued;
    }

    public String getPersistedType() {
        return this.persistedType.toString();
    }

    public void setPersistedType(String persistedType) {
        this.persistedType = ValueType.valueOf(persistedType);
    }

    public void setPersistedValue(ValueType persistedType, Serializable value) {
        switch (persistedType) {
            case NULL: {
                if (value == null) break;
                throw new AlfrescoRuntimeException("Value must be null for persisted type: " + (Object)((Object)persistedType));
            }
            case BOOLEAN: {
                this.booleanValue = (Boolean)value;
                break;
            }
            case LONG: {
                this.longValue = (Long)value;
                break;
            }
            case FLOAT: {
                this.floatValue = (Float)value;
                break;
            }
            case DOUBLE: {
                this.doubleValue = (Double)value;
                break;
            }
            case STRING: {
                this.stringValue = (String)((Object)value);
                break;
            }
            case SERIALIZABLE: {
                this.serializableValue = value;
                break;
            }
            default: {
                throw new AlfrescoRuntimeException("Unrecognised value type: " + (Object)((Object)persistedType));
            }
        }
        this.persistedType = persistedType;
    }

    private Serializable getPersistedValue() {
        switch (this.persistedType) {
            case NULL: {
                return null;
            }
            case BOOLEAN: {
                return this.booleanValue;
            }
            case LONG: {
                return this.longValue;
            }
            case FLOAT: {
                return this.floatValue;
            }
            case DOUBLE: {
                return this.doubleValue;
            }
            case STRING: {
                if (this.stringValue == null) {
                    if (loggerOracle.isDebugEnabled()) {
                        logger.debug((Object)"string_value is 'null'.  Forcing to empty String");
                    }
                    return STRING_EMPTY;
                }
                return this.stringValue;
            }
            case SERIALIZABLE: {
                return this.serializableValue;
            }
        }
        throw new AlfrescoRuntimeException("Unrecognised value type: " + (Object)((Object)this.persistedType));
    }

    public Serializable getValue(QName typeQName) {
        ValueType requiredType = this.makeValueType(typeQName);
        if (requiredType == ValueType.SERIALIZABLE) {
            requiredType = this.actualType;
        }
        ArrayList<Serializable> ret = null;
        if (this.persistedType == ValueType.NULL) {
            ret = null;
        } else if (this.isMultiValued) {
            ArrayList<Serializable> convertedCollection;
            Collection collection = (Collection)((Object)this.serializableValue);
            ret = convertedCollection = requiredType.convert(collection);
        } else {
            Serializable persistedValue = this.getPersistedValue();
            ret = requiredType.convert(persistedValue);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Fetched value: \n   property value: " + this + "\n" + "   requested type: " + (Object)((Object)requiredType) + "\n" + "   result: " + ret));
        }
        return ret;
    }

    public boolean getBooleanValue() {
        if (this.booleanValue == null) {
            return false;
        }
        return this.booleanValue;
    }

    public void setBooleanValue(boolean value) {
        this.booleanValue = value;
    }

    public long getLongValue() {
        if (this.longValue == null) {
            return 0L;
        }
        return this.longValue;
    }

    public void setLongValue(long value) {
        this.longValue = value;
    }

    public float getFloatValue() {
        if (this.floatValue == null) {
            return 0.0f;
        }
        return this.floatValue.floatValue();
    }

    public void setFloatValue(float value) {
        this.floatValue = Float.valueOf(value);
    }

    public double getDoubleValue() {
        if (this.doubleValue == null) {
            return 0.0;
        }
        return this.doubleValue;
    }

    public void setDoubleValue(double value) {
        this.doubleValue = value;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String value) {
        this.stringValue = value;
    }

    public Serializable getSerializableValue() {
        return this.serializableValue;
    }

    public void setSerializableValue(Serializable value) {
        this.serializableValue = value;
    }

    static {
        valueTypesByPropertyType.put(DataTypeDefinition.ANY, ValueType.SERIALIZABLE);
        valueTypesByPropertyType.put(DataTypeDefinition.BOOLEAN, ValueType.BOOLEAN);
        valueTypesByPropertyType.put(DataTypeDefinition.INT, ValueType.INTEGER);
        valueTypesByPropertyType.put(DataTypeDefinition.LONG, ValueType.LONG);
        valueTypesByPropertyType.put(DataTypeDefinition.DOUBLE, ValueType.DOUBLE);
        valueTypesByPropertyType.put(DataTypeDefinition.FLOAT, ValueType.FLOAT);
        valueTypesByPropertyType.put(DataTypeDefinition.DATE, ValueType.DATE);
        valueTypesByPropertyType.put(DataTypeDefinition.DATETIME, ValueType.DATE);
        valueTypesByPropertyType.put(DataTypeDefinition.CATEGORY, ValueType.NODEREF);
        valueTypesByPropertyType.put(DataTypeDefinition.CONTENT, ValueType.CONTENT);
        valueTypesByPropertyType.put(DataTypeDefinition.TEXT, ValueType.STRING);
        valueTypesByPropertyType.put(DataTypeDefinition.NODE_REF, ValueType.NODEREF);
        valueTypesByPropertyType.put(DataTypeDefinition.CHILD_ASSOC_REF, ValueType.CHILD_ASSOC_REF);
        valueTypesByPropertyType.put(DataTypeDefinition.ASSOC_REF, ValueType.ASSOC_REF);
        valueTypesByPropertyType.put(DataTypeDefinition.PATH, ValueType.PATH);
        valueTypesByPropertyType.put(DataTypeDefinition.QNAME, ValueType.QNAME);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ValueType {
        NULL{

            Serializable convert(Serializable value) {
                return null;
            }
        }
        ,
        BOOLEAN{

            Serializable convert(Serializable value) {
                return DefaultTypeConverter.INSTANCE.convert(Boolean.class, (Object)value);
            }
        }
        ,
        INTEGER{

            protected ValueType getPersistedType(Serializable value) {
                return LONG;
            }

            Serializable convert(Serializable value) {
                return DefaultTypeConverter.INSTANCE.convert(Integer.class, (Object)value);
            }
        }
        ,
        LONG{

            Serializable convert(Serializable value) {
                return DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)value);
            }
        }
        ,
        FLOAT{

            Serializable convert(Serializable value) {
                return DefaultTypeConverter.INSTANCE.convert(Float.class, (Object)value);
            }
        }
        ,
        DOUBLE{

            Serializable convert(Serializable value) {
                return DefaultTypeConverter.INSTANCE.convert(Double.class, (Object)value);
            }
        }
        ,
        STRING{

            protected ValueType getPersistedType(Serializable value) {
                String valueStr;
                if (value instanceof String && (valueStr = (String)((Object)value)).length() > 1024) {
                    return SERIALIZABLE;
                }
                return STRING;
            }

            Serializable convert(Serializable value) {
                return (Serializable)((Object)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value));
            }
        }
        ,
        DATE{

            protected ValueType getPersistedType(Serializable value) {
                return STRING;
            }

            Serializable convert(Serializable value) {
                return DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)value);
            }
        }
        ,
        SERIALIZABLE{

            Serializable convert(Serializable value) {
                return value;
            }
        }
        ,
        CONTENT{

            protected ValueType getPersistedType(Serializable value) {
                return STRING;
            }

            Serializable convert(Serializable value) {
                return DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)value);
            }
        }
        ,
        NODEREF{

            protected ValueType getPersistedType(Serializable value) {
                return STRING;
            }

            Serializable convert(Serializable value) {
                return DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)value);
            }
        }
        ,
        CHILD_ASSOC_REF{

            protected ValueType getPersistedType(Serializable value) {
                return STRING;
            }

            Serializable convert(Serializable value) {
                return DefaultTypeConverter.INSTANCE.convert(ChildAssociationRef.class, (Object)value);
            }
        }
        ,
        ASSOC_REF{

            protected ValueType getPersistedType(Serializable value) {
                return STRING;
            }

            Serializable convert(Serializable value) {
                return DefaultTypeConverter.INSTANCE.convert(AssociationRef.class, (Object)value);
            }
        }
        ,
        QNAME{

            protected ValueType getPersistedType(Serializable value) {
                return STRING;
            }

            Serializable convert(Serializable value) {
                return DefaultTypeConverter.INSTANCE.convert(QName.class, (Object)value);
            }
        }
        ,
        PATH{

            protected ValueType getPersistedType(Serializable value) {
                return SERIALIZABLE;
            }

            Serializable convert(Serializable value) {
                return DefaultTypeConverter.INSTANCE.convert(Path.class, (Object)value);
            }
        };


        protected ValueType getPersistedType(Serializable value) {
            return this;
        }

        abstract Serializable convert(Serializable var1);

        protected ArrayList<Serializable> convert(Collection collection) {
            ArrayList<Serializable> arrayList = new ArrayList<Serializable>(collection.size());
            for (Object object : collection) {
                Serializable newValue = null;
                if (object != null) {
                    if (!(object instanceof Serializable)) {
                        throw new AlfrescoRuntimeException("Collection values must contain Serializable instances: \n   value type: " + (Object)((Object)this) + "\n" + "   collection: " + collection + "\n" + "   value: " + object);
                    }
                    Serializable value = (Serializable)object;
                    newValue = this.convert(value);
                }
                arrayList.add(newValue);
            }
            return arrayList;
        }
    }
}

