/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.hibernate;

import java.io.Serializable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.domain.ChildAssoc;
import org.alfresco.repo.domain.Node;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;

public class ChildAssocImpl
implements ChildAssoc,
Serializable {
    private static final long serialVersionUID = -8993272236626580410L;
    private Long id;
    private Node parent;
    private Node child;
    private QName typeQName;
    private QName qName;
    private boolean isPrimary;
    private int index;
    private transient ReentrantReadWriteLock.ReadLock refReadLock;
    private transient ReentrantReadWriteLock.WriteLock refWriteLock;
    private transient ChildAssociationRef childAssocRef;

    public ChildAssocImpl() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.refReadLock = lock.readLock();
        this.refWriteLock = lock.writeLock();
        this.setIndex(Integer.MAX_VALUE);
    }

    public void buildAssociation(Node parentNode, Node childNode) {
        this.setParent(parentNode);
        this.setChild(childNode);
        parentNode.getChildAssocs().add(this);
        childNode.getParentAssocs().add(this);
    }

    public void removeAssociation() {
        this.getParent().getChildAssocs().remove(this);
        this.getChild().getParentAssocs().remove(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChildAssociationRef getChildAssocRef() {
        boolean trashReference;
        block8: {
            trashReference = false;
            this.refReadLock.lock();
            try {
                if (this.childAssocRef == null) break block8;
                if (this.childAssocRef.getParentRef() != this.parent.getNodeRef() || this.childAssocRef.getChildRef() != this.child.getNodeRef()) {
                    trashReference = true;
                    break block8;
                }
                ChildAssociationRef childAssociationRef = this.childAssocRef;
                return childAssociationRef;
            }
            finally {
                this.refReadLock.unlock();
            }
        }
        this.refWriteLock.lock();
        try {
            if (this.childAssocRef == null || trashReference) {
                this.childAssocRef = new ChildAssociationRef(this.typeQName, this.parent.getNodeRef(), this.qName, this.child.getNodeRef(), this.isPrimary, this.index);
            }
            ChildAssociationRef childAssociationRef = this.childAssocRef;
            return childAssociationRef;
        }
        finally {
            this.refWriteLock.unlock();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(32);
        sb.append("ChildAssoc").append("[ parent=").append(this.parent).append(", child=").append(this.child).append(", name=").append(this.getQname()).append(", isPrimary=").append(this.isPrimary).append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ChildAssoc)) {
            return false;
        }
        ChildAssoc that = (ChildAssoc)obj;
        return EqualsHelper.nullSafeEquals((Object)this.getTypeQName(), (Object)that.getTypeQName()) && EqualsHelper.nullSafeEquals((Object)this.getQname(), (Object)that.getQname()) && EqualsHelper.nullSafeEquals((Object)this.getParent(), (Object)that.getParent()) && EqualsHelper.nullSafeEquals((Object)this.getChild(), (Object)that.getChild());
    }

    public int hashCode() {
        return this.qName == null ? 0 : this.qName.hashCode();
    }

    public int compareTo(ChildAssoc another) {
        if (this == another) {
            return 0;
        }
        int thisIndex = this.getIndex();
        int anotherIndex = another.getIndex();
        Long thisId = this.getId();
        Long anotherId = another.getId();
        if (thisId == null) {
            return -1;
        }
        if (anotherId == null) {
            return 1;
        }
        if (thisIndex == anotherIndex) {
            return thisId.compareTo(anotherId);
        }
        return thisIndex > anotherIndex ? 1 : -1;
    }

    public Long getId() {
        return this.id;
    }

    private void setId(Long id) {
        this.id = id;
    }

    public Node getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setParent(Node parentNode) {
        this.refWriteLock.lock();
        try {
            this.parent = parentNode;
            this.childAssocRef = null;
        }
        finally {
            this.refWriteLock.unlock();
        }
    }

    public Node getChild() {
        return this.child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setChild(Node node) {
        this.refWriteLock.lock();
        try {
            this.child = node;
            this.childAssocRef = null;
        }
        finally {
            this.refWriteLock.unlock();
        }
    }

    public QName getTypeQName() {
        return this.typeQName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTypeQName(QName typeQName) {
        this.refWriteLock.lock();
        try {
            this.typeQName = typeQName;
            this.childAssocRef = null;
        }
        finally {
            this.refWriteLock.unlock();
        }
    }

    public QName getQname() {
        return this.qName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQname(QName qname) {
        this.refWriteLock.lock();
        try {
            this.qName = qname;
            this.childAssocRef = null;
        }
        finally {
            this.refWriteLock.unlock();
        }
    }

    public boolean getIsPrimary() {
        return this.isPrimary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsPrimary(boolean isPrimary) {
        this.refWriteLock.lock();
        try {
            this.isPrimary = isPrimary;
            this.childAssocRef = null;
        }
        finally {
            this.refWriteLock.unlock();
        }
    }

    public int getIndex() {
        return this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndex(int index) {
        this.refWriteLock.lock();
        try {
            this.index = index;
            this.childAssocRef = null;
        }
        finally {
            this.refWriteLock.unlock();
        }
    }
}

