/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.hibernate;

import java.io.Serializable;
import org.alfresco.repo.domain.DbAccessControlEntry;
import org.alfresco.repo.domain.DbAccessControlList;
import org.alfresco.repo.domain.DbAuthority;
import org.alfresco.repo.domain.DbPermission;
import org.alfresco.repo.domain.hibernate.LifecycleAdapter;
import org.alfresco.util.EqualsHelper;

public class DbAccessControlEntryImpl
extends LifecycleAdapter
implements DbAccessControlEntry,
Serializable {
    private static final long serialVersionUID = -418837862334064582L;
    private long id;
    private DbAccessControlList accessControlList;
    private DbPermission permission;
    private DbAuthority authority;
    private boolean allowed;

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("DbAccessControlEntryImpl").append("[ id=").append(this.id).append(", acl=").append(this.accessControlList.getId()).append(", permission=").append(this.permission.getKey()).append(", authority=").append(this.authority.getRecipient()).append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbAccessControlEntry)) {
            return false;
        }
        DbAccessControlEntry other = (DbAccessControlEntry)o;
        return EqualsHelper.nullSafeEquals((Object)this.permission, (Object)other.getPermission()) && EqualsHelper.nullSafeEquals((Object)this.authority, (Object)other.getAuthority());
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.permission != null) {
            hashCode = hashCode * 37 + this.permission.hashCode();
        }
        if (this.authority != null) {
            hashCode = hashCode * 37 + this.authority.hashCode();
        }
        return hashCode;
    }

    public long getId() {
        return this.id;
    }

    void setId(long id) {
        this.id = id;
    }

    public DbAccessControlList getAccessControlList() {
        return this.accessControlList;
    }

    public void setAccessControlList(DbAccessControlList nodePermissionEntry) {
        this.accessControlList = nodePermissionEntry;
    }

    public DbPermission getPermission() {
        return this.permission;
    }

    public void setPermission(DbPermission permissionReference) {
        this.permission = permissionReference;
    }

    public DbAuthority getAuthority() {
        return this.authority;
    }

    public void setAuthority(DbAuthority recipient) {
        this.authority = recipient;
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public void setAllowed(boolean allowed) {
        this.allowed = allowed;
    }

    public void delete() {
        boolean removed = this.getAccessControlList().getEntries().remove(this);
        this.getSession().delete((Object)this);
    }
}

