/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.hibernate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.repo.domain.DbAccessControlEntry;
import org.alfresco.repo.domain.DbAccessControlList;
import org.alfresco.repo.domain.DbAuthority;
import org.alfresco.repo.domain.DbPermission;
import org.alfresco.repo.domain.DbPermissionKey;
import org.alfresco.repo.domain.hibernate.DbAccessControlEntryImpl;
import org.alfresco.repo.domain.hibernate.LifecycleAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbAccessControlListImpl
extends LifecycleAdapter
implements DbAccessControlList,
Serializable {
    private static final long serialVersionUID = 3123277428227075648L;
    private static Log logger = LogFactory.getLog(DbAccessControlListImpl.class);
    private long id;
    private Set<DbAccessControlEntry> entries = new HashSet<DbAccessControlEntry>(5);
    private boolean inherits;

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("DbAccessControlListImpl").append("[ id=").append(this.id).append(", entries=").append(this.entries.size()).append(", inherits=").append(this.inherits).append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbAccessControlList)) {
            return false;
        }
        DbAccessControlList other = (DbAccessControlList)o;
        return this.inherits == other.getInherits();
    }

    public int hashCode() {
        return !this.inherits ? 0 : 17;
    }

    @Override
    public long getId() {
        return this.id;
    }

    private void setId(long id) {
        this.id = id;
    }

    @Override
    public Set<DbAccessControlEntry> getEntries() {
        return this.entries;
    }

    private void setEntries(Set<DbAccessControlEntry> entries) {
        this.entries = entries;
    }

    @Override
    public boolean getInherits() {
        return this.inherits;
    }

    @Override
    public void setInherits(boolean inherits) {
        this.inherits = inherits;
    }

    @Override
    public int deleteEntriesForAuthority(String authority) {
        return this.deleteEntry(authority, null);
    }

    @Override
    public int deleteEntriesForPermission(DbPermissionKey permissionKey) {
        return this.deleteEntry(null, permissionKey);
    }

    @Override
    public int deleteEntry(String authority, DbPermissionKey permissionKey) {
        ArrayList<DbAccessControlEntry> toDelete = new ArrayList<DbAccessControlEntry>(2);
        for (DbAccessControlEntry entry : this.entries) {
            if (authority != null && !authority.equals(entry.getAuthority().getRecipient()) || permissionKey != null && !permissionKey.equals(entry.getPermission().getKey())) continue;
            toDelete.add(entry);
        }
        for (DbAccessControlEntry entry : toDelete) {
            entry.delete();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deleted " + toDelete.size() + " access entries: \n" + "   access control list: " + this.id + "\n" + "   authority: " + authority + "\n" + "   permission: " + permissionKey));
        }
        return toDelete.size();
    }

    @Override
    public int deleteEntries() {
        Session session = this.getSession();
        ArrayList<DbAccessControlEntry> toDelete = new ArrayList<DbAccessControlEntry>(this.entries);
        for (DbAccessControlEntry entry : toDelete) {
            session.delete((Object)entry);
        }
        int count = this.entries.size();
        this.entries.clear();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deleted " + count + " access entries for access control list " + this.id));
        }
        return count;
    }

    @Override
    public DbAccessControlEntry getEntry(String authority, DbPermissionKey permissionKey) {
        for (DbAccessControlEntry entry : this.entries) {
            DbAuthority authorityEntity = entry.getAuthority();
            DbPermission permissionEntity = entry.getPermission();
            if (!authorityEntity.getRecipient().equals(authority) || !permissionEntity.getKey().equals(permissionKey)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public DbAccessControlEntryImpl newEntry(DbPermission permission, DbAuthority authority, boolean allowed) {
        DbAccessControlEntryImpl accessControlEntry = new DbAccessControlEntryImpl();
        accessControlEntry.setAccessControlList(this);
        accessControlEntry.setPermission(permission);
        accessControlEntry.setAuthority(authority);
        accessControlEntry.setAllowed(allowed);
        this.getSession().save((Object)accessControlEntry);
        this.getEntries().add(accessControlEntry);
        return accessControlEntry;
    }
}

