/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.hibernate;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.repo.domain.DbAuthority;
import org.alfresco.repo.domain.hibernate.HibernateHelper;
import org.alfresco.repo.domain.hibernate.LifecycleAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.CallbackException;
import org.hibernate.Query;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbAuthorityImpl
extends LifecycleAdapter
implements DbAuthority,
Serializable {
    private static final long serialVersionUID = -5582068692208928127L;
    private static Log logger = LogFactory.getLog(DbAuthorityImpl.class);
    private String recipient;
    private Set<String> externalKeys = new HashSet<String>();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbAuthority)) {
            return false;
        }
        DbAuthority other = (DbAuthority)o;
        return this.getRecipient().equals(other.getRecipient());
    }

    public int hashCode() {
        return this.getRecipient().hashCode();
    }

    @Override
    public int deleteEntries() {
        Query query = this.getSession().getNamedQuery("permission.GetAccessControlEntriesForAuthority").setString("authorityRecipient", this.recipient);
        int count = HibernateHelper.deleteDbAccessControlEntries(this.getSession(), query);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deleted " + count + " access entries for access control list " + this.recipient));
        }
        return count;
    }

    @Override
    public boolean onDelete(Session session) throws CallbackException {
        this.deleteEntries();
        return super.onDelete(session);
    }

    @Override
    public String getRecipient() {
        return this.recipient;
    }

    @Override
    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    @Override
    public Set<String> getExternalKeys() {
        return this.externalKeys;
    }

    void setExternalKeys(Set<String> externalKeys) {
        this.externalKeys = externalKeys;
    }

    public static DbAuthority find(Session session, String authority) {
        return (DbAuthority)session.get(DbAuthorityImpl.class, (Serializable)((Object)authority));
    }
}

