/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.hibernate;

import java.io.Serializable;
import org.alfresco.repo.domain.DbPermission;
import org.alfresco.repo.domain.DbPermissionKey;
import org.alfresco.repo.domain.hibernate.HibernateHelper;
import org.alfresco.repo.domain.hibernate.LifecycleAdapter;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.CallbackException;
import org.hibernate.Query;
import org.hibernate.Session;

public class DbPermissionImpl
extends LifecycleAdapter
implements DbPermission,
Serializable {
    private static final long serialVersionUID = -6352566900815035461L;
    private static Log logger = LogFactory.getLog(DbPermissionImpl.class);
    private long id;
    private QName typeQname;
    private String name;

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("PermissionImpl").append("[ id=").append(this.id).append(", typeQname=").append(this.typeQname).append(", name=").append(this.getName()).append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbPermission)) {
            return false;
        }
        DbPermission other = (DbPermission)o;
        return EqualsHelper.nullSafeEquals((Object)this.typeQname, (Object)other.getTypeQname()) && EqualsHelper.nullSafeEquals((Object)this.name, (Object)other.getName());
    }

    public int hashCode() {
        return this.typeQname.hashCode() + 37 * this.name.hashCode();
    }

    public int deleteEntries() {
        Query query = this.getSession().getNamedQuery("permission.GetAccessControlEntriesForPermission").setSerializable("permissionId", (Serializable)Long.valueOf(this.id));
        int count = HibernateHelper.deleteDbAccessControlEntries(this.getSession(), query);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deleted " + count + " access entries for permission " + this.id));
        }
        return count;
    }

    public boolean onDelete(Session session) throws CallbackException {
        this.deleteEntries();
        return super.onDelete(session);
    }

    public long getId() {
        return this.id;
    }

    private void setId(long id) {
        this.id = id;
    }

    public QName getTypeQname() {
        return this.typeQname;
    }

    public void setTypeQname(QName typeQname) {
        this.typeQname = typeQname;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DbPermissionKey getKey() {
        return new DbPermissionKey(this.typeQname, this.name);
    }

    public static DbPermission find(Session session, QName qname, String name) {
        Query query = session.getNamedQuery("permission.GetPermission").setString("permissionTypeQName", qname.toString()).setString("permissionName", name);
        return (DbPermission)query.uniqueResult();
    }
}

