/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.hibernate;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.ChildAssoc;
import org.alfresco.repo.domain.DbAccessControlList;
import org.alfresco.repo.domain.Node;
import org.alfresco.repo.domain.NodeKey;
import org.alfresco.repo.domain.NodeStatus;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.domain.Store;
import org.alfresco.repo.domain.StoreKey;
import org.alfresco.repo.domain.hibernate.ChildAssocImpl;
import org.alfresco.repo.domain.hibernate.NodeAssocImpl;
import org.alfresco.repo.domain.hibernate.NodeImpl;
import org.alfresco.repo.domain.hibernate.NodeStatusImpl;
import org.alfresco.repo.domain.hibernate.StoreImpl;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.hibernate.CacheMode;
import org.hibernate.exception.ConstraintViolationException;

public class HibernateNodeTest
extends BaseSpringTest {
    private static final String TEST_NAMESPACE = "http://www.alfresco.org/test/HibernateNodeTest";
    private Store store;

    protected void onSetUpInTransaction() throws Exception {
        this.store = new StoreImpl();
        StoreKey storeKey = new StoreKey("workspace", "TestWorkspace@" + System.currentTimeMillis() + " - " + System.nanoTime());
        this.store.setKey(storeKey);
        this.getSession().save((Object)this.store);
    }

    protected void onTearDownInTransaction() {
        this.getSession().flush();
        this.getSession().clear();
    }

    public void testSetUp() throws Exception {
        HibernateNodeTest.assertNotNull((String)"Workspace not initialised", (Object)this.store);
    }

    public void testGetStore() throws Exception {
        Node node = new NodeImpl();
        node.setStore(this.store);
        node.setUuid(GUID.generate());
        node.setTypeQName(ContentModel.TYPE_CONTAINER);
        Serializable id = this.getSession().save((Object)node);
        node = (Node)this.getSession().load(NodeImpl.class, id);
        HibernateNodeTest.assertNotNull((String)"Node not found", (Object)node);
        Store loadedStore = node.getStore();
        HibernateNodeTest.assertNotNull((String)"Store not present on node", (Object)loadedStore);
        HibernateNodeTest.assertEquals((String)"Incorrect store key", (Object)this.store, (Object)loadedStore);
    }

    public void testNodeStatus() {
        NodeKey key = new NodeKey(this.store.getKey(), "AAA");
        NodeStatus nodeStatus = new NodeStatusImpl();
        nodeStatus.setKey(key);
        nodeStatus.setChangeTxnId("txn:123");
        this.getSession().save((Object)nodeStatus);
        Node node = new NodeImpl();
        node.setStore(this.store);
        node.setUuid(GUID.generate());
        node.setTypeQName(ContentModel.TYPE_CONTAINER);
        Serializable nodeId = this.getSession().save((Object)node);
        this.flushAndClear();
        nodeStatus = (NodeStatus)this.getSession().get(NodeStatusImpl.class, (Serializable)key);
        nodeStatus.setNode(node);
        this.flushAndClear();
        nodeStatus = (NodeStatus)this.getSession().get(NodeStatusImpl.class, (Serializable)key);
        node = nodeStatus.getNode();
        HibernateNodeTest.assertNotNull((String)"Node was not attached to status", (Object)node);
        nodeStatus.setChangeTxnId("txn:456");
        this.getSession().delete((Object)node);
        try {
            this.flushAndClear();
            HibernateNodeTest.fail((String)"Node status may not refer to non-existent node");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
    }

    public void testProperties() throws Exception {
        Node node = new NodeImpl();
        node.setStore(this.store);
        node.setUuid(GUID.generate());
        node.setTypeQName(ContentModel.TYPE_CONTAINER);
        Map<QName, PropertyValue> propertyMap = new HashMap<QName, PropertyValue>(5);
        QName propertyQName = QName.createQName("{}A");
        PropertyValue propertyValue = new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)"AAA"));
        propertyMap.put(propertyQName, propertyValue);
        node.getProperties().putAll(propertyMap);
        Serializable id = this.getSession().save((Object)node);
        node = (Node)this.getSession().load(NodeImpl.class, id);
        HibernateNodeTest.assertNotNull((String)"Node not found", (Object)node);
        propertyMap = node.getProperties();
        HibernateNodeTest.assertNotNull((String)"Map not persisted", propertyMap);
        HibernateNodeTest.assertNotNull((String)"Property value not present in map", (Object)QName.createQName("{}A"));
    }

    public void testAspects() throws Exception {
        Node node = new NodeImpl();
        node.setStore(this.store);
        node.setUuid(GUID.generate());
        node.setTypeQName(ContentModel.TYPE_CMOBJECT);
        QName aspect1 = QName.createQName(TEST_NAMESPACE, "1");
        QName aspect2 = QName.createQName(TEST_NAMESPACE, "2");
        QName aspect3 = QName.createQName(TEST_NAMESPACE, "3");
        QName aspect4 = QName.createQName(TEST_NAMESPACE, "4");
        Set<QName> aspects = node.getAspects();
        aspects.add(aspect1);
        aspects.add(aspect2);
        aspects.add(aspect3);
        aspects.add(aspect4);
        HibernateNodeTest.assertFalse((String)"Set did not eliminate duplicate aspect qname", (boolean)aspects.add(aspect4));
        Serializable id = this.getSession().save((Object)node);
        this.flushAndClear();
        node = (Node)this.getSession().get(NodeImpl.class, id);
        HibernateNodeTest.assertNotNull((String)"Node not persisted", (Object)node);
        aspects = node.getAspects();
        HibernateNodeTest.assertEquals((String)"Not all aspects persisted", (int)4, (int)aspects.size());
    }

    public void testNodeAssoc() throws Exception {
        Node sourceNode = new NodeImpl();
        sourceNode.setStore(this.store);
        sourceNode.setUuid(GUID.generate());
        sourceNode.setTypeQName(ContentModel.TYPE_CMOBJECT);
        Serializable realNodeId = this.getSession().save((Object)sourceNode);
        Node targetNode = new NodeImpl();
        targetNode.setStore(this.store);
        targetNode.setStore(this.store);
        targetNode.setUuid(GUID.generate());
        targetNode.setTypeQName(ContentModel.TYPE_CONTAINER);
        Serializable containerNodeId = this.getSession().save((Object)targetNode);
        NodeAssocImpl assoc = new NodeAssocImpl();
        assoc.setTypeQName(QName.createQName("next"));
        assoc.buildAssociation(sourceNode, targetNode);
        this.getSession().save((Object)assoc);
        assoc = new NodeAssocImpl();
        assoc.setTypeQName(QName.createQName("helper"));
        assoc.buildAssociation(sourceNode, targetNode);
        this.getSession().save((Object)assoc);
        this.getSession().flush();
        this.getSession().clear();
        sourceNode = (Node)this.getSession().get(NodeImpl.class, realNodeId);
        HibernateNodeTest.assertNotNull((String)"Source node not found", (Object)sourceNode);
        HibernateNodeTest.assertEquals((String)"Expected exactly 2 target assocs", (int)2, (int)sourceNode.getTargetNodeAssocs().size());
        targetNode = (Node)this.getSession().get(NodeImpl.class, containerNodeId);
        HibernateNodeTest.assertNotNull((String)"Target node not found", (Object)targetNode);
        HibernateNodeTest.assertEquals((String)"Expected exactly 2 source assocs", (int)2, (int)targetNode.getSourceNodeAssocs().size());
    }

    public void testChildAssoc() throws Exception {
        NodeImpl contentNode = new NodeImpl();
        contentNode.setStore(this.store);
        contentNode.setUuid(GUID.generate());
        contentNode.setTypeQName(ContentModel.TYPE_CONTENT);
        Serializable contentNodeId = this.getSession().save((Object)contentNode);
        Node containerNode = new NodeImpl();
        containerNode.setStore(this.store);
        containerNode.setUuid(GUID.generate());
        containerNode.setTypeQName(ContentModel.TYPE_CONTAINER);
        Serializable containerNodeId = this.getSession().save((Object)containerNode);
        ChildAssocImpl assoc1 = new ChildAssocImpl();
        assoc1.setIsPrimary(true);
        assoc1.setTypeQName(QName.createQName(null, "type1"));
        assoc1.setQname(QName.createQName(null, "number1"));
        assoc1.buildAssociation(containerNode, contentNode);
        this.getSession().save((Object)assoc1);
        ChildAssocImpl assoc2 = new ChildAssocImpl();
        assoc2.setIsPrimary(true);
        assoc2.setTypeQName(QName.createQName(null, "type1"));
        assoc2.setQname(QName.createQName(null, "number2"));
        assoc2.buildAssociation(containerNode, contentNode);
        this.getSession().save((Object)assoc2);
        HibernateNodeTest.assertFalse((String)"Hashcode incorrent", (((Object)assoc2).hashCode() == 0 ? 1 : 0) != 0);
        HibernateNodeTest.assertNotSame((String)"Assoc equals failure", (Object)assoc1, (Object)assoc2);
        containerNode = (Node)this.getSession().get(NodeImpl.class, containerNodeId);
        HibernateNodeTest.assertNotNull((String)"Node not found", (Object)containerNode);
        HibernateNodeTest.assertEquals((String)"Expected exactly 2 children", (int)2, (int)containerNode.getChildAssocs().size());
        for (ChildAssoc assoc : containerNode.getChildAssocs()) {
            HibernateNodeTest.assertNotNull((String)"Node not populated on assoc", (Object)assoc.getChild());
            HibernateNodeTest.assertEquals((String)"Node key on child assoc is incorrect", (Object)contentNodeId, (Object)assoc.getChild().getId());
        }
        Collection<ChildAssoc> parentAssocs = contentNode.getParentAssocs();
        HibernateNodeTest.assertEquals((String)"Expected exactly 2 parent assocs", (int)2, (int)parentAssocs.size());
        parentAssocs = new HashSet<ChildAssoc>(parentAssocs);
        for (ChildAssoc assoc : parentAssocs) {
            assoc.removeAssociation();
            this.getSession().delete((Object)assoc);
        }
        parentAssocs = contentNode.getParentAssocs();
        HibernateNodeTest.assertEquals((String)"Expected exactly 0 parent assocs", (int)0, (int)parentAssocs.size());
    }

    public void testCaching() throws Exception {
        NodeImpl node = new NodeImpl();
        node.setStore(this.store);
        node.setUuid(GUID.generate());
        node.setTypeQName(ContentModel.TYPE_CONTENT);
        Serializable nodeId = this.getSession().save((Object)node);
        Set<QName> aspects = node.getAspects();
        aspects.add(ContentModel.ASPECT_AUDITABLE);
        Map<QName, PropertyValue> properties = node.getProperties();
        properties.put(ContentModel.PROP_NAME, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)"ABC")));
        Node checkNode = (Node)this.getSession().get(NodeImpl.class, nodeId);
        HibernateNodeTest.assertNotNull((Object)checkNode);
        HibernateNodeTest.assertTrue((String)"Node retrieved was not same instance", (checkNode == node ? 1 : 0) != 0);
        Set<QName> checkAspects = checkNode.getAspects();
        HibernateNodeTest.assertTrue((String)"Aspect set retrieved was not the same instance", (checkAspects == aspects ? 1 : 0) != 0);
        HibernateNodeTest.assertEquals((String)"Incorrect number of aspects", (int)1, (int)checkAspects.size());
        QName checkQName = (QName)checkAspects.toArray()[0];
        HibernateNodeTest.assertTrue((String)"QName retrieved was not the same instance", (checkQName == ContentModel.ASPECT_AUDITABLE ? 1 : 0) != 0);
        Map<QName, PropertyValue> checkProperties = checkNode.getProperties();
        HibernateNodeTest.assertTrue((String)"Propery map retrieved was not the same instance", (checkProperties == properties ? 1 : 0) != 0);
        HibernateNodeTest.assertTrue((String)"Property not found", (boolean)checkProperties.containsKey(ContentModel.PROP_NAME));
        this.flushAndClear();
        this.setComplete();
        this.endTransaction();
        TransactionService transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        UserTransaction txn = transactionService.getUserTransaction();
        try {
            txn.begin();
            checkNode = (Node)this.getSession().get(NodeImpl.class, nodeId);
            HibernateNodeTest.assertNotNull((Object)checkNode);
            checkAspects = checkNode.getAspects();
            txn.commit();
        }
        catch (Throwable e) {
            txn.rollback();
        }
    }

    public void testQueryJoins() throws Exception {
        Node childNode;
        this.getSession().setCacheMode(CacheMode.IGNORE);
        Node containerNode = new NodeImpl();
        containerNode.setStore(this.store);
        containerNode.setUuid(GUID.generate());
        containerNode.setTypeQName(ContentModel.TYPE_CONTAINER);
        containerNode.getProperties().put(ContentModel.PROP_AUTHOR, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)"ABC")));
        containerNode.getProperties().put(ContentModel.PROP_ARCHIVED_BY, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)"ABC")));
        containerNode.getAspects().add(ContentModel.ASPECT_AUDITABLE);
        Serializable containerNodeId = this.getSession().save((Object)containerNode);
        NodeKey containerNodeKey = new NodeKey(containerNode.getNodeRef());
        NodeStatus containerNodeStatus = new NodeStatusImpl();
        containerNodeStatus.setKey(containerNodeKey);
        containerNodeStatus.setNode(containerNode);
        containerNodeStatus.setChangeTxnId(AlfrescoTransactionSupport.getTransactionId());
        this.getSession().save((Object)containerNodeStatus);
        NodeImpl contentNode1 = new NodeImpl();
        contentNode1.setStore(this.store);
        contentNode1.setUuid(GUID.generate());
        contentNode1.setTypeQName(ContentModel.TYPE_CONTENT);
        contentNode1.getProperties().put(ContentModel.PROP_AUTHOR, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)"ABC")));
        contentNode1.getProperties().put(ContentModel.PROP_ARCHIVED_BY, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)"ABC")));
        contentNode1.getAspects().add(ContentModel.ASPECT_AUDITABLE);
        Serializable contentNode1Id = this.getSession().save((Object)contentNode1);
        NodeKey contentNodeKey1 = new NodeKey(contentNode1.getNodeRef());
        NodeStatusImpl contentNodeStatus1 = new NodeStatusImpl();
        contentNodeStatus1.setKey(contentNodeKey1);
        contentNodeStatus1.setNode(contentNode1);
        contentNodeStatus1.setChangeTxnId(AlfrescoTransactionSupport.getTransactionId());
        this.getSession().save((Object)contentNodeStatus1);
        Node contentNode2 = new NodeImpl();
        contentNode2.setStore(this.store);
        contentNode2.setUuid(GUID.generate());
        contentNode2.setTypeQName(ContentModel.TYPE_CONTENT);
        Serializable contentNode2Id = this.getSession().save((Object)contentNode2);
        contentNode2.getProperties().put(ContentModel.PROP_AUTHOR, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)"ABC")));
        contentNode2.getProperties().put(ContentModel.PROP_ARCHIVED_BY, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)"ABC")));
        contentNode2.getAspects().add(ContentModel.ASPECT_AUDITABLE);
        NodeKey contentNodeKey2 = new NodeKey(contentNode2.getNodeRef());
        NodeStatus contentNodeStatus2 = new NodeStatusImpl();
        contentNodeStatus2.setKey(contentNodeKey2);
        contentNodeStatus2.setNode(contentNode2);
        contentNodeStatus2.setChangeTxnId(AlfrescoTransactionSupport.getTransactionId());
        this.getSession().save((Object)contentNodeStatus2);
        ChildAssocImpl assoc1 = new ChildAssocImpl();
        assoc1.setIsPrimary(true);
        assoc1.setTypeQName(QName.createQName(null, "type1"));
        assoc1.setQname(QName.createQName(null, "number1"));
        assoc1.buildAssociation(containerNode, contentNode1);
        this.getSession().save((Object)assoc1);
        ChildAssocImpl assoc2 = new ChildAssocImpl();
        assoc2.setIsPrimary(true);
        assoc2.setTypeQName(QName.createQName(null, "type2"));
        assoc2.setQname(QName.createQName(null, "number2"));
        assoc2.buildAssociation(containerNode, contentNode2);
        this.getSession().save((Object)assoc2);
        this.getSession().flush();
        this.getSession().clear();
        containerNodeStatus = (NodeStatus)this.getSession().get(NodeStatusImpl.class, (Serializable)containerNodeKey);
        containerNode = containerNodeStatus.getNode();
        Collection<ChildAssoc> assocs = containerNode.getChildAssocs();
        for (ChildAssoc assoc : assocs) {
            childNode = assoc.getChild();
            Store store = childNode.getStore();
            childNode.getAspects().size();
            childNode.getProperties().size();
            childNode.getParentAssocs().size();
            childNode.getChildAssocs().size();
            childNode.getSourceNodeAssocs().size();
            childNode.getTargetNodeAssocs().size();
            DbAccessControlList acl = childNode.getAccessControlList();
            if (acl == null) continue;
            acl.getEntries().size();
        }
        this.getSession().clear();
        containerNodeStatus = (NodeStatus)this.getSession().get(NodeStatusImpl.class, (Serializable)containerNodeKey);
        containerNode = containerNodeStatus.getNode();
        assocs = containerNode.getChildAssocs();
        for (ChildAssoc assoc : assocs) {
            childNode = assoc.getChild();
            PropertyValue removed = childNode.getProperties().remove(ContentModel.PROP_ARCHIVED_BY);
            HibernateNodeTest.assertNotNull((String)"Property was not present", (Object)removed);
        }
        this.getSession().flush();
        this.getSession().clear();
        containerNodeStatus = (NodeStatus)this.getSession().get(NodeStatusImpl.class, (Serializable)containerNodeKey);
        containerNode = containerNodeStatus.getNode();
        contentNodeStatus2 = (NodeStatus)this.getSession().get(NodeStatusImpl.class, (Serializable)contentNodeKey2);
        contentNode2 = contentNodeStatus2.getNode();
        ChildAssocImpl assoc3 = new ChildAssocImpl();
        assoc3.setIsPrimary(false);
        assoc3.setTypeQName(QName.createQName(null, "type3"));
        assoc3.setQname(QName.createQName(null, "number3"));
        assoc3.buildAssociation(containerNode, contentNode2);
        this.getSession().save((Object)assoc3);
        this.getSession().flush();
        this.getSession().clear();
    }
}

