/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.hibernate;

import java.io.Serializable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.domain.Node;
import org.alfresco.repo.domain.NodeAssoc;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;

public class NodeAssocImpl
implements NodeAssoc,
Serializable {
    private static final long serialVersionUID = 864534636913524867L;
    private long id;
    private Node source;
    private Node target;
    private QName typeQName;
    private transient ReentrantReadWriteLock.ReadLock refReadLock;
    private transient ReentrantReadWriteLock.WriteLock refWriteLock;
    private transient AssociationRef nodeAssocRef;

    public NodeAssocImpl() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.refReadLock = lock.readLock();
        this.refWriteLock = lock.writeLock();
    }

    public void buildAssociation(Node sourceNode, Node targetNode) {
        this.setTarget(targetNode);
        this.setSource(sourceNode);
        sourceNode.getTargetNodeAssocs().add(this);
        targetNode.getSourceNodeAssocs().add(this);
    }

    public void removeAssociation() {
        this.getSource().getTargetNodeAssocs().remove(this);
        this.getTarget().getSourceNodeAssocs().remove(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssociationRef getNodeAssocRef() {
        boolean trashReference;
        block8: {
            trashReference = false;
            this.refReadLock.lock();
            try {
                if (this.nodeAssocRef == null) break block8;
                if (this.nodeAssocRef.getSourceRef() != this.source.getNodeRef() || this.nodeAssocRef.getTargetRef() != this.target.getNodeRef()) {
                    trashReference = true;
                    break block8;
                }
                AssociationRef associationRef = this.nodeAssocRef;
                return associationRef;
            }
            finally {
                this.refReadLock.unlock();
            }
        }
        this.refWriteLock.lock();
        try {
            if (this.nodeAssocRef == null || trashReference) {
                this.nodeAssocRef = new AssociationRef(this.getSource().getNodeRef(), this.typeQName, this.getTarget().getNodeRef());
            }
            AssociationRef associationRef = this.nodeAssocRef;
            return associationRef;
        }
        finally {
            this.refWriteLock.unlock();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(32);
        sb.append("NodeAssoc").append("[ source=").append(this.source).append(", target=").append(this.target).append(", name=").append(this.getTypeQName()).append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NodeAssoc)) {
            return false;
        }
        NodeAssoc that = (NodeAssoc)obj;
        return EqualsHelper.nullSafeEquals((Object)this.getTypeQName(), (Object)that.getTypeQName()) && EqualsHelper.nullSafeEquals((Object)this.getTarget(), (Object)that.getTarget()) && EqualsHelper.nullSafeEquals((Object)this.getSource(), (Object)that.getSource());
    }

    public int hashCode() {
        return this.typeQName == null ? 0 : this.typeQName.hashCode();
    }

    public long getId() {
        return this.id;
    }

    private void setId(long id) {
        this.id = id;
    }

    public Node getSource() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSource(Node source) {
        this.refWriteLock.lock();
        try {
            this.source = source;
            this.nodeAssocRef = null;
        }
        finally {
            this.refWriteLock.unlock();
        }
    }

    public Node getTarget() {
        return this.target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTarget(Node target) {
        this.refWriteLock.lock();
        try {
            this.target = target;
            this.nodeAssocRef = null;
        }
        finally {
            this.refWriteLock.unlock();
        }
    }

    public QName getTypeQName() {
        return this.typeQName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTypeQName(QName typeQName) {
        this.refWriteLock.lock();
        try {
            this.typeQName = typeQName;
            this.nodeAssocRef = null;
        }
        finally {
            this.refWriteLock.unlock();
        }
    }
}

