/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.hibernate;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.domain.ChildAssoc;
import org.alfresco.repo.domain.DbAccessControlList;
import org.alfresco.repo.domain.Node;
import org.alfresco.repo.domain.NodeAssoc;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.domain.Store;
import org.alfresco.repo.domain.hibernate.LifecycleAdapter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeImpl
extends LifecycleAdapter
implements Node,
Serializable {
    private static final long serialVersionUID = -2101330674810283053L;
    private Long id;
    private Store store;
    private String uuid;
    private QName typeQName;
    private Set<QName> aspects = new HashSet<QName>(5);
    private Collection<NodeAssoc> sourceNodeAssocs = new HashSet<NodeAssoc>(5);
    private Collection<NodeAssoc> targetNodeAssocs = new HashSet<NodeAssoc>(5);
    private Collection<ChildAssoc> parentAssocs = new HashSet<ChildAssoc>(5);
    private Collection<ChildAssoc> childAssocs = new HashSet<ChildAssoc>(11);
    private Map<QName, PropertyValue> properties = new HashMap<QName, PropertyValue>(5);
    private DbAccessControlList accessControlList;
    private transient ReentrantReadWriteLock.ReadLock refReadLock;
    private transient ReentrantReadWriteLock.WriteLock refWriteLock;
    private transient NodeRef nodeRef;

    public NodeImpl() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.refReadLock = lock.readLock();
        this.refWriteLock = lock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeRef getNodeRef() {
        this.refReadLock.lock();
        try {
            if (this.nodeRef != null) {
                NodeRef nodeRef = this.nodeRef;
                return nodeRef;
            }
        }
        finally {
            this.refReadLock.unlock();
        }
        this.refWriteLock.lock();
        try {
            if (this.nodeRef == null) {
                this.nodeRef = new NodeRef(this.getStore().getStoreRef(), this.getUuid());
            }
            NodeRef nodeRef = this.nodeRef;
            return nodeRef;
        }
        finally {
            this.refWriteLock.unlock();
        }
    }

    public String toString() {
        return this.getNodeRef().toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node that = (Node)obj;
        return EqualsHelper.nullSafeEquals((Object)this.getStore(), (Object)that.getStore()) && EqualsHelper.nullSafeEquals((Object)this.getUuid(), (Object)that.getUuid());
    }

    public int hashCode() {
        return this.getUuid().hashCode();
    }

    @Override
    public Long getId() {
        return this.id;
    }

    private void setId(Long id) {
        this.id = id;
    }

    @Override
    public Store getStore() {
        return this.store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStore(Store store) {
        this.refWriteLock.lock();
        try {
            this.store = store;
            this.nodeRef = null;
        }
        finally {
            this.refWriteLock.unlock();
        }
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUuid(String uuid) {
        this.refWriteLock.lock();
        try {
            this.uuid = uuid;
            this.nodeRef = null;
        }
        finally {
            this.refWriteLock.unlock();
        }
    }

    @Override
    public QName getTypeQName() {
        return this.typeQName;
    }

    @Override
    public void setTypeQName(QName typeQName) {
        this.typeQName = typeQName;
    }

    @Override
    public Set<QName> getAspects() {
        return this.aspects;
    }

    private void setAspects(Set<QName> aspects) {
        this.aspects = aspects;
    }

    @Override
    public Collection<NodeAssoc> getSourceNodeAssocs() {
        return this.sourceNodeAssocs;
    }

    private void setSourceNodeAssocs(Collection<NodeAssoc> sourceNodeAssocs) {
        this.sourceNodeAssocs = sourceNodeAssocs;
    }

    @Override
    public Collection<NodeAssoc> getTargetNodeAssocs() {
        return this.targetNodeAssocs;
    }

    private void setTargetNodeAssocs(Collection<NodeAssoc> targetNodeAssocs) {
        this.targetNodeAssocs = targetNodeAssocs;
    }

    @Override
    public Collection<ChildAssoc> getParentAssocs() {
        return this.parentAssocs;
    }

    private void setParentAssocs(Collection<ChildAssoc> parentAssocs) {
        this.parentAssocs = parentAssocs;
    }

    @Override
    public Collection<ChildAssoc> getChildAssocs() {
        return this.childAssocs;
    }

    private void setChildAssocs(Collection<ChildAssoc> childAssocs) {
        this.childAssocs = childAssocs;
    }

    @Override
    public Map<QName, PropertyValue> getProperties() {
        return this.properties;
    }

    private void setProperties(Map<QName, PropertyValue> properties) {
        this.properties = properties;
    }

    @Override
    public DbAccessControlList getAccessControlList() {
        return this.accessControlList;
    }

    @Override
    public void setAccessControlList(DbAccessControlList accessControlList) {
        this.accessControlList = accessControlList;
    }
}

