/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.hibernate;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.repo.domain.DbAccessControlEntry;
import org.alfresco.repo.domain.DbAccessControlList;
import org.alfresco.repo.domain.DbAuthority;
import org.alfresco.repo.domain.DbPermission;
import org.alfresco.repo.domain.DbPermissionKey;
import org.alfresco.repo.domain.Node;
import org.alfresco.repo.domain.hibernate.DbAccessControlEntryImpl;
import org.alfresco.repo.domain.hibernate.DbAccessControlListImpl;
import org.alfresco.repo.domain.hibernate.DbAuthorityImpl;
import org.alfresco.repo.domain.hibernate.DbPermissionImpl;
import org.alfresco.repo.domain.hibernate.HibernateHelper;
import org.alfresco.repo.node.db.NodeDaoService;
import org.alfresco.repo.security.permissions.NodePermissionEntry;
import org.alfresco.repo.security.permissions.PermissionEntry;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.impl.PermissionsDaoComponent;
import org.alfresco.repo.security.permissions.impl.SimpleNodePermissionEntry;
import org.alfresco.repo.security.permissions.impl.SimplePermissionEntry;
import org.alfresco.repo.security.permissions.impl.SimplePermissionReference;
import org.alfresco.repo.transaction.TransactionalDao;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionsDaoComponentImpl
extends HibernateDaoSupport
implements PermissionsDaoComponent,
TransactionalDao {
    private static final boolean INHERIT_PERMISSIONS_DEFAULT = true;
    public static final String QUERY_GET_PERMISSION = "permission.GetPermission";
    public static final String QUERY_GET_AC_ENTRIES_FOR_AUTHORITY = "permission.GetAccessControlEntriesForAuthority";
    public static final String QUERY_GET_AC_ENTRIES_FOR_PERMISSION = "permission.GetAccessControlEntriesForPermission";
    private NodeDaoService nodeDaoService;
    private String uuid = GUID.generate();

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionsDaoComponentImpl)) {
            return false;
        }
        PermissionsDaoComponentImpl that = (PermissionsDaoComponentImpl)obj;
        return this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    @Override
    public boolean isDirty() {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                return session.isDirty();
            }
        };
        return (Boolean)this.getHibernateTemplate().execute(callback);
    }

    @Override
    public void flush() {
        this.getSession().flush();
    }

    public void setNodeDaoService(NodeDaoService nodeDaoService) {
        this.nodeDaoService = nodeDaoService;
    }

    @Override
    public NodePermissionEntry getPermissions(NodeRef nodeRef) {
        SimpleNodePermissionEntry snpe;
        SimpleNodePermissionEntry npe = null;
        DbAccessControlList acl = null;
        Node node = this.getNode(nodeRef, false);
        if (node != null) {
            acl = this.getAccessControlList(node, false);
        }
        npe = acl == null ? (snpe = new SimpleNodePermissionEntry(nodeRef, true, Collections.emptySet())) : this.createSimpleNodePermissionEntry(node);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created access control list for node: \n   node: " + nodeRef + "\n" + "   acl: " + npe));
        }
        return npe;
    }

    private DbAccessControlList getAccessControlList(Node node, boolean create) {
        DbAccessControlList acl = node.getAccessControlList();
        if (acl == null && create) {
            acl = this.createAccessControlList(node);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Retrieved access control list: \n   node: " + node.getNodeRef() + "\n" + "   list: " + acl));
        }
        return acl;
    }

    private DbAccessControlList createAccessControlList(Node node) {
        DbAccessControlListImpl acl = new DbAccessControlListImpl();
        acl.setInherits(true);
        this.getHibernateTemplate().save((Object)acl);
        node.setAccessControlList(acl);
        NodeRef nodeRef = node.getNodeRef();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created Access Control List: \n   node: " + nodeRef + "\n" + "   list: " + acl));
        }
        return acl;
    }

    private Node getNode(NodeRef nodeRef, boolean mustExist) {
        Node node = this.nodeDaoService.getNode(nodeRef);
        if (node == null && mustExist) {
            throw new InvalidNodeRefException(nodeRef);
        }
        return node;
    }

    @Override
    public void deletePermissions(NodeRef nodeRef) {
        Node node = this.getNode(nodeRef, false);
        if (node == null) {
            return;
        }
        DbAccessControlList acl = this.getAccessControlList(node, false);
        if (acl != null) {
            node.setAccessControlList(null);
            this.getHibernateTemplate().delete((Object)acl);
        }
    }

    @Override
    public void deletePermissions(final String authority) {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.getNamedQuery(PermissionsDaoComponentImpl.QUERY_GET_AC_ENTRIES_FOR_AUTHORITY).setString("authorityRecipient", authority);
                return HibernateHelper.deleteDbAccessControlEntries(session, query);
            }
        };
        Integer deletedCount = (Integer)this.getHibernateTemplate().execute(callback);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deleted " + deletedCount + " entries for authority " + authority));
        }
    }

    @Override
    public void deletePermissions(NodeRef nodeRef, String authority) {
        Node node = this.getNode(nodeRef, false);
        if (node == null) {
            return;
        }
        DbAccessControlList acl = node.getAccessControlList();
        int deletedCount = 0;
        if (acl != null) {
            deletedCount = acl.deleteEntriesForAuthority(authority);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deleted " + deletedCount + "entries for criteria: \n" + "   node: " + nodeRef + "\n" + "   authority: " + authority));
        }
    }

    @Override
    public void deletePermission(NodeRef nodeRef, String authority, PermissionReference permission) {
        Node node = this.getNode(nodeRef, false);
        if (node == null) {
            return;
        }
        DbAccessControlList acl = node.getAccessControlList();
        int deletedCount = 0;
        if (acl != null) {
            DbPermissionKey permissionKey = new DbPermissionKey(permission.getQName(), permission.getName());
            deletedCount = acl.deleteEntry(authority, permissionKey);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deleted " + deletedCount + "entries for criteria: \n" + "   node: " + nodeRef + "\n" + "   permission: " + permission + "\n" + "   authority: " + authority));
        }
    }

    @Override
    public void setPermission(NodeRef nodeRef, String authority, PermissionReference permission, boolean allow) {
        Node node = this.getNode(nodeRef, true);
        DbAccessControlEntry entry = this.getAccessControlEntry(node, authority, permission);
        if (entry == null) {
            DbAccessControlList dbAccessControlList = this.getAccessControlList(node, true);
            DbPermission dbPermission = this.getPermission(permission, true);
            DbAuthority dbAuthority = this.getAuthority(authority, true);
            entry = dbAccessControlList.newEntry(dbPermission, dbAuthority, allow);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Created new access control entry: " + entry));
            }
        } else {
            entry.setAllowed(allow);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Updated access control entry: " + entry));
            }
        }
    }

    private DbAccessControlEntry getAccessControlEntry(Node node, String authority, PermissionReference permission) {
        DbAccessControlList acl = this.getAccessControlList(node, false);
        DbAccessControlEntry entry = null;
        if (acl != null) {
            DbPermissionKey permissionKey = new DbPermissionKey(permission.getQName(), permission.getName());
            entry = acl.getEntry(authority, permissionKey);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("" + (entry == null ? "Did not find" : "Found") + " entry for criteria: \n" + "   node: " + node.getId() + "\n" + "   authority: " + authority + "\n" + "   permission: " + permission));
        }
        return entry;
    }

    private DbAuthority getAuthority(String authority, boolean create) {
        DbAuthority entity = (DbAuthority)this.getHibernateTemplate().get(DbAuthorityImpl.class, (Serializable)((Object)authority));
        if (entity == null && create) {
            entity = new DbAuthorityImpl();
            entity.setRecipient(authority);
            this.getHibernateTemplate().save((Object)entity);
            return entity;
        }
        return entity;
    }

    private DbPermission getPermission(PermissionReference permissionRef, boolean create) {
        QName qname = permissionRef.getQName();
        String name = permissionRef.getName();
        Session session = this.getSession();
        DbPermission dbPermission = DbPermissionImpl.find(session, qname, name);
        if (dbPermission == null && create) {
            dbPermission = new DbPermissionImpl();
            dbPermission.setTypeQname(qname);
            dbPermission.setName(name);
            this.getHibernateTemplate().save((Object)dbPermission);
        }
        return dbPermission;
    }

    @Override
    public void setPermission(PermissionEntry permissionEntry) {
        this.setPermission(permissionEntry.getNodeRef(), permissionEntry.getAuthority(), permissionEntry.getPermissionReference(), permissionEntry.isAllowed());
    }

    @Override
    public void setPermission(NodePermissionEntry nodePermissionEntry) {
        NodeRef nodeRef = nodePermissionEntry.getNodeRef();
        Node node = this.getNode(nodeRef, true);
        DbAccessControlList acl = this.getAccessControlList(node, false);
        if (acl != null) {
            node.setAccessControlList(null);
            this.getHibernateTemplate().delete((Object)acl);
        }
        acl = this.createAccessControlList(node);
        acl.setInherits(nodePermissionEntry.inheritPermissions());
        for (PermissionEntry permissionEntry : nodePermissionEntry.getPermissionEntries()) {
            PermissionReference permission = permissionEntry.getPermissionReference();
            String authority = permissionEntry.getAuthority();
            boolean isAllowed = permissionEntry.isAllowed();
            DbPermission permissionEntity = this.getPermission(permission, true);
            DbAuthority authorityEntity = this.getAuthority(authority, true);
            DbAccessControlEntryImpl entry = acl.newEntry(permissionEntity, authorityEntity, isAllowed);
        }
    }

    @Override
    public void setInheritParentPermissions(NodeRef nodeRef, boolean inheritParentPermissions) {
        Node node = this.getNode(nodeRef, true);
        DbAccessControlList acl = null;
        if (!inheritParentPermissions) {
            acl = this.getAccessControlList(node, true);
            acl.setInherits(false);
        } else {
            acl = this.getAccessControlList(node, false);
            if (acl != null) {
                acl.setInherits(true);
            }
        }
    }

    @Override
    public boolean getInheritParentPermissions(NodeRef nodeRef) {
        Node node = this.getNode(nodeRef, false);
        if (node == null) {
            return true;
        }
        DbAccessControlList acl = this.getAccessControlList(node, false);
        if (acl == null) {
            return true;
        }
        return acl.getInherits();
    }

    private SimpleNodePermissionEntry createSimpleNodePermissionEntry(Node node) {
        DbAccessControlList acl = node.getAccessControlList();
        if (acl == null) {
            SimpleNodePermissionEntry snpe = new SimpleNodePermissionEntry(node.getNodeRef(), true, Collections.emptySet());
            return snpe;
        }
        Set<DbAccessControlEntry> entries = acl.getEntries();
        SimpleNodePermissionEntry snpe = new SimpleNodePermissionEntry(node.getNodeRef(), acl.getInherits(), this.createSimplePermissionEntries(node, entries));
        return snpe;
    }

    private Set<SimplePermissionEntry> createSimplePermissionEntries(Node node, Collection<DbAccessControlEntry> entries) {
        if (entries == null) {
            return null;
        }
        HashSet<SimplePermissionEntry> spes = new HashSet<SimplePermissionEntry>(entries.size(), 1.0f);
        if (entries.size() != 0) {
            for (DbAccessControlEntry entry : entries) {
                spes.add(PermissionsDaoComponentImpl.createSimplePermissionEntry(node, entry));
            }
        }
        return spes;
    }

    private static SimplePermissionEntry createSimplePermissionEntry(Node node, DbAccessControlEntry ace) {
        if (ace == null) {
            return null;
        }
        return new SimplePermissionEntry(node.getNodeRef(), PermissionsDaoComponentImpl.createSimplePermissionReference(ace.getPermission()), ace.getAuthority().getRecipient(), ace.isAllowed() ? AccessStatus.ALLOWED : AccessStatus.DENIED);
    }

    private static SimplePermissionReference createSimplePermissionReference(DbPermission perm) {
        if (perm == null) {
            return null;
        }
        return new SimplePermissionReference(perm.getTypeQname(), perm.getName());
    }
}

