/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.hibernate;

import java.io.Serializable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.domain.Node;
import org.alfresco.repo.domain.Store;
import org.alfresco.repo.domain.StoreKey;
import org.alfresco.service.cmr.repository.StoreRef;

public class StoreImpl
implements Store,
Serializable {
    private static final long serialVersionUID = -6135740209100885890L;
    private StoreKey key;
    private Node rootNode;
    private transient ReentrantReadWriteLock.ReadLock refReadLock;
    private transient ReentrantReadWriteLock.WriteLock refWriteLock;
    private transient StoreRef storeRef;

    public StoreImpl() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.refReadLock = lock.readLock();
        this.refWriteLock = lock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreRef getStoreRef() {
        this.refReadLock.lock();
        try {
            if (this.storeRef != null) {
                StoreRef storeRef = this.storeRef;
                return storeRef;
            }
        }
        finally {
            this.refReadLock.unlock();
        }
        this.refWriteLock.lock();
        try {
            if (this.storeRef == null) {
                this.storeRef = new StoreRef(this.getKey().getProtocol(), this.getKey().getIdentifier());
            }
            StoreRef storeRef = this.storeRef;
            return storeRef;
        }
        finally {
            this.refWriteLock.unlock();
        }
    }

    public String toString() {
        return this.getStoreRef().toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Store)) {
            return false;
        }
        Store that = (Store)obj;
        return this.getKey().equals(that.getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public StoreKey getKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKey(StoreKey key) {
        this.refWriteLock.lock();
        try {
            this.key = key;
            this.storeRef = null;
        }
        finally {
            this.refWriteLock.unlock();
        }
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(Node rootNode) {
        this.rootNode = rootNode;
    }
}

