/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.hibernate;

import java.io.Serializable;
import org.alfresco.repo.domain.StoreKey;
import org.alfresco.repo.domain.VersionCount;
import org.alfresco.repo.domain.hibernate.VersionCountImpl;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.version.common.counter.VersionCounterService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.hibernate.LockMode;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class VersionCounterDaoComponentImpl
extends HibernateDaoSupport
implements VersionCounterService,
NodeServicePolicies.BeforeCreateStorePolicy {
    private PolicyComponent policyComponent;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "beforeCreateStore"), this, (Behaviour)new JavaBehaviour(this, "beforeCreateStore"));
    }

    public void beforeCreateStore(QName nodeTypeQName, StoreRef storeRef) {
        StoreKey storeKey = new StoreKey(storeRef.getProtocol(), storeRef.getIdentifier());
        VersionCount versionCount = (VersionCount)this.getHibernateTemplate().get(VersionCountImpl.class, (Serializable)storeKey);
        if (versionCount != null) {
            return;
        }
        versionCount = new VersionCountImpl();
        versionCount.setKey(storeKey);
        this.getHibernateTemplate().save((Object)versionCount);
    }

    private VersionCount getVersionCounter(StoreRef storeRef) {
        StoreKey storeKey = new StoreKey(storeRef.getProtocol(), storeRef.getIdentifier());
        VersionCount versionCount = (VersionCount)this.getHibernateTemplate().get(VersionCountImpl.class, (Serializable)storeKey, LockMode.UPGRADE);
        if (versionCount == null) {
            versionCount = new VersionCountImpl();
            versionCount.setKey(storeKey);
            this.getHibernateTemplate().save((Object)versionCount);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Created version counter: \n   Thread: " + Thread.currentThread().getName() + "\n" + "   Version count: " + versionCount.getVersionCount()));
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Got version counter: \n   Thread: " + Thread.currentThread().getName() + "\n" + "   Version count: " + versionCount.getVersionCount()));
        }
        return versionCount;
    }

    public int nextVersionNumber(StoreRef storeRef) {
        VersionCount versionCount = this.getVersionCounter(storeRef);
        int nextCount = versionCount.incrementVersionCount();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Incremented version count: \n   Thread: " + Thread.currentThread().getName() + "\n" + "   New version count: " + versionCount.getVersionCount()));
        }
        return nextCount;
    }

    public int currentVersionNumber(StoreRef storeRef) {
        VersionCount versionCounter = this.getVersionCounter(storeRef);
        return versionCounter.getVersionCount();
    }

    public synchronized void resetVersionNumber(StoreRef storeRef) {
        VersionCount versionCounter = this.getVersionCounter(storeRef);
        versionCounter.resetVersionCount();
    }

    public synchronized void setVersionNumber(StoreRef storeRef, int versionCount) {
        VersionCount versionCounter = this.getVersionCounter(storeRef);
        versionCounter.setVersionCount(versionCount);
    }
}

