/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.exporter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.view.ExportPackageHandler;
import org.alfresco.service.cmr.view.ExporterException;
import org.alfresco.util.TempFileProvider;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class ACPExportPackageHandler
implements ExportPackageHandler {
    public static final String ACP_EXTENSION = "acp";
    protected MimetypeService mimetypeService;
    protected OutputStream outputStream;
    protected File dataFile;
    protected File contentDir;
    protected File tempDataFile;
    protected OutputStream tempDataFileStream;
    protected ZipOutputStream zipStream;
    protected int iFileCnt = 0;

    public ACPExportPackageHandler(File destDir, File zipFile, File dataFile, File contentDir, boolean overwrite, MimetypeService mimetypeService) {
        try {
            String zipFilePath = zipFile.getPath();
            if (!zipFilePath.endsWith(".acp")) {
                zipFilePath = zipFilePath + (zipFilePath.charAt(zipFilePath.length() - 1) == '.' ? ACP_EXTENSION : ".acp");
            }
            File absZipFile = new File(destDir, zipFilePath);
            this.log("Exporting to package zip file " + absZipFile.getAbsolutePath());
            if (absZipFile.exists()) {
                if (!overwrite) {
                    throw new ExporterException("Package zip file " + absZipFile.getAbsolutePath() + " already exists.");
                }
                this.log("Warning: Overwriting existing package zip file " + absZipFile.getAbsolutePath());
            }
            this.outputStream = new FileOutputStream(absZipFile);
            this.dataFile = dataFile;
            this.contentDir = contentDir;
            this.mimetypeService = mimetypeService;
        }
        catch (FileNotFoundException e) {
            throw new ExporterException("Failed to create zip file", e);
        }
    }

    public ACPExportPackageHandler(OutputStream outputStream, File dataFile, File contentDir, MimetypeService mimetypeService) {
        this.outputStream = outputStream;
        this.dataFile = dataFile;
        this.contentDir = contentDir;
        this.mimetypeService = mimetypeService;
    }

    public void startExport() {
        this.zipStream = new ZipOutputStream(this.outputStream);
        this.zipStream.setEncoding("Cp437");
    }

    public OutputStream createDataStream() {
        this.tempDataFile = TempFileProvider.createTempFile((String)"exportDataStream", (String)".xml");
        try {
            this.tempDataFileStream = new FileOutputStream(this.tempDataFile);
            return this.tempDataFileStream;
        }
        catch (FileNotFoundException e) {
            throw new ExporterException("Failed to create data file stream", e);
        }
    }

    public ContentData exportContent(InputStream content, ContentData contentData) {
        String mimetype;
        if (content == null) {
            return contentData;
        }
        String contentDirPath = this.contentDir.getPath();
        if (contentDirPath.charAt(contentDirPath.length() - 1) != '.' && contentDirPath.lastIndexOf(46) != -1) {
            contentDirPath = contentDirPath.substring(0, contentDirPath.lastIndexOf("."));
        }
        String extension = "bin";
        if (this.mimetypeService != null && (mimetype = contentData.getMimetype()) != null && mimetype.length() > 0) {
            try {
                extension = this.mimetypeService.getExtension(mimetype);
            }
            catch (AlfrescoRuntimeException e) {
                // empty catch block
            }
        }
        File file = new File(contentDirPath, "content" + this.iFileCnt++ + "." + extension);
        try {
            ZipEntry zipEntry = new ZipEntry(file.getPath());
            this.zipStream.putNextEntry(zipEntry);
            this.copyStream((OutputStream)this.zipStream, content);
        }
        catch (IOException e) {
            throw new ExporterException("Failed to zip export stream", e);
        }
        return new ContentData(file.getPath(), contentData.getMimetype(), contentData.getSize(), contentData.getEncoding());
    }

    public void endExport() {
        String dataFilePath = this.dataFile.getPath();
        if (!dataFilePath.endsWith(".xml")) {
            dataFilePath = dataFilePath + (dataFilePath.charAt(dataFilePath.length() - 1) == '.' ? "xml" : ".xml");
        }
        ZipEntry zipEntry = new ZipEntry(dataFilePath);
        try {
            this.tempDataFileStream.close();
            this.zipStream.putNextEntry(zipEntry);
            FileInputStream dataFileStream = new FileInputStream(this.tempDataFile);
            this.copyStream((OutputStream)this.zipStream, dataFileStream);
            ((InputStream)dataFileStream).close();
        }
        catch (IOException e) {
            throw new ExporterException("Failed to zip data stream file", e);
        }
        try {
            this.zipStream.close();
        }
        catch (IOException e) {
            throw new ExporterException("Failed to close zip package stream", e);
        }
    }

    protected void log(String message) {
    }

    private void copyStream(OutputStream output, InputStream in) throws IOException {
        byte[] buffer = new byte[20480];
        int read = in.read(buffer, 0, 20480);
        while (read != -1) {
            output.write(buffer, 0, read);
            read = in.read(buffer, 0, 20480);
        }
    }
}

