/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.exporter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.exporter.ChainedExporter;
import org.alfresco.repo.exporter.ExporterCrawler;
import org.alfresco.repo.exporter.URLExporter;
import org.alfresco.repo.exporter.ViewXMLExporter;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.view.ExportPackageHandler;
import org.alfresco.service.cmr.view.Exporter;
import org.alfresco.service.cmr.view.ExporterContext;
import org.alfresco.service.cmr.view.ExporterCrawlerParameters;
import org.alfresco.service.cmr.view.ExporterException;
import org.alfresco.service.cmr.view.ExporterService;
import org.alfresco.service.cmr.view.ImporterException;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.cmr.view.ReferenceType;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.ParameterCheck;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.xml.sax.ContentHandler;

public class ExporterComponent
implements ExporterService {
    private NamespaceService namespaceService;
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private SearchService searchService;
    private ContentService contentService;
    private DescriptorService descriptorService;
    private AuthenticationService authenticationService;
    private PermissionService permissionService;
    private int indentSize = 2;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setDescriptorService(DescriptorService descriptorService) {
        this.descriptorService = descriptorService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void exportView(OutputStream viewWriter, ExporterCrawlerParameters parameters, Exporter progress) {
        ParameterCheck.mandatory((String)"View Writer", (Object)viewWriter);
        Exporter xmlExporter = this.createXMLExporter(viewWriter, parameters.getReferenceType());
        this.exportView(xmlExporter, parameters, progress);
    }

    public void exportView(ExportPackageHandler exportHandler, ExporterCrawlerParameters parameters, Exporter progress) {
        ParameterCheck.mandatory((String)"Stream Handler", (Object)exportHandler);
        exportHandler.startExport();
        OutputStream dataFile = exportHandler.createDataStream();
        Exporter xmlExporter = this.createXMLExporter(dataFile, parameters.getReferenceType());
        URLExporter urlExporter = new URLExporter(xmlExporter, exportHandler);
        this.exportView(urlExporter, parameters, progress);
        exportHandler.endExport();
    }

    public void exportView(Exporter exporter, ExporterCrawlerParameters parameters, Exporter progress) {
        ParameterCheck.mandatory((String)"Exporter", (Object)exporter);
        ChainedExporter chainedExporter = new ChainedExporter(new Exporter[]{exporter, progress});
        DefaultCrawler crawler = new DefaultCrawler();
        crawler.export(parameters, chainedExporter);
    }

    private Exporter createXMLExporter(OutputStream viewWriter, ReferenceType referenceType) {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setNewLineAfterDeclaration(false);
        format.setIndentSize(this.indentSize);
        format.setEncoding("UTF-8");
        try {
            XMLWriter writer = new XMLWriter(viewWriter, format);
            ViewXMLExporter exporter = new ViewXMLExporter(this.namespaceService, this.nodeService, this.searchService, this.dictionaryService, this.permissionService, (ContentHandler)writer);
            exporter.setReferenceType(referenceType);
            return exporter;
        }
        catch (UnsupportedEncodingException e) {
            throw new ExporterException("Failed to create XML Writer for export", e);
        }
        catch (Exception e) {
            throw new ExporterException("Failed to create XML Writer for export", e);
        }
    }

    private class ExporterContextImpl
    implements ExporterContext {
        private NodeRef exportOf;
        private NodeRef parent;
        private String exportedBy;
        private Date exportedDate;
        private String exporterVersion;

        public ExporterContextImpl(ExporterCrawlerParameters parameters) {
            String currentUserName = ExporterComponent.this.authenticationService.getCurrentUserName();
            this.exportedBy = currentUserName == null ? "unknown" : currentUserName;
            this.exportedDate = new Date(System.currentTimeMillis());
            this.exportOf = this.getNodeRef(parameters.getExportFrom());
            this.parent = this.getParent(this.exportOf, parameters.isCrawlSelf());
            this.exporterVersion = ExporterComponent.this.descriptorService.getServerDescriptor().getVersion();
        }

        public String getExportedBy() {
            return this.exportedBy;
        }

        public Date getExportedDate() {
            return this.exportedDate;
        }

        public String getExporterVersion() {
            return this.exporterVersion;
        }

        public NodeRef getExportOf() {
            return this.exportOf;
        }

        public NodeRef getExportParent() {
            return this.parent;
        }

        private NodeRef getNodeRef(Location location) {
            String path;
            NodeRef nodeRef;
            ParameterCheck.mandatory((String)"Location", (Object)location);
            NodeRef nodeRef2 = nodeRef = location == null ? null : location.getNodeRef();
            if (nodeRef == null) {
                nodeRef = ExporterComponent.this.nodeService.getRootNode(location.getStoreRef());
            }
            String string = path = location == null ? null : location.getPath();
            if (path != null && path.length() > 0) {
                List<NodeRef> nodeRefs = ExporterComponent.this.searchService.selectNodes(nodeRef, path, null, ExporterComponent.this.namespaceService, false);
                if (nodeRefs.size() == 0) {
                    throw new ImporterException("Path " + path + " within node " + nodeRef + " does not exist - the path must resolve to a valid location");
                }
                if (nodeRefs.size() > 1) {
                    throw new ImporterException("Path " + path + " within node " + nodeRef + " found too many locations - the path must resolve to one location");
                }
                nodeRef = nodeRefs.get(0);
            }
            return nodeRef;
        }

        private NodeRef getParent(NodeRef exportOf, boolean exportSelf) {
            NodeRef parent = null;
            if (exportSelf) {
                NodeRef rootNode = ExporterComponent.this.nodeService.getRootNode(exportOf.getStoreRef());
                if (rootNode.equals(exportOf)) {
                    parent = exportOf;
                } else {
                    ChildAssociationRef parentRef = ExporterComponent.this.nodeService.getPrimaryParent(exportOf);
                    parent = parentRef.getParentRef();
                }
            } else {
                parent = exportOf;
            }
            return parent;
        }
    }

    private class DefaultCrawler
    implements ExporterCrawler {
        private ExporterContext context;
        private Map<NodeRef, NodeRef> nodesWithSecondaryLinks = new HashMap<NodeRef, NodeRef>();
        private Map<NodeRef, NodeRef> nodesWithAssociations = new HashMap<NodeRef, NodeRef>();

        private DefaultCrawler() {
        }

        public void export(ExporterCrawlerParameters parameters, Exporter exporter) {
            this.nodesWithSecondaryLinks.clear();
            this.nodesWithAssociations.clear();
            this.context = new ExporterContextImpl(parameters);
            exporter.start(this.context);
            NodeRef nodeRef = this.context.getExportOf();
            if (parameters.isCrawlSelf()) {
                this.walkStartNamespaces(parameters, exporter);
                boolean rootNode = ExporterComponent.this.nodeService.getRootNode(nodeRef.getStoreRef()).equals(nodeRef);
                this.walkNode(nodeRef, parameters, exporter, rootNode);
                this.walkEndNamespaces(parameters, exporter);
            } else if (parameters.isCrawlChildNodes()) {
                List<ChildAssociationRef> childAssocs = ExporterComponent.this.nodeService.getChildAssocs(nodeRef);
                for (ChildAssociationRef childAssoc : childAssocs) {
                    this.walkStartNamespaces(parameters, exporter);
                    this.walkNode(childAssoc.getChildRef(), parameters, exporter, false);
                    this.walkEndNamespaces(parameters, exporter);
                }
            }
            for (NodeRef nodeWithAssociations : this.nodesWithSecondaryLinks.keySet()) {
                this.walkStartNamespaces(parameters, exporter);
                this.walkNodeSecondaryLinks(nodeWithAssociations, parameters, exporter);
                this.walkEndNamespaces(parameters, exporter);
            }
            for (NodeRef nodeWithAssociations : this.nodesWithAssociations.keySet()) {
                this.walkStartNamespaces(parameters, exporter);
                this.walkNodeAssociations(nodeWithAssociations, parameters, exporter);
                this.walkEndNamespaces(parameters, exporter);
            }
            exporter.end();
        }

        private void walkStartNamespaces(ExporterCrawlerParameters parameters, Exporter exporter) {
            Collection<String> prefixes = ExporterComponent.this.namespaceService.getPrefixes();
            for (String prefix : prefixes) {
                if (prefix.equals("xml")) continue;
                String uri = ExporterComponent.this.namespaceService.getNamespaceURI(prefix);
                exporter.startNamespace(prefix, uri);
            }
        }

        private void walkEndNamespaces(ExporterCrawlerParameters parameters, Exporter exporter) {
            Collection<String> prefixes = ExporterComponent.this.namespaceService.getPrefixes();
            for (String prefix : prefixes) {
                if (prefix.equals("xml")) continue;
                exporter.endNamespace(prefix);
            }
        }

        private void walkNode(NodeRef nodeRef, ExporterCrawlerParameters parameters, Exporter exporter, boolean exportAsRef) {
            List<AssociationRef> associations;
            QName type = ExporterComponent.this.nodeService.getType(nodeRef);
            if (this.isExcludedURI(parameters.getExcludeNamespaceURIs(), type.getNamespaceURI())) {
                return;
            }
            if (exportAsRef) {
                exporter.startReference(nodeRef, null);
            } else {
                exporter.startNode(nodeRef);
            }
            exporter.startAspects(nodeRef);
            Set<QName> aspects = ExporterComponent.this.nodeService.getAspects(nodeRef);
            for (QName aspect : aspects) {
                if (this.isExcludedURI(parameters.getExcludeNamespaceURIs(), aspect.getNamespaceURI())) continue;
                exporter.startAspect(nodeRef, aspect);
                exporter.endAspect(nodeRef, aspect);
            }
            exporter.endAspects(nodeRef);
            AccessStatus readPermission = ExporterComponent.this.permissionService.hasPermission(nodeRef, "ReadPermissions");
            if (ExporterComponent.this.authenticationService.isCurrentUserTheSystemUser() || readPermission.equals((Object)AccessStatus.ALLOWED)) {
                Set<AccessPermission> permissions = ExporterComponent.this.permissionService.getAllSetPermissions(nodeRef);
                boolean inheritPermissions = ExporterComponent.this.permissionService.getInheritParentPermissions(nodeRef);
                if (permissions.size() > 0 || !inheritPermissions) {
                    exporter.startACL(nodeRef);
                    for (AccessPermission permission : permissions) {
                        exporter.permission(nodeRef, permission);
                    }
                    exporter.endACL(nodeRef);
                }
            }
            exporter.startProperties(nodeRef);
            Map<QName, Serializable> properties = ExporterComponent.this.nodeService.getProperties(nodeRef);
            for (QName property : properties.keySet()) {
                if (this.isExcludedURI(parameters.getExcludeNamespaceURIs(), property.getNamespaceURI())) continue;
                Serializable value = properties.get(property);
                if (!parameters.isCrawlNullProperties() && value == null) continue;
                exporter.startProperty(nodeRef, property);
                if (value instanceof Collection) {
                    exporter.startValueCollection(nodeRef, property);
                    int index = 0;
                    for (Object valueInCollection : (Collection)((Object)value)) {
                        this.walkProperty(nodeRef, property, valueInCollection, index, parameters, exporter);
                        ++index;
                    }
                    exporter.endValueCollection(nodeRef, property);
                } else {
                    this.walkProperty(nodeRef, property, value, -1, parameters, exporter);
                }
                exporter.endProperty(nodeRef, property);
            }
            exporter.endProperties(nodeRef);
            if (parameters.isCrawlChildNodes()) {
                exporter.startAssocs(nodeRef);
                List<ChildAssociationRef> childAssocs = ExporterComponent.this.nodeService.getChildAssocs(nodeRef);
                for (int i = 0; i < childAssocs.size(); ++i) {
                    ChildAssociationRef childAssoc = childAssocs.get(i);
                    QName childAssocType = childAssoc.getTypeQName();
                    if (this.isExcludedURI(parameters.getExcludeNamespaceURIs(), childAssocType.getNamespaceURI())) continue;
                    if (!childAssoc.isPrimary()) {
                        this.nodesWithSecondaryLinks.put(nodeRef, nodeRef);
                        continue;
                    }
                    if (i == 0 || !childAssocs.get(i - 1).getTypeQName().equals(childAssocType)) {
                        exporter.startAssoc(nodeRef, childAssocType);
                    }
                    if (!this.isExcludedURI(parameters.getExcludeNamespaceURIs(), childAssoc.getQName().getNamespaceURI())) {
                        this.walkNode(childAssoc.getChildRef(), parameters, exporter, false);
                    }
                    if (i != childAssocs.size() - 1 && childAssocs.get(i + 1).getTypeQName().equals(childAssocType)) continue;
                    exporter.endAssoc(nodeRef, childAssocType);
                }
                exporter.endAssocs(nodeRef);
            }
            if (parameters.isCrawlAssociations() && (associations = ExporterComponent.this.nodeService.getTargetAssocs(nodeRef, RegexQNamePattern.MATCH_ALL)).size() > 0) {
                this.nodesWithAssociations.put(nodeRef, nodeRef);
            }
            if (exportAsRef) {
                exporter.endReference(nodeRef);
            } else {
                exporter.endNode(nodeRef);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void walkProperty(NodeRef nodeRef, QName property, Object value, int index, ExporterCrawlerParameters parameters, Exporter exporter) {
            PropertyDefinition propDef = ExporterComponent.this.dictionaryService.getProperty(property);
            DataTypeDefinition dataTypeDef = propDef == null ? null : propDef.getDataType();
            QName valueDataType = null;
            if (dataTypeDef == null || dataTypeDef.getName().equals(DataTypeDefinition.ANY)) {
                DataTypeDefinition dataTypeDefinition = dataTypeDef = value == null ? null : ExporterComponent.this.dictionaryService.getDataType(value.getClass());
                if (dataTypeDef != null) {
                    valueDataType = dataTypeDef.getName();
                }
            } else {
                valueDataType = dataTypeDef.getName();
            }
            if (valueDataType == null || !valueDataType.equals(DataTypeDefinition.CONTENT)) {
                try {
                    exporter.value(nodeRef, property, value, index);
                }
                catch (TypeConversionException e) {
                    exporter.warning("Value of property " + property + " could not be converted to xml string");
                    exporter.value(nodeRef, property, value.toString(), index);
                }
            } else {
                ContentReader reader = ExporterComponent.this.contentService.getReader(nodeRef, property);
                if (!parameters.isCrawlContent() || reader == null || !reader.exists()) {
                    ContentData contentData = (ContentData)value;
                    ContentData noContentURL = new ContentData("", contentData.getMimetype(), contentData.getSize(), contentData.getEncoding());
                    exporter.content(nodeRef, property, null, noContentURL, index);
                    exporter.warning("Skipped content for property " + property + " on node " + nodeRef);
                } else {
                    InputStream inputStream = reader.getContentInputStream();
                    try {
                        exporter.content(nodeRef, property, inputStream, reader.getContentData(), index);
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            throw new ExporterException("Failed to export node content for node " + nodeRef, e);
                        }
                    }
                }
            }
        }

        private void walkNodeSecondaryLinks(NodeRef nodeRef, ExporterCrawlerParameters parameters, Exporter exporter) {
            exporter.startReference(nodeRef, null);
            exporter.startAssocs(nodeRef);
            List<ChildAssociationRef> childAssocs = ExporterComponent.this.nodeService.getChildAssocs(nodeRef);
            for (int i = 0; i < childAssocs.size(); ++i) {
                ChildAssociationRef childAssoc = childAssocs.get(i);
                QName childAssocType = childAssoc.getTypeQName();
                if (this.isExcludedURI(parameters.getExcludeNamespaceURIs(), childAssocType.getNamespaceURI()) || childAssoc.isPrimary() || !this.isWithinExport(childAssoc.getChildRef(), parameters)) continue;
                if (i == 0 || !childAssocs.get(i - 1).getTypeQName().equals(childAssocType)) {
                    exporter.startAssoc(nodeRef, childAssocType);
                }
                QName childName = childAssoc.getQName();
                if (!this.isExcludedURI(parameters.getExcludeNamespaceURIs(), childName.getNamespaceURI())) {
                    exporter.startReference(childAssoc.getChildRef(), childName);
                    exporter.endReference(childAssoc.getChildRef());
                }
                if (i != childAssocs.size() - 1 && childAssocs.get(i + 1).getTypeQName().equals(childAssocType)) continue;
                exporter.endAssoc(nodeRef, childAssocType);
            }
            exporter.endAssocs(nodeRef);
            exporter.endReference(nodeRef);
        }

        private void walkNodeAssociations(NodeRef nodeRef, ExporterCrawlerParameters parameters, Exporter exporter) {
            exporter.startReference(nodeRef, null);
            exporter.startAssocs(nodeRef);
            List<AssociationRef> assocs = ExporterComponent.this.nodeService.getTargetAssocs(nodeRef, RegexQNamePattern.MATCH_ALL);
            for (int i = 0; i < assocs.size(); ++i) {
                AssociationRef assoc = assocs.get(i);
                QName assocType = assoc.getTypeQName();
                if (this.isExcludedURI(parameters.getExcludeNamespaceURIs(), assocType.getNamespaceURI()) || !this.isWithinExport(assoc.getTargetRef(), parameters)) continue;
                if (i == 0 || !assocs.get(i - 1).getTypeQName().equals(assocType)) {
                    exporter.startAssoc(nodeRef, assocType);
                }
                exporter.startReference(assoc.getTargetRef(), null);
                exporter.endReference(assoc.getTargetRef());
                if (i != assocs.size() - 1 && assocs.get(i + 1).getTypeQName().equals(assocType)) continue;
                exporter.endAssoc(nodeRef, assocType);
            }
            exporter.endAssocs(nodeRef);
            exporter.endReference(nodeRef);
        }

        private boolean isExcludedURI(String[] excludeNamespaceURIs, String uri) {
            for (String excludedURI : excludeNamespaceURIs) {
                if (!uri.equals(excludedURI)) continue;
                return true;
            }
            return false;
        }

        private boolean isWithinExport(NodeRef nodeRef, ExporterCrawlerParameters parameters) {
            boolean isWithin = false;
            NodeRef exportRoot = this.context.getExportOf();
            if (nodeRef.equals(exportRoot) && parameters.isCrawlSelf()) {
                isWithin = true;
            } else {
                Path nodePath = ExporterComponent.this.nodeService.getPath(nodeRef);
                for (int i = nodePath.size() - 1; i >= 0; --i) {
                    Path.ChildAssocElement pathElement = (Path.ChildAssocElement)nodePath.get(i);
                    if (!pathElement.getRef().getChildRef().equals(exportRoot)) continue;
                    isWithin = true;
                    break;
                }
            }
            return isWithin;
        }
    }
}

