/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.exporter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.view.Exporter;
import org.alfresco.service.cmr.view.ExporterContext;
import org.alfresco.service.cmr.view.ExporterCrawlerParameters;
import org.alfresco.service.cmr.view.ExporterService;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.debug.NodeStoreInspector;

public class ExporterComponentTest
extends BaseSpringTest {
    private NodeService nodeService;
    private ExporterService exporterService;
    private ImporterService importerService;
    private StoreRef storeRef;
    private AuthenticationComponent authenticationComponent;

    protected void onSetUpInTransaction() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean(ServiceRegistry.NODE_SERVICE.getLocalName());
        this.exporterService = (ExporterService)this.applicationContext.getBean("exporterComponent");
        this.importerService = (ImporterService)this.applicationContext.getBean("importerComponent");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
    }

    protected void onTearDownInTransaction() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
        super.onTearDownInTransaction();
    }

    public void testExport() throws Exception {
        TestProgress testProgress = new TestProgress();
        Location location = new Location(this.storeRef);
        InputStream test = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/repo/importer/importercomponent_test.xml");
        InputStreamReader testReader = new InputStreamReader(test, "UTF-8");
        this.importerService.importView(testReader, location, null, null);
        System.out.println(NodeStoreInspector.dumpNodeStore((NodeService)this.applicationContext.getBean("NodeService"), this.storeRef));
        location.setPath("/system");
        File tempFile = TempFileProvider.createTempFile((String)"xmlexporttest", (String)".xml");
        FileOutputStream output = new FileOutputStream(tempFile);
        ExporterCrawlerParameters parameters = new ExporterCrawlerParameters();
        parameters.setExportFrom(location);
        this.exporterService.exportView(output, parameters, (Exporter)testProgress);
        ((OutputStream)output).close();
    }

    private static class TestProgress
    implements Exporter {
        private TestProgress() {
        }

        public void start(ExporterContext exportNodeRef) {
            System.out.println("TestProgress: start");
        }

        public void startNamespace(String prefix, String uri) {
            System.out.println("TestProgress: start namespace prefix = " + prefix + " uri = " + uri);
        }

        public void endNamespace(String prefix) {
            System.out.println("TestProgress: end namespace prefix = " + prefix);
        }

        public void startNode(NodeRef nodeRef) {
        }

        public void endNode(NodeRef nodeRef) {
        }

        public void startAspect(NodeRef nodeRef, QName aspect) {
        }

        public void endAspect(NodeRef nodeRef, QName aspect) {
        }

        public void startProperty(NodeRef nodeRef, QName property) {
        }

        public void endProperty(NodeRef nodeRef, QName property) {
        }

        public void startValueCollection(NodeRef nodeRef, QName property) {
        }

        public void endValueCollection(NodeRef nodeRef, QName property) {
        }

        public void value(NodeRef nodeRef, QName property, Object value, int index) {
        }

        public void content(NodeRef nodeRef, QName property, InputStream content, ContentData contentData, int index) {
        }

        public void startAssoc(NodeRef nodeRef, QName assoc) {
        }

        public void endAssoc(NodeRef nodeRef, QName assoc) {
        }

        public void warning(String warning) {
            System.out.println("TestProgress: warning " + warning);
        }

        public void end() {
            System.out.println("TestProgress: end");
        }

        public void startProperties(NodeRef nodeRef) {
        }

        public void endProperties(NodeRef nodeRef) {
        }

        public void startAspects(NodeRef nodeRef) {
        }

        public void endAspects(NodeRef nodeRef) {
        }

        public void startAssocs(NodeRef nodeRef) {
        }

        public void endAssocs(NodeRef nodeRef) {
        }

        public void startACL(NodeRef nodeRef) {
        }

        public void permission(NodeRef nodeRef, AccessPermission permission) {
        }

        public void endACL(NodeRef nodeRef) {
        }

        public void startReference(NodeRef nodeRef, QName childName) {
        }

        public void endReference(NodeRef nodeRef) {
        }
    }
}

