/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.exporter;

import java.io.InputStream;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.view.ExportPackageHandler;
import org.alfresco.service.cmr.view.Exporter;
import org.alfresco.service.cmr.view.ExporterContext;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ParameterCheck;

class URLExporter
implements Exporter {
    private Exporter exporter;
    private ExportPackageHandler streamHandler;

    public URLExporter(Exporter exporter, ExportPackageHandler streamHandler) {
        ParameterCheck.mandatory((String)"Exporter", (Object)exporter);
        ParameterCheck.mandatory((String)"Stream Handler", (Object)streamHandler);
        this.exporter = exporter;
        this.streamHandler = streamHandler;
    }

    public void start(ExporterContext context) {
        this.exporter.start(context);
    }

    public void startNamespace(String prefix, String uri) {
        this.exporter.startNamespace(prefix, uri);
    }

    public void endNamespace(String prefix) {
        this.exporter.endNamespace(prefix);
    }

    public void startNode(NodeRef nodeRef) {
        this.exporter.startNode(nodeRef);
    }

    public void endNode(NodeRef nodeRef) {
        this.exporter.endNode(nodeRef);
    }

    public void startAspects(NodeRef nodeRef) {
        this.exporter.startAspects(nodeRef);
    }

    public void endAspects(NodeRef nodeRef) {
        this.exporter.endAspects(nodeRef);
    }

    public void startAspect(NodeRef nodeRef, QName aspect) {
        this.exporter.startAspect(nodeRef, aspect);
    }

    public void endAspect(NodeRef nodeRef, QName aspect) {
        this.exporter.endAspect(nodeRef, aspect);
    }

    public void startACL(NodeRef nodeRef) {
        this.exporter.startACL(nodeRef);
    }

    public void permission(NodeRef nodeRef, AccessPermission permission) {
        this.exporter.permission(nodeRef, permission);
    }

    public void endACL(NodeRef nodeRef) {
        this.exporter.endACL(nodeRef);
    }

    public void startProperties(NodeRef nodeRef) {
        this.exporter.startProperties(nodeRef);
    }

    public void endProperties(NodeRef nodeRef) {
        this.exporter.endProperties(nodeRef);
    }

    public void startProperty(NodeRef nodeRef, QName property) {
        this.exporter.startProperty(nodeRef, property);
    }

    public void endProperty(NodeRef nodeRef, QName property) {
        this.exporter.endProperty(nodeRef, property);
    }

    public void startValueCollection(NodeRef nodeRef, QName property) {
        this.exporter.startValueCollection(nodeRef, property);
    }

    public void endValueCollection(NodeRef nodeRef, QName property) {
        this.exporter.endValueCollection(nodeRef, property);
    }

    public void value(NodeRef nodeRef, QName property, Object value, int index) {
        this.exporter.value(nodeRef, property, value, index);
    }

    public void content(NodeRef nodeRef, QName property, InputStream content, ContentData contentData, int index) {
        ContentData exportedContentData = this.streamHandler.exportContent(content, contentData);
        this.value(nodeRef, property, exportedContentData, index);
    }

    public void startAssoc(NodeRef nodeRef, QName assoc) {
        this.exporter.startAssoc(nodeRef, assoc);
    }

    public void endAssoc(NodeRef nodeRef, QName assoc) {
        this.exporter.endAssoc(nodeRef, assoc);
    }

    public void startAssocs(NodeRef nodeRef) {
        this.exporter.startAssocs(nodeRef);
    }

    public void endAssocs(NodeRef nodeRef) {
        this.exporter.endAssocs(nodeRef);
    }

    public void startReference(NodeRef nodeRef, QName childName) {
        this.exporter.startReference(nodeRef, childName);
    }

    public void endReference(NodeRef nodeRef) {
        this.exporter.endReference(nodeRef);
    }

    public void warning(String warning) {
        this.exporter.warning(warning);
    }

    public void end() {
        this.exporter.end();
    }
}

