/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.exporter;

import java.io.InputStream;
import java.util.List;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.view.Exporter;
import org.alfresco.service.cmr.view.ExporterContext;
import org.alfresco.service.cmr.view.ExporterException;
import org.alfresco.service.cmr.view.ReferenceType;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class ViewXMLExporter
implements Exporter {
    private static final String VIEW_LOCALNAME = "view";
    private static final String VALUES_LOCALNAME = "values";
    private static final String VALUE_LOCALNAME = "value";
    private static final String CHILDNAME_LOCALNAME = "childName";
    private static final String ASPECTS_LOCALNAME = "aspects";
    private static final String PROPERTIES_LOCALNAME = "properties";
    private static final String ASSOCIATIONS_LOCALNAME = "associations";
    private static final String DATATYPE_LOCALNAME = "datatype";
    private static final String ISNULL_LOCALNAME = "isNull";
    private static final String METADATA_LOCALNAME = "metadata";
    private static final String EXPORTEDBY_LOCALNAME = "exportBy";
    private static final String EXPORTEDDATE_LOCALNAME = "exportDate";
    private static final String EXPORTERVERSION_LOCALNAME = "exporterVersion";
    private static final String EXPORTOF_LOCALNAME = "exportOf";
    private static final String ACL_LOCALNAME = "acl";
    private static final String ACE_LOCALNAME = "ace";
    private static final String ACCESS_LOCALNAME = "access";
    private static final String AUTHORITY_LOCALNAME = "authority";
    private static final String PERMISSION_LOCALNAME = "permission";
    private static final String INHERITPERMISSIONS_LOCALNAME = "inherit";
    private static final String REFERENCE_LOCALNAME = "reference";
    private static final String PATHREF_LOCALNAME = "pathref";
    private static final String NODEREF_LOCALNAME = "noderef";
    private static QName VIEW_QNAME;
    private static QName VALUES_QNAME;
    private static QName VALUE_QNAME;
    private static QName PROPERTIES_QNAME;
    private static QName ASPECTS_QNAME;
    private static QName ASSOCIATIONS_QNAME;
    private static QName CHILDNAME_QNAME;
    private static QName DATATYPE_QNAME;
    private static QName ISNULL_QNAME;
    private static QName METADATA_QNAME;
    private static QName EXPORTEDBY_QNAME;
    private static QName EXPORTEDDATE_QNAME;
    private static QName EXPORTERVERSION_QNAME;
    private static QName EXPORTOF_QNAME;
    private static QName ACL_QNAME;
    private static QName ACE_QNAME;
    private static QName ACCESS_QNAME;
    private static QName AUTHORITY_QNAME;
    private static QName PERMISSION_QNAME;
    private static QName INHERITPERMISSIONS_QNAME;
    private static QName REFERENCE_QNAME;
    private static QName PATHREF_QNAME;
    private static QName NODEREF_QNAME;
    private static final AttributesImpl EMPTY_ATTRIBUTES;
    private NamespaceService namespaceService;
    private NodeService nodeService;
    private SearchService searchService;
    private DictionaryService dictionaryService;
    private PermissionService permissionService;
    private ContentHandler contentHandler;
    private ExporterContext context;
    private ReferenceType referenceType;

    ViewXMLExporter(NamespaceService namespaceService, NodeService nodeService, SearchService searchService, DictionaryService dictionaryService, PermissionService permissionService, ContentHandler contentHandler) {
        this.namespaceService = namespaceService;
        this.nodeService = nodeService;
        this.searchService = searchService;
        this.dictionaryService = dictionaryService;
        this.permissionService = permissionService;
        this.contentHandler = contentHandler;
        VIEW_QNAME = QName.createQName(VIEW_LOCALNAME, VIEW_LOCALNAME, namespaceService);
        VALUE_QNAME = QName.createQName(VIEW_LOCALNAME, VALUE_LOCALNAME, namespaceService);
        VALUES_QNAME = QName.createQName(VIEW_LOCALNAME, VALUES_LOCALNAME, namespaceService);
        CHILDNAME_QNAME = QName.createQName(VIEW_LOCALNAME, CHILDNAME_LOCALNAME, namespaceService);
        ASPECTS_QNAME = QName.createQName(VIEW_LOCALNAME, ASPECTS_LOCALNAME, namespaceService);
        PROPERTIES_QNAME = QName.createQName(VIEW_LOCALNAME, PROPERTIES_LOCALNAME, namespaceService);
        ASSOCIATIONS_QNAME = QName.createQName(VIEW_LOCALNAME, ASSOCIATIONS_LOCALNAME, namespaceService);
        DATATYPE_QNAME = QName.createQName(VIEW_LOCALNAME, DATATYPE_LOCALNAME, namespaceService);
        ISNULL_QNAME = QName.createQName(VIEW_LOCALNAME, ISNULL_LOCALNAME, namespaceService);
        METADATA_QNAME = QName.createQName(VIEW_LOCALNAME, METADATA_LOCALNAME, namespaceService);
        EXPORTEDBY_QNAME = QName.createQName(VIEW_LOCALNAME, EXPORTEDBY_LOCALNAME, namespaceService);
        EXPORTEDDATE_QNAME = QName.createQName(VIEW_LOCALNAME, EXPORTEDDATE_LOCALNAME, namespaceService);
        EXPORTERVERSION_QNAME = QName.createQName(VIEW_LOCALNAME, EXPORTERVERSION_LOCALNAME, namespaceService);
        EXPORTOF_QNAME = QName.createQName(VIEW_LOCALNAME, EXPORTOF_LOCALNAME, namespaceService);
        ACL_QNAME = QName.createQName(VIEW_LOCALNAME, ACL_LOCALNAME, namespaceService);
        ACE_QNAME = QName.createQName(VIEW_LOCALNAME, ACE_LOCALNAME, namespaceService);
        ACCESS_QNAME = QName.createQName(VIEW_LOCALNAME, ACCESS_LOCALNAME, namespaceService);
        AUTHORITY_QNAME = QName.createQName(VIEW_LOCALNAME, AUTHORITY_LOCALNAME, namespaceService);
        PERMISSION_QNAME = QName.createQName(VIEW_LOCALNAME, PERMISSION_LOCALNAME, namespaceService);
        INHERITPERMISSIONS_QNAME = QName.createQName(VIEW_LOCALNAME, INHERITPERMISSIONS_LOCALNAME, namespaceService);
        REFERENCE_QNAME = QName.createQName(VIEW_LOCALNAME, REFERENCE_LOCALNAME, namespaceService);
        PATHREF_QNAME = QName.createQName(VIEW_LOCALNAME, PATHREF_LOCALNAME, namespaceService);
        NODEREF_QNAME = QName.createQName(VIEW_LOCALNAME, NODEREF_LOCALNAME, namespaceService);
    }

    public void setReferenceType(ReferenceType referenceType) {
        this.referenceType = referenceType;
    }

    public void start(ExporterContext context) {
        try {
            this.context = context;
            this.contentHandler.startDocument();
            this.contentHandler.startPrefixMapping(VIEW_LOCALNAME, "http://www.alfresco.org/view/repository/1.0");
            this.contentHandler.startElement(VIEW_LOCALNAME, VIEW_LOCALNAME, VIEW_QNAME.toPrefixString(), EMPTY_ATTRIBUTES);
            this.contentHandler.startElement(VIEW_LOCALNAME, METADATA_LOCALNAME, METADATA_QNAME.toPrefixString(), EMPTY_ATTRIBUTES);
            this.contentHandler.startElement(VIEW_LOCALNAME, EXPORTEDBY_LOCALNAME, EXPORTEDBY_QNAME.toPrefixString(), EMPTY_ATTRIBUTES);
            this.contentHandler.characters(context.getExportedBy().toCharArray(), 0, context.getExportedBy().length());
            this.contentHandler.endElement(VIEW_LOCALNAME, EXPORTEDBY_LOCALNAME, EXPORTEDBY_QNAME.toPrefixString());
            this.contentHandler.startElement(VIEW_LOCALNAME, EXPORTEDDATE_LOCALNAME, EXPORTEDDATE_QNAME.toPrefixString(), EMPTY_ATTRIBUTES);
            String date = DefaultTypeConverter.INSTANCE.convert(String.class, (Object)context.getExportedDate());
            this.contentHandler.characters(date.toCharArray(), 0, date.length());
            this.contentHandler.endElement(VIEW_LOCALNAME, EXPORTEDDATE_LOCALNAME, EXPORTEDDATE_QNAME.toPrefixString());
            this.contentHandler.startElement(VIEW_LOCALNAME, EXPORTERVERSION_LOCALNAME, EXPORTERVERSION_QNAME.toPrefixString(), EMPTY_ATTRIBUTES);
            this.contentHandler.characters(context.getExporterVersion().toCharArray(), 0, context.getExporterVersion().length());
            this.contentHandler.endElement(VIEW_LOCALNAME, EXPORTERVERSION_LOCALNAME, EXPORTERVERSION_QNAME.toPrefixString());
            this.contentHandler.startElement(VIEW_LOCALNAME, EXPORTOF_LOCALNAME, EXPORTOF_QNAME.toPrefixString(), EMPTY_ATTRIBUTES);
            String path = this.nodeService.getPath(context.getExportOf()).toPrefixString(this.namespaceService);
            this.contentHandler.characters(path.toCharArray(), 0, path.length());
            this.contentHandler.endElement(VIEW_LOCALNAME, EXPORTOF_LOCALNAME, EXPORTOF_QNAME.toPrefixString());
            this.contentHandler.endElement(VIEW_LOCALNAME, METADATA_LOCALNAME, METADATA_QNAME.toPrefixString());
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process export start event", e);
        }
    }

    public void startNamespace(String prefix, String uri) {
        try {
            this.contentHandler.startPrefixMapping(prefix, uri);
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process start namespace event - prefix " + prefix + " uri " + uri, e);
        }
    }

    public void endNamespace(String prefix) {
        try {
            this.contentHandler.endPrefixMapping(prefix);
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process end namespace event - prefix " + prefix, e);
        }
    }

    public void startNode(NodeRef nodeRef) {
        try {
            AttributesImpl attrs = new AttributesImpl();
            Path path = this.nodeService.getPath(nodeRef);
            if (path.size() > 1) {
                Path.ChildAssocElement pathElement = (Path.ChildAssocElement)path.last();
                QName childQName = pathElement.getRef().getQName();
                attrs.addAttribute("http://www.alfresco.org/view/repository/1.0", CHILDNAME_LOCALNAME, CHILDNAME_QNAME.toPrefixString(), null, this.toPrefixString(childQName));
            }
            QName type = this.nodeService.getType(nodeRef);
            this.contentHandler.startElement(type.getNamespaceURI(), type.getLocalName(), this.toPrefixString(type), attrs);
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process start node event - node ref " + nodeRef.toString(), e);
        }
    }

    public void endNode(NodeRef nodeRef) {
        try {
            QName type = this.nodeService.getType(nodeRef);
            this.contentHandler.endElement(type.getNamespaceURI(), type.getLocalName(), this.toPrefixString(type));
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process end node event - node ref " + nodeRef.toString(), e);
        }
    }

    public void startAspects(NodeRef nodeRef) {
        try {
            this.contentHandler.startElement(ASPECTS_QNAME.getNamespaceURI(), ASPECTS_LOCALNAME, this.toPrefixString(ASPECTS_QNAME), EMPTY_ATTRIBUTES);
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process start aspects", e);
        }
    }

    public void endAspects(NodeRef nodeRef) {
        try {
            this.contentHandler.endElement(ASPECTS_QNAME.getNamespaceURI(), ASPECTS_LOCALNAME, this.toPrefixString(ASPECTS_QNAME));
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process end aspects", e);
        }
    }

    public void startAspect(NodeRef nodeRef, QName aspect) {
        try {
            this.contentHandler.startElement(aspect.getNamespaceURI(), aspect.getLocalName(), this.toPrefixString(aspect), EMPTY_ATTRIBUTES);
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process start aspect event - node ref " + nodeRef.toString() + "; aspect " + this.toPrefixString(aspect), e);
        }
    }

    public void endAspect(NodeRef nodeRef, QName aspect) {
        try {
            this.contentHandler.endElement(aspect.getNamespaceURI(), aspect.getLocalName(), this.toPrefixString(aspect));
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process end aspect event - node ref " + nodeRef.toString() + "; aspect " + this.toPrefixString(aspect), e);
        }
    }

    public void startACL(NodeRef nodeRef) {
        try {
            AttributesImpl attrs = new AttributesImpl();
            boolean inherit = this.permissionService.getInheritParentPermissions(nodeRef);
            if (!inherit) {
                attrs.addAttribute("http://www.alfresco.org/view/repository/1.0", INHERITPERMISSIONS_LOCALNAME, INHERITPERMISSIONS_QNAME.toPrefixString(), null, "false");
            }
            this.contentHandler.startElement(ACL_QNAME.getNamespaceURI(), ACL_QNAME.getLocalName(), this.toPrefixString(ACL_QNAME), attrs);
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process start ACL event - node ref " + nodeRef.toString());
        }
    }

    public void permission(NodeRef nodeRef, AccessPermission permission) {
        try {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("http://www.alfresco.org/view/repository/1.0", ACCESS_LOCALNAME, ACCESS_QNAME.toPrefixString(), null, permission.getAccessStatus().toString());
            this.contentHandler.startElement(ACE_QNAME.getNamespaceURI(), ACE_QNAME.getLocalName(), this.toPrefixString(ACE_QNAME), attrs);
            this.contentHandler.startElement(AUTHORITY_QNAME.getNamespaceURI(), AUTHORITY_QNAME.getLocalName(), this.toPrefixString(AUTHORITY_QNAME), EMPTY_ATTRIBUTES);
            String authority = permission.getAuthority();
            this.contentHandler.characters(authority.toCharArray(), 0, authority.length());
            this.contentHandler.endElement(AUTHORITY_QNAME.getNamespaceURI(), AUTHORITY_QNAME.getLocalName(), this.toPrefixString(AUTHORITY_QNAME));
            this.contentHandler.startElement(PERMISSION_QNAME.getNamespaceURI(), PERMISSION_QNAME.getLocalName(), this.toPrefixString(PERMISSION_QNAME), EMPTY_ATTRIBUTES);
            String strPermission = permission.getPermission();
            this.contentHandler.characters(strPermission.toCharArray(), 0, strPermission.length());
            this.contentHandler.endElement(PERMISSION_QNAME.getNamespaceURI(), PERMISSION_QNAME.getLocalName(), this.toPrefixString(PERMISSION_QNAME));
            this.contentHandler.endElement(ACE_QNAME.getNamespaceURI(), ACE_QNAME.getLocalName(), this.toPrefixString(ACE_QNAME));
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process permission event - node ref " + nodeRef.toString() + "; permission " + permission);
        }
    }

    public void endACL(NodeRef nodeRef) {
        try {
            this.contentHandler.endElement(ACL_QNAME.getNamespaceURI(), ACL_QNAME.getLocalName(), this.toPrefixString(ACL_QNAME));
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process end ACL event - node ref " + nodeRef.toString());
        }
    }

    public void startProperties(NodeRef nodeRef) {
        try {
            this.contentHandler.startElement(PROPERTIES_QNAME.getNamespaceURI(), PROPERTIES_LOCALNAME, this.toPrefixString(PROPERTIES_QNAME), EMPTY_ATTRIBUTES);
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process start properties", e);
        }
    }

    public void endProperties(NodeRef nodeRef) {
        try {
            this.contentHandler.endElement(PROPERTIES_QNAME.getNamespaceURI(), PROPERTIES_LOCALNAME, this.toPrefixString(PROPERTIES_QNAME));
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process start properties", e);
        }
    }

    public void startProperty(NodeRef nodeRef, QName property) {
        try {
            this.contentHandler.startElement(property.getNamespaceURI(), property.getLocalName(), this.toPrefixString(property), EMPTY_ATTRIBUTES);
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process start property event - nodeRef " + nodeRef + "; property " + this.toPrefixString(property), e);
        }
    }

    public void endProperty(NodeRef nodeRef, QName property) {
        try {
            this.contentHandler.endElement(property.getNamespaceURI(), property.getLocalName(), this.toPrefixString(property));
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process end property event - nodeRef " + nodeRef + "; property " + this.toPrefixString(property), e);
        }
    }

    public void startValueCollection(NodeRef nodeRef, QName property) {
        try {
            this.contentHandler.startElement(VIEW_LOCALNAME, VALUES_LOCALNAME, this.toPrefixString(VALUES_QNAME), EMPTY_ATTRIBUTES);
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process start collection event - nodeRef " + nodeRef + "; property " + this.toPrefixString(property), e);
        }
    }

    public void endValueCollection(NodeRef nodeRef, QName property) {
        try {
            this.contentHandler.endElement(VIEW_LOCALNAME, VALUES_LOCALNAME, this.toPrefixString(VALUES_QNAME));
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process end collection event - nodeRef " + nodeRef + "; property " + this.toPrefixString(property), e);
        }
    }

    public void value(NodeRef nodeRef, QName property, Object value, int index) {
        try {
            String strValue;
            DataTypeDefinition dataTypeDef;
            QName valueDataType = null;
            PropertyDefinition propDef = this.dictionaryService.getProperty(property);
            DataTypeDefinition dataTypeDefinition = dataTypeDef = propDef == null ? null : propDef.getDataType();
            if (dataTypeDef == null || dataTypeDef.getName().equals(DataTypeDefinition.ANY)) {
                DataTypeDefinition dataTypeDefinition2 = dataTypeDef = value == null ? null : this.dictionaryService.getDataType(value.getClass());
                if (dataTypeDef != null) {
                    valueDataType = dataTypeDef.getName();
                }
            }
            if (value instanceof NodeRef && this.referenceType.equals((Object)ReferenceType.PATHREF)) {
                NodeRef valueNodeRef = (NodeRef)value;
                if (nodeRef.getStoreRef().equals(valueNodeRef.getStoreRef())) {
                    Path nodeRefPath = this.createPath(this.context.getExportOf(), nodeRef, valueNodeRef);
                    Object object = value = nodeRefPath == null ? null : nodeRefPath.toPrefixString(this.namespaceService);
                }
            }
            if (value == null || valueDataType != null || index != -1) {
                AttributesImpl attrs = new AttributesImpl();
                if (value == null) {
                    attrs.addAttribute(VIEW_LOCALNAME, ISNULL_LOCALNAME, ISNULL_QNAME.toPrefixString(), null, "true");
                }
                if (valueDataType != null) {
                    attrs.addAttribute(VIEW_LOCALNAME, DATATYPE_LOCALNAME, DATATYPE_QNAME.toPrefixString(), null, this.toPrefixString(valueDataType));
                }
                this.contentHandler.startElement(VIEW_LOCALNAME, VALUE_LOCALNAME, this.toPrefixString(VALUE_QNAME), attrs);
            }
            if ((strValue = DefaultTypeConverter.INSTANCE.convert(String.class, value)) != null) {
                this.contentHandler.characters(strValue.toCharArray(), 0, strValue.length());
            }
            if (value == null || valueDataType != null || index != -1) {
                this.contentHandler.endElement(VIEW_LOCALNAME, VALUE_LOCALNAME, this.toPrefixString(VALUE_QNAME));
            }
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process value event - nodeRef " + nodeRef + "; property " + this.toPrefixString(property) + "; value " + value, e);
        }
    }

    public void content(NodeRef nodeRef, QName property, InputStream content, ContentData contentData, int index) {
    }

    public void startAssoc(NodeRef nodeRef, QName assoc) {
        try {
            this.contentHandler.startElement(assoc.getNamespaceURI(), assoc.getLocalName(), this.toPrefixString(assoc), EMPTY_ATTRIBUTES);
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process start assoc event - nodeRef " + nodeRef + "; association " + this.toPrefixString(assoc), e);
        }
    }

    public void endAssoc(NodeRef nodeRef, QName assoc) {
        try {
            this.contentHandler.endElement(assoc.getNamespaceURI(), assoc.getLocalName(), this.toPrefixString(assoc));
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process end assoc event - nodeRef " + nodeRef + "; association " + this.toPrefixString(assoc), e);
        }
    }

    public void startAssocs(NodeRef nodeRef) {
        try {
            this.contentHandler.startElement(ASSOCIATIONS_QNAME.getNamespaceURI(), ASSOCIATIONS_LOCALNAME, this.toPrefixString(ASSOCIATIONS_QNAME), EMPTY_ATTRIBUTES);
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process start associations", e);
        }
    }

    public void endAssocs(NodeRef nodeRef) {
        try {
            this.contentHandler.endElement(ASSOCIATIONS_QNAME.getNamespaceURI(), ASSOCIATIONS_LOCALNAME, this.toPrefixString(ASSOCIATIONS_QNAME));
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process end associations", e);
        }
    }

    public void startReference(NodeRef nodeRef, QName childName) {
        try {
            ReferenceType referenceFormat = this.referenceType;
            if (nodeRef.equals(this.nodeService.getRootNode(nodeRef.getStoreRef()))) {
                referenceFormat = ReferenceType.PATHREF;
            }
            AttributesImpl attrs = new AttributesImpl();
            if (referenceFormat.equals((Object)ReferenceType.PATHREF)) {
                Path path = this.createPath(this.context.getExportParent(), this.context.getExportParent(), nodeRef);
                attrs.addAttribute("http://www.alfresco.org/view/repository/1.0", PATHREF_LOCALNAME, PATHREF_QNAME.toPrefixString(), null, path.toPrefixString(this.namespaceService));
            } else {
                attrs.addAttribute("http://www.alfresco.org/view/repository/1.0", NODEREF_LOCALNAME, NODEREF_QNAME.toPrefixString(), null, nodeRef.toString());
            }
            if (childName != null) {
                attrs.addAttribute("http://www.alfresco.org/view/repository/1.0", CHILDNAME_LOCALNAME, CHILDNAME_QNAME.toPrefixString(), null, childName.toPrefixString(this.namespaceService));
            }
            this.contentHandler.startElement(REFERENCE_QNAME.getNamespaceURI(), REFERENCE_LOCALNAME, this.toPrefixString(REFERENCE_QNAME), attrs);
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process start reference", e);
        }
    }

    public void endReference(NodeRef nodeRef) {
        try {
            this.contentHandler.endElement(REFERENCE_QNAME.getNamespaceURI(), REFERENCE_LOCALNAME, this.toPrefixString(REFERENCE_QNAME));
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process end reference", e);
        }
    }

    public void warning(String warning) {
    }

    public void end() {
        try {
            this.contentHandler.endElement(VIEW_LOCALNAME, VIEW_LOCALNAME, VIEW_QNAME.toPrefixString());
            this.contentHandler.endPrefixMapping(VIEW_LOCALNAME);
            this.contentHandler.endDocument();
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process end export event", e);
        }
    }

    private String toPrefixString(QName qname) {
        return qname.toPrefixString(this.namespaceService);
    }

    private Path createPath(NodeRef rootRef, NodeRef fromRef, NodeRef toRef) {
        if (!this.nodeService.exists(toRef)) {
            return null;
        }
        if (toRef.equals(this.nodeService.getRootNode(toRef.getStoreRef()))) {
            return this.nodeService.getPath(toRef);
        }
        Path rootPath = this.createIndexedPath(rootRef, this.nodeService.getPath(rootRef));
        Path fromPath = this.createIndexedPath(fromRef, this.nodeService.getPath(fromRef));
        Path toPath = this.createIndexedPath(toRef, this.nodeService.getPath(toRef));
        Path relativePath = null;
        try {
            int i;
            for (i = 0; i < toPath.size(); ++i) {
                Path.Element pathElement = toPath.get(i);
                if (!pathElement.getPrefixedString(this.namespaceService).equals("cm:categoryRoot")) continue;
                Path.ChildAssocElement childPath = (Path.ChildAssocElement)pathElement;
                relativePath = new Path();
                relativePath.append(new Path.ChildAssocElement(new ChildAssociationRef(null, null, null, childPath.getRef().getParentRef())));
                relativePath.append(toPath.subPath(i + 1, toPath.size() - 1));
                break;
            }
            if (relativePath == null) {
                for (i = 0; i < rootPath.size() && i < fromPath.size() && rootPath.get(i).equals(fromPath.get(i)); ++i) {
                }
                if (i == rootPath.size()) {
                    for (i = 0; i < rootPath.size() && i < toPath.size() && rootPath.get(i).equals(toPath.get(i)); ++i) {
                    }
                    if (i == rootPath.size()) {
                        relativePath = new Path();
                        for (int p = 0; p < fromPath.size() - i; ++p) {
                            relativePath.append(new Path.ParentElement());
                        }
                        if (i < toPath.size()) {
                            relativePath.append(toPath.subPath(i, toPath.size() - 1));
                        }
                    }
                }
            }
            if (relativePath == null) {
                relativePath = toPath;
            }
        }
        catch (Throwable e) {
            String msg = "Failed to determine relative path: root path=" + rootPath + "; from path=" + fromPath + "; to path=" + toPath;
            throw new ExporterException(msg, e);
        }
        return relativePath;
    }

    private Path createIndexedPath(NodeRef nodeRef, Path path) {
        block0: for (int i = path.size() - 1; i >= 0; --i) {
            Path.Element pathElement = path.get(i);
            if (i <= 0 || !(pathElement instanceof Path.ChildAssocElement)) continue;
            int index = 1;
            String searchPath = path.subPath(i).toPrefixString(this.namespaceService);
            List<NodeRef> siblings = this.searchService.selectNodes(nodeRef, searchPath, null, this.namespaceService, false);
            if (siblings.size() <= 1) continue;
            ChildAssociationRef childAssoc = ((Path.ChildAssocElement)pathElement).getRef();
            NodeRef childRef = childAssoc.getChildRef();
            for (NodeRef sibling : siblings) {
                if (sibling.equals(childRef)) {
                    childAssoc.setNthSibling(index);
                    continue block0;
                }
                ++index;
            }
        }
        return path;
    }

    static {
        EMPTY_ATTRIBUTES = new AttributesImpl();
    }
}

