/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forum;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.i18n.I18NUtil;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ForumModel;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.policy.PolicyScope;
import org.alfresco.service.cmr.coci.CheckOutCheckInServiceException;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscussableAspect {
    private static final Log logger = LogFactory.getLog(DiscussableAspect.class);
    private PolicyComponent policyComponent;
    private NodeService nodeService;
    private FileFolderService fileFolderService;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onCopyNode"), ForumModel.ASPECT_DISCUSSABLE, (Behaviour)new JavaBehaviour(this, "onCopy"));
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onCopyComplete"), ForumModel.ASPECT_DISCUSSABLE, (Behaviour)new JavaBehaviour(this, "onCopyComplete"));
    }

    public void onCopy(QName sourceClassRef, NodeRef sourceNodeRef, StoreRef destinationStoreRef, boolean copyToNewNode, PolicyScope copyDetails) {
    }

    public void onCopyComplete(QName classRef, NodeRef sourceNodeRef, NodeRef destinationRef, boolean copyNewNode, Map<NodeRef, NodeRef> copyMap) {
        if (!copyNewNode) {
            List<ChildAssociationRef> sourceChildren = this.nodeService.getChildAssocs(sourceNodeRef, ForumModel.ASSOC_DISCUSSION, RegexQNamePattern.MATCH_ALL);
            if (sourceChildren.size() != 1) {
                throw new CheckOutCheckInServiceException("The source node has the discussable aspect but does not have 1 child, it has " + sourceChildren.size() + " children!");
            }
            NodeRef sourceForum = sourceChildren.get(0).getChildRef();
            NodeRef destinationForum = this.getDestinationForum(destinationRef);
            int copied = 0;
            List<ChildAssociationRef> sourceForums = this.nodeService.getChildAssocs(sourceForum);
            for (ChildAssociationRef childRef : sourceForums) {
                String topicName = null;
                NodeRef childNode = childRef.getChildRef();
                if (!this.nodeService.getType(childNode).equals(ForumModel.TYPE_TOPIC)) continue;
                try {
                    String childName = this.nodeService.getProperty(childNode, ContentModel.PROP_NAME).toString();
                    Serializable labelProp = this.nodeService.getProperty(destinationRef, ContentModel.PROP_VERSION_LABEL);
                    topicName = labelProp == null ? childName + " - " + new Date() : childName + " (" + labelProp.toString() + ")";
                    this.fileFolderService.copy(childNode, destinationForum, topicName);
                    ++copied;
                }
                catch (FileNotFoundException fnfe) {
                    throw new CheckOutCheckInServiceException("Failed to copy topic from working copy to checked out content", fnfe);
                }
                catch (FileExistsException fee) {
                    throw new CheckOutCheckInServiceException("Failed to checkin content as a topic called " + topicName + " already exists on the checked out content", fee);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Copied " + copied + " topics from the working copy to the checked out content"));
            }
        }
    }

    private NodeRef getDestinationForum(NodeRef destNodeRef) {
        NodeRef destinationForum = null;
        if (this.nodeService.hasAspect(destNodeRef, ForumModel.ASPECT_DISCUSSABLE)) {
            List<ChildAssociationRef> destChildren = this.nodeService.getChildAssocs(destNodeRef, ForumModel.ASSOC_DISCUSSION, RegexQNamePattern.MATCH_ALL);
            if (destChildren.size() != 1) {
                throw new IllegalStateException("Locked node has the discussable aspect but does not have 1 child, it has " + destChildren.size() + " children!");
            }
            destinationForum = destChildren.get(0).getChildRef();
        } else {
            this.nodeService.addAspect(destNodeRef, ForumModel.ASPECT_DISCUSSABLE, null);
            String name = (String)((Object)this.nodeService.getProperty(destNodeRef, ContentModel.PROP_NAME));
            String forumName = I18NUtil.getMessage((String)"coci_service.discussion_for", (Object[])new Object[]{name});
            HashMap<QName, Serializable> forumProps = new HashMap<QName, Serializable>(1);
            forumProps.put(ContentModel.PROP_NAME, (Serializable)((Object)forumName));
            ChildAssociationRef childRef = this.nodeService.createNode(destNodeRef, ForumModel.ASSOC_DISCUSSION, QName.createQName("http://www.alfresco.org/model/forum/1.0", "discussion"), ForumModel.TYPE_FORUM, forumProps);
            destinationForum = childRef.getChildRef();
            HashMap<QName, Serializable> uiFacetsProps = new HashMap<QName, Serializable>(5);
            uiFacetsProps.put(ContentModel.PROP_ICON, (Serializable)((Object)"forum"));
            this.nodeService.addAspect(destinationForum, ContentModel.ASPECT_UIFACETS, uiFacetsProps);
        }
        return destinationForum;
    }
}

