/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.importer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import javax.transaction.UserTransaction;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.importer.ExportSource;
import org.alfresco.repo.importer.ExportSourceImporterException;
import org.alfresco.repo.importer.ImporterJobSPI;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.view.ImporterBinding;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.TempFileProvider;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportSourceImporter
implements ImporterJobSPI {
    private ImporterService importerService;
    private ExportSource exportSource;
    private AuthenticationComponent authenticationComponent;
    private StoreRef storeRef;
    private String path;
    private boolean clearAllChildren;
    private NodeService nodeService;
    private SearchService searchService;
    private NamespacePrefixResolver namespacePrefixResolver;
    private TransactionService transactionService;
    private Set<SimpleCache> caches;
    private static ImporterBinding REPLACE_BINDING = new ImporterBinding(){

        public ImporterBinding.UUID_BINDING getUUIDBinding() {
            return ImporterBinding.UUID_BINDING.UPDATE_EXISTING;
        }

        public String getValue(String key) {
            return null;
        }

        public boolean allowReferenceWithinTransaction() {
            return false;
        }

        public QName[] getExcludedClasses() {
            return null;
        }
    };

    public void setImporterService(ImporterService importerService) {
        this.importerService = importerService;
    }

    public void setExportSource(ExportSource exportSource) {
        this.exportSource = exportSource;
    }

    public void setClearAllChildren(boolean clearAllChildren) {
        this.clearAllChildren = clearAllChildren;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setStoreRef(String storeRef) {
        this.storeRef = new StoreRef(storeRef);
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setCaches(Set<SimpleCache> caches) {
        this.caches = caches;
    }

    public void setAuthenticationComponent(AuthenticationComponent authenticationComponent) {
        this.authenticationComponent = authenticationComponent;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    @Override
    public void doImport() {
        UserTransaction userTransaction = null;
        try {
            userTransaction = this.transactionService.getUserTransaction();
            userTransaction.begin();
            this.authenticationComponent.setSystemUserAsCurrentUser();
            if (this.clearAllChildren) {
                List<NodeRef> refs = this.searchService.selectNodes(this.nodeService.getRootNode(this.storeRef), this.path, null, this.namespacePrefixResolver, false);
                for (NodeRef ref : refs) {
                    for (ChildAssociationRef car : this.nodeService.getChildAssocs(ref)) {
                        this.nodeService.deleteNode(car.getChildRef());
                    }
                }
            }
            if (this.caches != null) {
                for (SimpleCache cache : this.caches) {
                    cache.clear();
                }
            }
            File tempFile = TempFileProvider.createTempFile((String)"ExportSourceImporter-", (String)".xml");
            BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile));
            XMLWriter xmlWriter = this.createXMLExporter(writer);
            this.exportSource.generateExport(xmlWriter);
            xmlWriter.close();
            BufferedReader reader = new BufferedReader(new FileReader(tempFile));
            Location location = new Location(this.storeRef);
            location.setPath(this.path);
            this.importerService.importView(reader, location, REPLACE_BINDING, null);
            ((Reader)reader).close();
            if (this.caches != null) {
                for (SimpleCache cache : this.caches) {
                    cache.clear();
                }
            }
            userTransaction.commit();
        }
        catch (Throwable t) {
            try {
                if (userTransaction != null) {
                    userTransaction.rollback();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.authenticationComponent.clearCurrentSecurityContext();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ExportSourceImporterException("Failed to import", t);
        }
        finally {
            this.authenticationComponent.clearCurrentSecurityContext();
        }
    }

    private XMLWriter createXMLExporter(Writer writer) {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setNewLineAfterDeclaration(false);
        format.setIndentSize(3);
        format.setEncoding("UTF-8");
        XMLWriter xmlWriter = new XMLWriter(writer, format);
        return xmlWriter;
    }
}

